/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ConfigurationException;

public class ThrottleSettings {
    public static final int POLICY_NONE = 0;
    public static final int POLICY_ERROR = 1;
    public static final int POLICY_IGNORE = 2;
    public static final int POLICY_REPLACE = 3;
    public static final String POLICY_NONE_STRING = "NONE";
    public static final String POLICY_ERROR_STRING = "ERROR";
    public static final String POLICY_IGNORE_STRING = "IGNORE";
    public static final String POLICY_REPLACE_STRING = "REPLACE";
    public static final String ELEMENT_INBOUND = "throttle-inbound";
    public static final String ELEMENT_OUTBOUND = "throttle-outbound";
    public static final String ELEMENT_POLICY = "policy";
    public static final String ELEMENT_DEST_FREQ = "max-frequency";
    public static final String ELEMENT_CLIENT_FREQ = "max-client-frequency";
    private String destinationName;
    private int inClientMessagesPerSec = 0;
    private int inDestinationMessagesPerSec = 0;
    private int outClientMessagesPerSec;
    private int outDestinationMessagesPerSec = 0;
    private int inPolicy = 0;
    private int outPolicy = 0;

    public static int parsePolicy(String policy) {
        if (POLICY_NONE_STRING.equalsIgnoreCase(policy)) {
            return 0;
        }
        if (POLICY_IGNORE_STRING.equalsIgnoreCase(policy)) {
            return 2;
        }
        if (POLICY_ERROR_STRING.equalsIgnoreCase(policy)) {
            return 1;
        }
        if (POLICY_REPLACE_STRING.equalsIgnoreCase(policy)) {
            return 3;
        }
        ConfigurationException ex2 = new ConfigurationException();
        ex2.setMessage("Unsupported throttle policy '" + policy + "'");
        throw ex2;
    }

    public boolean isClientThrottleEnabled() {
        return this.getIncomingClientFrequency() > 0 || this.getOutgoingClientFrequency() > 0;
    }

    public boolean isDestinationThrottleEnabled() {
        return this.getIncomingDestinationFrequency() > 0 || this.getOutgoingDestinationFrequency() > 0;
    }

    public int getInboundPolicy() {
        return this.inPolicy;
    }

    public void setInboundPolicy(int inPolicy) {
        if (inPolicy == 3) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage("The REPLACE throttle policy applies to outbound throttling only");
            throw ex2;
        }
        this.inPolicy = inPolicy;
    }

    public int getOutboundPolicy() {
        return this.outPolicy;
    }

    public void setOutboundPolicy(int outPolicy) {
        this.outPolicy = outPolicy;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public int getIncomingClientFrequency() {
        return this.inClientMessagesPerSec;
    }

    public void setIncomingClientFrequency(int n10) {
        if (this.inDestinationMessagesPerSec > 0 && n10 > this.inDestinationMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage("The incoming client frequency '" + n10 + "' cannot be more than the incoming destination frequency '" + this.inDestinationMessagesPerSec + "'");
            throw ex2;
        }
        this.inClientMessagesPerSec = n10;
    }

    public int getIncomingDestinationFrequency() {
        return this.inDestinationMessagesPerSec;
    }

    public void setIncomingDestinationFrequency(int n10) {
        if (n10 < this.inClientMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage("The incoming destination frequency '" + n10 + "' cannot be less than the incoming client frequency '" + this.inClientMessagesPerSec + "'");
            throw ex2;
        }
        this.inDestinationMessagesPerSec = n10;
    }

    public int getOutgoingClientFrequency() {
        return this.outClientMessagesPerSec;
    }

    public void setOutgoingClientFrequency(int n10) {
        if (this.outDestinationMessagesPerSec > 0 && n10 > this.outDestinationMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage("The outgoing client frequency '" + n10 + "' cannot be more than the outgoing destination frequency '" + this.outDestinationMessagesPerSec + "'");
            throw ex2;
        }
        this.outClientMessagesPerSec = n10;
    }

    public int getOutgoingDestinationFrequency() {
        return this.outDestinationMessagesPerSec;
    }

    public void setOutgoingDestinationFrequency(int n10) {
        if (n10 < this.outClientMessagesPerSec) {
            ConfigurationException ex2 = new ConfigurationException();
            ex2.setMessage("The outgoing destination frequency '" + n10 + "' cannot be less than the outgoing client frequency '" + this.outClientMessagesPerSec + "'");
            throw ex2;
        }
        this.outDestinationMessagesPerSec = n10;
    }
}

