/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.Server;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.client.FlushResult;
import flex.messaging.client.PollFlushResult;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationConstants;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AcknowledgeMessageExt;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.AsyncMessageExt;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.CommandMessageExt;
import flex.messaging.messages.Message;
import flex.messaging.messages.SmallMessage;
import flex.messaging.security.SecurityException;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractEndpoint
extends ManageableComponent
implements Endpoint2,
ConfigurationConstants {
    public static final String LOG_CATEGORY = "Endpoint.General";
    private static final int NONSECURE_PROTOCOL = 10066;
    private static final int REQUIRES_FLEXCLIENT_SUPPORT = 10030;
    private static final String SERIALIZATION = "serialization";
    private static final String CREATE_ASOBJECT_FOR_MISSING_TYPE = "create-asobject-for-missing-type";
    private static final String CUSTOM_DESERIALIZER = "custom-deserializer";
    private static final String CUSTOM_SERIALIZER = "custom-serializer";
    private static final String ENABLE_SMALL_MESSAGES = "enable-small-messages";
    private static final String TYPE_MARSHALLER = "type-marshaller";
    private static final String RESTORE_REFERENCES = "restore-references";
    private static final String INSTANTIATE_TYPES = "instantiate-types";
    private static final String SUPPORT_REMOTE_CLASS = "support-remote-class";
    private static final String LEGACY_COLLECTION = "legacy-collection";
    private static final String LEGACY_MAP = "legacy-map";
    private static final String LEGACY_XML = "legacy-xml";
    private static final String LEGACY_XML_NAMESPACES = "legacy-xml-namespaces";
    private static final String LEGACY_THROWABLE = "legacy-throwable";
    private static final String LEGACY_BIG_NUMBERS = "legacy-big-numbers";
    private static final String LEGACY_EXTERNALIZABLE = "legacy-externalizable";
    private static final String LOG_PROPERTY_ERRORS = "log-property-errors";
    private static final String IGNORE_PROPERTY_ERRORS = "ignore-property-errors";
    private static final String CONNECT_TIMEOUT_SECONDS = "connect-timeout-seconds";
    private static final String FLEX_CLIENT_OUTBOUND_QUEUE_PROCESSOR = "flex-client-outbound-queue-processor";
    private static final String SHOW_STACKTRACES = "show-stacktraces";
    protected String clientType;
    protected int connectTimeoutSeconds;
    protected FlexClientOutboundQueueProcessor flexClientOutboundQueueProcessor;
    protected SerializationContext serializationContext;
    protected Class deserializerClass;
    protected Class serializerClass;
    protected TypeMarshaller typeMarshaller;
    protected int port;
    private SecurityConstraint securityConstraint;
    protected String url;
    protected boolean recordMessageSizes;
    protected boolean recordMessageTimes;
    protected Server server;
    protected String parsedUrl;
    protected String parsedForContext;
    protected boolean clientContextParsed;
    protected String parsedClientUrl;
    protected Logger log = Log.getLogger(this.getLogCategory());
    protected Class flexClientOutboundQueueProcessClass;
    protected ConfigMap flexClientOutboundQueueProcessorConfig;
    protected double messagingVersion = 1.0;

    public AbstractEndpoint() {
        this(false);
    }

    public AbstractEndpoint(boolean enableManagement) {
        super(enableManagement);
        this.serializationContext = new SerializationContext();
    }

    public void initialize(String id2, ConfigMap properties) {
        ConfigMap serialization;
        block13: {
            super.initialize(id2, properties);
            if (properties == null || properties.size() == 0) {
                return;
            }
            this.connectTimeoutSeconds = properties.getPropertyAsInt(CONNECT_TIMEOUT_SECONDS, 0);
            ConfigMap outboundQueueConfig = properties.getPropertyAsMap(FLEX_CLIENT_OUTBOUND_QUEUE_PROCESSOR, null);
            if (outboundQueueConfig != null) {
                this.flexClientOutboundQueueProcessorConfig = outboundQueueConfig.getPropertyAsMap("properties", null);
                String pClassName = outboundQueueConfig.getPropertyAsString("class", null);
                if (pClassName != null) {
                    try {
                        this.flexClientOutboundQueueProcessClass = this.createClass(pClassName);
                        this.setFlexClientOutboundQueueProcessorConfig(this.flexClientOutboundQueueProcessorConfig);
                    }
                    catch (Throwable t10) {
                        if (!Log.isWarn()) break block13;
                        this.log.warn("Cannot register custom FlexClient outbound queue processor class {1}", new Object[]{pClassName}, t10);
                    }
                }
            }
        }
        if ((serialization = properties.getPropertyAsMap(SERIALIZATION, null)) != null) {
            block14: {
                String typeMarshallerClassName;
                List serializers;
                List deserializers = serialization.getPropertyAsList(CUSTOM_DESERIALIZER, null);
                if (deserializers != null && Log.isWarn()) {
                    this.log.warn("Endpoint <custom-deserializer> functionality is no longer available. Please remove this entry from your configuration.");
                }
                if ((serializers = serialization.getPropertyAsList(CUSTOM_SERIALIZER, null)) != null && Log.isWarn()) {
                    this.log.warn("Endpoint <custom-serializer> functionality is no longer available. Please remove this entry from your configuration.");
                }
                if ((typeMarshallerClassName = serialization.getPropertyAsString(TYPE_MARSHALLER, null)) != null && typeMarshallerClassName.length() > 0) {
                    try {
                        Class tmc = this.createClass(typeMarshallerClassName);
                        this.typeMarshaller = (TypeMarshaller)ClassUtil.createDefaultInstance(tmc, TypeMarshaller.class);
                    }
                    catch (Throwable t11) {
                        if (!Log.isWarn()) break block14;
                        this.log.warn("Cannot register custom type marshaller for type {0}", new Object[]{typeMarshallerClassName}, t11);
                    }
                }
            }
            this.serializationContext.createASObjectForMissingType = serialization.getPropertyAsBoolean(CREATE_ASOBJECT_FOR_MISSING_TYPE, false);
            this.serializationContext.enableSmallMessages = serialization.getPropertyAsBoolean(ENABLE_SMALL_MESSAGES, true);
            this.serializationContext.instantiateTypes = serialization.getPropertyAsBoolean(INSTANTIATE_TYPES, true);
            this.serializationContext.supportRemoteClass = serialization.getPropertyAsBoolean(SUPPORT_REMOTE_CLASS, false);
            this.serializationContext.legacyCollection = serialization.getPropertyAsBoolean(LEGACY_COLLECTION, false);
            this.serializationContext.legacyMap = serialization.getPropertyAsBoolean(LEGACY_MAP, false);
            this.serializationContext.legacyXMLDocument = serialization.getPropertyAsBoolean(LEGACY_XML, false);
            this.serializationContext.legacyXMLNamespaces = serialization.getPropertyAsBoolean(LEGACY_XML_NAMESPACES, false);
            this.serializationContext.legacyThrowable = serialization.getPropertyAsBoolean(LEGACY_THROWABLE, false);
            this.serializationContext.legacyBigNumbers = serialization.getPropertyAsBoolean(LEGACY_BIG_NUMBERS, false);
            this.serializationContext.legacyExternalizable = serialization.getPropertyAsBoolean(LEGACY_EXTERNALIZABLE, false);
            boolean showStacktraces = serialization.getPropertyAsBoolean(SHOW_STACKTRACES, false);
            if (showStacktraces && Log.isWarn()) {
                this.log.warn("The show-stacktraces configuration option is deprecated and non-functional. Please remove this from your configuration file.");
            }
            this.serializationContext.restoreReferences = serialization.getPropertyAsBoolean(RESTORE_REFERENCES, false);
            this.serializationContext.logPropertyErrors = serialization.getPropertyAsBoolean(LOG_PROPERTY_ERRORS, false);
            this.serializationContext.ignorePropertyErrors = serialization.getPropertyAsBoolean(IGNORE_PROPERTY_ERRORS, true);
        }
        this.recordMessageSizes = properties.getPropertyAsBoolean("record-message-sizes", false);
        if (this.recordMessageSizes && Log.isWarn()) {
            this.log.warn("Setting <record-message-sizes> to true affects application performance and should only be used for debugging");
        }
        this.recordMessageTimes = properties.getPropertyAsBoolean("record-message-times", false);
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        MessageBroker broker = this.getMessageBroker();
        if (!broker.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger(this.getLogCategory()).warn("Endpoint with id '{0}' cannot be started when the MessageBroker is not started.", new Object[]{this.getId()});
            }
            return;
        }
        if (this.isManaged() && broker.isManaged()) {
            this.setupEndpointControl(broker);
            MessageBrokerControl controller = (MessageBrokerControl)broker.getControl();
            if (this.getControl() != null) {
                controller.addEndpoint(this);
            }
        }
        if (this.deserializerClass == null) {
            this.deserializerClass = this.createClass(this.getDeserializerClassName());
        }
        if (this.serializerClass == null) {
            String serializerClassName = null;
            try {
                serializerClassName = this.getSerializerJava15ClassName();
                this.serializerClass = this.createClass(serializerClassName);
            }
            catch (Throwable t10) {
                serializerClassName = this.getSerializerClassName();
                this.serializerClass = this.createClass(serializerClassName);
            }
        }
        this.serializationContext.setDeserializerClass(this.deserializerClass);
        this.serializationContext.setSerializerClass(this.serializerClass);
        ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
        registry.registerAlias("DSA", AsyncMessageExt.class.getName());
        registry.registerAlias("DSK", AcknowledgeMessageExt.class.getName());
        registry.registerAlias("DSC", CommandMessageExt.class.getName());
        super.start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.isManaged() && this.getMessageBroker().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String type) {
        this.clientType = type;
    }

    public Class getFlexClientOutboundQueueProcessorClass() {
        return this.flexClientOutboundQueueProcessClass;
    }

    public void setFlexClientOutboundQueueProcessorClass(Class flexClientOutboundQueueProcessorClass) {
        this.flexClientOutboundQueueProcessClass = flexClientOutboundQueueProcessorClass;
        if (this.flexClientOutboundQueueProcessClass != null && this.flexClientOutboundQueueProcessorConfig != null) {
            FlexClientOutboundQueueProcessor processor = (FlexClientOutboundQueueProcessor)ClassUtil.createDefaultInstance(this.flexClientOutboundQueueProcessClass, null);
            processor.initialize(this.flexClientOutboundQueueProcessorConfig);
        }
    }

    public ConfigMap getFlexClientOutboundQueueProcessorConfig() {
        return this.flexClientOutboundQueueProcessorConfig;
    }

    public void setFlexClientOutboundQueueProcessorConfig(ConfigMap flexClientOutboundQueueProcessorConfig) {
        this.flexClientOutboundQueueProcessorConfig = flexClientOutboundQueueProcessorConfig;
        if (flexClientOutboundQueueProcessorConfig != null && this.flexClientOutboundQueueProcessClass != null) {
            FlexClientOutboundQueueProcessor processor = (FlexClientOutboundQueueProcessor)ClassUtil.createDefaultInstance(this.flexClientOutboundQueueProcessClass, null);
            processor.initialize(flexClientOutboundQueueProcessorConfig);
        }
    }

    public void setId(String id2) {
        String oldId = this.getId();
        if (oldId != null && oldId.equals(id2)) {
            return;
        }
        super.setId(id2);
        MessageBroker broker = this.getMessageBroker();
        if (broker != null) {
            broker.removeEndpoint(oldId);
            broker.addEndpoint(this);
        }
    }

    public MessageBroker getMessageBroker() {
        return (MessageBroker)this.getParent();
    }

    public void setMessageBroker(MessageBroker broker) {
        MessageBroker oldBroker = this.getMessageBroker();
        this.setParent(broker);
        if (oldBroker != null) {
            oldBroker.removeEndpoint(this.getId());
        }
        if (broker.getEndpoint(this.getId()) != this) {
            broker.addEndpoint(this);
        }
    }

    public double getMessagingVersion() {
        return this.messagingVersion;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return false;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public SecurityConstraint getSecurityConstraint() {
        return this.securityConstraint;
    }

    public void setSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public void setSerializationContext(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    public TypeMarshaller getTypeMarshaller() {
        if (this.typeMarshaller == null) {
            String typeMarshallerClassName = null;
            Class typeMarshallerClass = null;
            try {
                typeMarshallerClassName = "flex.messaging.io.Java15TypeMarshaller";
                typeMarshallerClass = this.createClass(typeMarshallerClassName);
            }
            catch (Throwable t10) {
                typeMarshallerClassName = "flex.messaging.io.amf.translator.ASTranslator";
                typeMarshallerClass = this.createClass(typeMarshallerClassName);
            }
            this.typeMarshaller = (TypeMarshaller)ClassUtil.createDefaultInstance(typeMarshallerClass, TypeMarshaller.class);
        }
        return this.typeMarshaller;
    }

    public void setTypeMarshaller(TypeMarshaller typeMarshaller) {
        this.typeMarshaller = typeMarshaller;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.port = this.parsePort(url);
        this.parsedForContext = null;
        this.clientContextParsed = false;
    }

    public String getUrlForClient() {
        if (!this.clientContextParsed) {
            HttpServletRequest req = FlexContext.getHttpRequest();
            if (req != null) {
                String contextPath = req.getContextPath();
                this.parseClientUrl(contextPath);
            } else {
                return this.url;
            }
        }
        return this.parsedClientUrl;
    }

    public long getThroughput() {
        EndpointControl control = (EndpointControl)this.getControl();
        return control.getBytesDeserialized() + control.getBytesSerialized();
    }

    public static void addNoCacheHeaders(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Cache-Control", "no-cache");
        res.setDateHeader("Expires", 946080000000L);
        String userAgent = req.getHeader("User-Agent");
        if (!req.isSecure() || userAgent == null || userAgent.indexOf("MSIE") == -1) {
            res.setHeader("Pragma", "no-cache");
        }
    }

    public Message convertToSmallMessage(Message message) {
        Message smallMessage;
        if (message instanceof SmallMessage && (smallMessage = ((SmallMessage)message).getSmallMessage()) != null) {
            message = smallMessage;
        }
        return message;
    }

    public ConfigMap describeEndpoint() {
        ConfigMap channelConfig = new ConfigMap();
        channelConfig.addProperty("id", this.getId());
        channelConfig.addProperty("type", this.getClientType());
        ConfigMap endpointConfig = new ConfigMap();
        endpointConfig.addProperty("uri", this.getUrlForClient());
        channelConfig.addProperty("endpoint", endpointConfig);
        ConfigMap properties = new ConfigMap();
        if (this.connectTimeoutSeconds > 0) {
            ConfigMap connectTimeoutConfig = new ConfigMap();
            connectTimeoutConfig.addProperty("", String.valueOf(this.connectTimeoutSeconds));
            properties.addProperty(CONNECT_TIMEOUT_SECONDS, connectTimeoutConfig);
        }
        if (this.recordMessageTimes) {
            ConfigMap recordMessageTimesMap = new ConfigMap();
            recordMessageTimesMap.addProperty("", "true");
            properties.addProperty("record-message-times", recordMessageTimesMap);
        }
        if (this.recordMessageSizes) {
            ConfigMap recordMessageSizessMap = new ConfigMap();
            recordMessageSizessMap.addProperty("", "true");
            properties.addProperty("record-message-sizes", recordMessageSizessMap);
        }
        ConfigMap serialization = new ConfigMap();
        serialization.addProperty(ENABLE_SMALL_MESSAGES, Boolean.toString(this.serializationContext.enableSmallMessages));
        properties.addProperty(SERIALIZATION, serialization);
        if (properties.size() > 0) {
            channelConfig.addProperty("properties", properties);
        }
        return channelConfig;
    }

    public String getParsedUrl(String contextPath) {
        this.parseUrl(contextPath);
        return this.parsedUrl;
    }

    public void handleClientMessagingVersion(Number version) {
        if (version != null) {
            FlexSession session;
            boolean clientSupportsSmallMessages;
            boolean bl2 = clientSupportsSmallMessages = version.doubleValue() >= this.messagingVersion;
            if (clientSupportsSmallMessages && this.getSerializationContext().enableSmallMessages && (session = FlexContext.getFlexSession()) != null) {
                session.setUseSmallMessages(true);
            }
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) {
        this.validateRequestProtocol(req);
    }

    public Message serviceMessage(Message message) {
        if (this.isManaged()) {
            ((EndpointControl)this.getControl()).incrementServiceMessageCount();
        }
        Message ack = null;
        if (message.getTimestamp() == 0L) {
            message.setTimestamp(System.currentTimeMillis());
        }
        if (message.getHeader("DSEndpoint") != null) {
            message.setHeader("DSValidateEndpoint", Boolean.TRUE);
        }
        message.setHeader("DSEndpoint", this.getId());
        if (message instanceof CommandMessage) {
            CommandMessage command = (CommandMessage)message;
            int operation = command.getOperation();
            if (operation != 8) {
                this.checkSecurityConstraint(message);
            }
            if (operation == 2 && message.getClientId() == null) {
                this.verifyFlexClientSupport(command);
                FlexClient flexClient = FlexContext.getFlexClient();
                ack = this.handleFlexClientPollCommand(flexClient, command);
            } else if (operation == 12) {
                ack = this.handleChannelDisconnect(command);
            } else if (operation == 13) {
                ack = new AcknowledgeMessage();
            } else {
                if (operation == 0 || operation == 2) {
                    this.verifyFlexClientSupport(command);
                }
                ack = this.getMessageBroker().routeCommandToService((CommandMessage)message, this);
                if (operation == 5 || operation == 8) {
                    Number clientVersion = (Number)command.getHeader("DSMessagingVersion");
                    this.handleClientMessagingVersion(clientVersion);
                    ack.setHeader("DSMessagingVersion", new Double(this.messagingVersion));
                }
            }
        } else {
            if (message instanceof AsyncMessage) {
                this.verifyFlexClientSupport(message);
            }
            this.checkSecurityConstraint(message);
            ack = this.getMessageBroker().routeMessageToService(message, this);
        }
        return ack;
    }

    public FlexClient setupFlexClient(Message message) {
        FlexClient flexClient = null;
        if (message.getHeaders().containsKey("DSId")) {
            String id2 = (String)message.getHeaders().get("DSId");
            if (id2 == null) {
                id2 = "nil";
            }
            flexClient = this.setupFlexClient(id2);
        }
        return flexClient;
    }

    public FlexClient setupFlexClient(String id2) {
        FlexClient flexClient = null;
        if (id2 != null) {
            if (id2.equals("nil")) {
                id2 = null;
            }
            flexClient = this.getMessageBroker().getFlexClientManager().getFlexClient(id2);
            FlexSession session = FlexContext.getFlexSession();
            flexClient.registerFlexSession(session);
            FlexContext.setThreadLocalFlexClient(flexClient);
        }
        return flexClient;
    }

    public boolean isRecordMessageSizes() {
        return this.recordMessageSizes;
    }

    public boolean isRecordMessageTimes() {
        return this.recordMessageTimes;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected Message handleChannelDisconnect(CommandMessage disconnectCommand) {
        return new AcknowledgeMessage();
    }

    protected FlushResult handleFlexClientPoll(FlexClient flexClient, CommandMessage pollCommand) {
        return flexClient.poll(this.getId());
    }

    protected Message handleFlexClientPollCommand(FlexClient flexClient, CommandMessage pollCommand) {
        int nextFlushWaitTime;
        if (Log.isDebug()) {
            Log.getLogger(this.getMessageBroker().getLogCategory(pollCommand)).debug("Before handling general client poll request. " + StringUtils.NEWLINE + "  incomingMessage: " + pollCommand + StringUtils.NEWLINE);
        }
        FlushResult flushResult = this.handleFlexClientPoll(flexClient, pollCommand);
        AsyncMessage pollResponse = null;
        if (flushResult instanceof PollFlushResult && ((PollFlushResult)flushResult).isClientProcessingSuppressed()) {
            pollResponse = new CommandMessage(4);
            pollResponse.setHeader("DSNoOpPoll", Boolean.TRUE);
        }
        if (pollResponse == null) {
            List messagesToReturn;
            List list = messagesToReturn = flushResult != null ? flushResult.getMessages() : null;
            if (messagesToReturn != null && !messagesToReturn.isEmpty()) {
                pollResponse = new CommandMessage(4);
                pollResponse.setBody(messagesToReturn.toArray());
            } else {
                pollResponse = new AcknowledgeMessage();
            }
        }
        if (flushResult != null && (nextFlushWaitTime = flushResult.getNextFlushWaitTimeMillis()) > 0) {
            pollResponse.setHeader("DSPollWait", new Integer(nextFlushWaitTime));
        }
        if (Log.isDebug()) {
            String debugPollResult = Log.getPrettyPrinter().prettify(pollResponse);
            Log.getLogger(this.getMessageBroker().getLogCategory(pollCommand)).debug("After handling general client poll request. " + StringUtils.NEWLINE + "  reply: " + debugPollResult + StringUtils.NEWLINE);
        }
        return pollResponse;
    }

    protected void checkSecurityConstraint(Message message) {
        if (this.securityConstraint != null) {
            this.getMessageBroker().getLoginManager().checkConstraint(this.securityConstraint);
        }
    }

    protected void setThreadLocals() {
        if (this.serializationContext != null) {
            SerializationContext.setSerializationContext((SerializationContext)this.serializationContext.clone());
        }
        TypeMarshallingContext.setTypeMarshaller(this.getTypeMarshaller());
    }

    protected void clearThreadLocals() {
        SerializationContext.clearThreadLocalObjects();
        TypeMarshallingContext.clearThreadLocalObjects();
    }

    protected abstract String getDeserializerClassName();

    protected abstract String getSerializerClassName();

    protected abstract String getSerializerJava15ClassName();

    protected abstract void setupEndpointControl(MessageBroker var1);

    protected void validateRequestProtocol(HttpServletRequest req) {
        boolean secure = req.isSecure();
        if (!secure && this.isSecure()) {
            String endpointPath = req.getServletPath() + req.getPathInfo();
            SecurityException se2 = new SecurityException();
            se2.setMessage(10066, new Object[]{endpointPath});
            throw se2;
        }
    }

    protected void verifyFlexClientSupport(Message message) {
        if (FlexContext.getFlexClient() == null) {
            MessageException me2 = new MessageException();
            me2.setMessage(10030, new Object[]{message.getDestination()});
            throw me2;
        }
    }

    protected Class createClass(String className) {
        Class c10 = ClassUtil.createClass(className, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        return c10;
    }

    private void parseClientUrl(String contextPath) {
        if (!this.clientContextParsed) {
            String channelEndpoint = this.url.trim();
            channelEndpoint = StringUtils.substitute(channelEndpoint, "{context-root}", "{context.root}");
            if (contextPath == null && channelEndpoint.indexOf("{context.root}") != -1) {
                ConfigurationException e10 = new ConfigurationException();
                e10.setMessage(11120, new Object[]{this.getId()});
                throw e10;
            }
            if (contextPath != null && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            if (channelEndpoint.indexOf("/{context.root}") != -1) {
                if ("/".equals(contextPath) && !"/{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute(channelEndpoint, "/{context.root}", contextPath);
            } else {
                if ("/".equals(contextPath) && !"{context.root}".equals(channelEndpoint)) {
                    contextPath = "";
                }
                channelEndpoint = StringUtils.substitute(channelEndpoint, "{context.root}", contextPath);
            }
            this.parsedClientUrl = channelEndpoint;
            this.clientContextParsed = true;
        }
    }

    private int parsePort(String url) {
        int port = 0;
        int start = url.indexOf(":/");
        if (start > 0) {
            int end = url.indexOf(47, start += 3);
            String snp = end == -1 ? url.substring(start) : url.substring(start, end);
            int delim = snp.indexOf("]");
            int n10 = delim = delim > -1 ? snp.indexOf(":", delim) : snp.indexOf(":");
            if (delim > 0) {
                try {
                    int p10 = Integer.parseInt(snp.substring(delim + 1));
                    if (p10 > 0) {
                        port = p10;
                    }
                }
                catch (Throwable t10) {}
            } else if (delim == -1 && Log.isInfo()) {
                this.log.info("No port specified in channel URL:  {0}", new Object[]{url});
            }
        }
        return port;
    }

    private void parseUrl(String contextPath) {
        if (this.parsedForContext == null || !this.parsedForContext.equals(contextPath)) {
            int nextSlash;
            String channelEndpoint = this.url.toLowerCase().trim();
            if ((channelEndpoint.startsWith("http://") || channelEndpoint.startsWith("https://")) && (nextSlash = channelEndpoint.indexOf(47, 8)) > 0) {
                channelEndpoint = channelEndpoint.substring(nextSlash);
            }
            if ((channelEndpoint = StringUtils.substitute(channelEndpoint, "{context-root}", "{context.root}")).startsWith("{context.root}")) {
                channelEndpoint = channelEndpoint.substring("{context.root}".length());
            } else if (channelEndpoint.startsWith("/{context.root}")) {
                channelEndpoint = channelEndpoint.substring("/{context.root}".length());
            } else if (contextPath.length() > 0 && channelEndpoint.startsWith(contextPath.toLowerCase())) {
                channelEndpoint = channelEndpoint.substring(contextPath.length());
            }
            if (channelEndpoint.endsWith("/")) {
                channelEndpoint = channelEndpoint.substring(0, channelEndpoint.length() - 1);
            }
            this.parsedUrl = channelEndpoint;
            this.parsedForContext = contextPath;
        }
    }
}

