/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlushResult;
import flex.messaging.client.PollFlushResult;
import flex.messaging.client.PollWaitListener;
import flex.messaging.client.UserAgentSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.BaseHTTPEndpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.util.UserAgentManager;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BasePollingHTTPEndpoint
extends BaseHTTPEndpoint
implements PollWaitListener {
    private static final String POLLING_ENABLED = "polling-enabled";
    private static final String POLLING_INTERVAL_MILLIS = "polling-interval-millis";
    private static final String POLLING_INTERVAL_SECONDS = "polling-interval-seconds";
    private static final String MAX_WAITING_POLL_REQUESTS = "max-waiting-poll-requests";
    private static final String WAIT_INTERVAL_MILLIS = "wait-interval-millis";
    private static final String CLIENT_WAIT_INTERVAL_MILLIS = "client-wait-interval-millis";
    private static final int DEFAULT_WAIT_FOR_EXCESS_POLL_WAIT_CLIENTS = 3000;
    private UserAgentManager userAgentManager = new UserAgentManager();
    private volatile boolean canWait;
    protected final Object lock = new Object();
    private boolean waitEnabled;
    protected int waitingPollRequestsCount;
    private ConcurrentHashMap currentWaitedRequests;
    protected int clientWaitInterval = 0;
    protected int maxWaitingPollRequests = 0;
    protected boolean piggybackingEnabled;
    protected boolean pollingEnabled;
    protected long pollingIntervalMillis;
    protected long waitInterval = 0L;

    public BasePollingHTTPEndpoint() {
        this(false);
    }

    public BasePollingHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.pollingEnabled = properties.getPropertyAsBoolean(POLLING_ENABLED, false);
        this.pollingIntervalMillis = properties.getPropertyAsLong(POLLING_INTERVAL_MILLIS, -1L);
        long pollingIntervalSeconds = properties.getPropertyAsLong(POLLING_INTERVAL_SECONDS, -1L);
        if (pollingIntervalSeconds > -1L) {
            this.pollingIntervalMillis = pollingIntervalSeconds * 1000L;
        }
        this.piggybackingEnabled = properties.getPropertyAsBoolean("piggybacking-enabled", false);
        this.maxWaitingPollRequests = properties.getPropertyAsInt(MAX_WAITING_POLL_REQUESTS, 0);
        this.waitInterval = properties.getPropertyAsLong(WAIT_INTERVAL_MILLIS, 0L);
        this.clientWaitInterval = properties.getPropertyAsInt(CLIENT_WAIT_INTERVAL_MILLIS, 0);
        UserAgentManager.setupUserAgentManager(properties, this.userAgentManager);
        if (this.maxWaitingPollRequests > 0 && (this.waitInterval == -1L || this.waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = true;
        }
    }

    public int getClientWaitInterval() {
        return this.clientWaitInterval;
    }

    public void setClientWaitInterval(int value) {
        this.clientWaitInterval = value;
    }

    public int getMaxWaitingPollRequests() {
        return this.maxWaitingPollRequests;
    }

    public void setMaxWaitingPollRequests(int maxWaitingPollRequests) {
        this.maxWaitingPollRequests = maxWaitingPollRequests;
        if (maxWaitingPollRequests > 0 && (this.waitInterval == -1L || this.waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = this.waitingPollRequestsCount < maxWaitingPollRequests;
        }
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public void setWaitInterval(long waitInterval) {
        this.waitInterval = waitInterval;
        if (this.maxWaitingPollRequests > 0 && (waitInterval == -1L || waitInterval > 0L)) {
            this.waitEnabled = true;
            this.canWait = this.waitingPollRequestsCount < this.maxWaitingPollRequests;
        }
    }

    public ConfigMap describeEndpoint() {
        ConfigMap endpointConfig = super.describeEndpoint();
        boolean createdProperties = false;
        ConfigMap properties = endpointConfig.getPropertyAsMap("properties", null);
        if (properties == null) {
            properties = new ConfigMap();
            createdProperties = true;
        }
        if (this.pollingEnabled) {
            ConfigMap pollingEnabled = new ConfigMap();
            pollingEnabled.addProperty("", "true");
            properties.addProperty(POLLING_ENABLED, pollingEnabled);
        }
        if (this.pollingIntervalMillis > -1L) {
            ConfigMap pollingInterval = new ConfigMap();
            pollingInterval.addProperty("", String.valueOf(this.pollingIntervalMillis));
            properties.addProperty(POLLING_INTERVAL_MILLIS, pollingInterval);
        }
        if (this.piggybackingEnabled) {
            ConfigMap piggybackingEnabled = new ConfigMap();
            piggybackingEnabled.addProperty("", String.valueOf(piggybackingEnabled));
            properties.addProperty("piggybacking-enabled", piggybackingEnabled);
        }
        if (createdProperties && properties.size() > 0) {
            endpointConfig.addProperty("properties", properties);
        }
        return endpointConfig;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.currentWaitedRequests = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        Iterator i$ = this.currentWaitedRequests.keySet().iterator();
        while (i$.hasNext()) {
            Object notifier;
            Object e10 = notifier = i$.next();
            synchronized (e10) {
                notifier.notifyAll();
            }
        }
        this.currentWaitedRequests = null;
        super.stop();
    }

    public void waitStart(Object notifier) {
        this.currentWaitedRequests.put(notifier, Boolean.TRUE);
    }

    public void waitEnd(Object notifier) {
        if (this.currentWaitedRequests != null) {
            this.currentWaitedRequests.remove(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlushResult handleFlexClientPoll(FlexClient flexClient, CommandMessage pollCommand) {
        FlushResult flushResult;
        block50: {
            block49: {
                Object object;
                boolean thisThreadCanWait;
                flushResult = null;
                if (!this.canWait || pollCommand.headerExists("DSSuppressPollWait")) break block49;
                FlexSession session = FlexContext.getFlexSession();
                Object object2 = this.lock;
                synchronized (object2) {
                    ++this.waitingPollRequestsCount;
                    if (this.waitingPollRequestsCount == this.maxWaitingPollRequests) {
                        thisThreadCanWait = true;
                        this.canWait = false;
                    } else if (this.waitingPollRequestsCount > this.maxWaitingPollRequests) {
                        thisThreadCanWait = false;
                        --this.waitingPollRequestsCount;
                        this.canWait = false;
                    } else {
                        thisThreadCanWait = true;
                    }
                }
                if (thisThreadCanWait) {
                    String userAgentValue = FlexContext.getHttpRequest().getHeader("User-Agent");
                    UserAgentSettings agentSettings = this.userAgentManager.match(userAgentValue);
                    Object object3 = session;
                    synchronized (object3) {
                        if (agentSettings != null) {
                            session.maxConnectionsPerSession = agentSettings.getMaxStreamingConnectionsPerSession();
                        }
                        ++session.streamingConnectionsCount;
                        if (session.streamingConnectionsCount <= session.maxConnectionsPerSession) {
                            thisThreadCanWait = true;
                        } else {
                            thisThreadCanWait = false;
                            --session.streamingConnectionsCount;
                        }
                    }
                    if (!thisThreadCanWait) {
                        object3 = this.lock;
                        synchronized (object3) {
                            --this.waitingPollRequestsCount;
                            if (this.waitingPollRequestsCount < this.maxWaitingPollRequests) {
                                this.canWait = true;
                            }
                        }
                        if (Log.isDebug()) {
                            this.log.debug("Max long-polling requests per session limit (" + session.maxConnectionsPerSession + ") has been reached, this poll won't wait.");
                        }
                    }
                }
                if (!thisThreadCanWait) break block50;
                if (Log.isDebug()) {
                    this.log.debug("Number of waiting threads for endpoint with id '" + this.getId() + "' is " + this.waitingPollRequestsCount + ".");
                }
                try {
                    flushResult = flexClient.pollWithWait(this.getId(), FlexContext.getFlexSession(), this, this.waitInterval);
                    if (flushResult != null) {
                        if (flushResult instanceof PollFlushResult && ((PollFlushResult)flushResult).isAvoidBusyPolling() && flushResult.getNextFlushWaitTimeMillis() < 3000) {
                            flushResult.setNextFlushWaitTimeMillis(3000);
                        } else if (this.clientWaitInterval > 0 && flushResult.getNextFlushWaitTimeMillis() == 0) {
                            flushResult.setNextFlushWaitTimeMillis(this.clientWaitInterval);
                        }
                    }
                    Object var12_12 = null;
                    object = this.lock;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    Object object4 = this.lock;
                    synchronized (object4) {
                        --this.waitingPollRequestsCount;
                        if (this.waitingPollRequestsCount < this.maxWaitingPollRequests) {
                            this.canWait = true;
                        }
                    }
                    object4 = session;
                    synchronized (object4) {
                        --session.streamingConnectionsCount;
                    }
                    if (Log.isDebug()) {
                        this.log.debug("Number of waiting threads for endpoint with id '" + this.getId() + "' is " + this.waitingPollRequestsCount + ".");
                    }
                    throw throwable;
                }
                synchronized (object) {
                    --this.waitingPollRequestsCount;
                    if (this.waitingPollRequestsCount < this.maxWaitingPollRequests) {
                        this.canWait = true;
                    }
                }
                object = session;
                synchronized (object) {
                    --session.streamingConnectionsCount;
                }
                if (Log.isDebug()) {
                    this.log.debug("Number of waiting threads for endpoint with id '" + this.getId() + "' is " + this.waitingPollRequestsCount + ".");
                }
                break block50;
            }
            if (Log.isDebug() && this.waitEnabled) {
                if (pollCommand.headerExists("DSSuppressPollWait")) {
                    this.log.debug("Suppressing poll wait for this request because it is part of a batch of messages to process.");
                } else {
                    this.log.debug("Max waiting poll requests limit '" + this.maxWaitingPollRequests + "' has been reached for endpoint '" + this.getId() + "'. FlexClient with id '" + flexClient.getId() + "' will poll with no wait.");
                }
            }
        }
        if (flushResult == null) {
            flushResult = super.handleFlexClientPoll(flexClient, pollCommand);
            if (this.waitEnabled && this.pollingIntervalMillis < 3000L) {
                if (flushResult == null) {
                    flushResult = new FlushResult();
                }
                flushResult.setNextFlushWaitTimeMillis(3000);
            }
        }
        return flushResult;
    }
}

