/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ClassAlias;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.util.ExceptionUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BeanProxy
extends AbstractProxy {
    static final long serialVersionUID = 7365078101695257715L;
    private static final int FAILED_PROPERTY_READ_ERROR = 10021;
    private static final int FAILED_PROPERTY_WRITE_ERROR = 10022;
    private static final int NON_READABLE_PROPERTY_ERROR = 10023;
    private static final int NON_WRITABLE_PROPERTY_ERROR = 10024;
    private static final int UNKNOWN_PROPERTY_ERROR = 10025;
    protected static final Map propertyNamesCache = new IdentityHashMap();
    protected static final Map beanPropertyCache = new IdentityHashMap();
    protected static final Map propertyDescriptorCache = new IdentityHashMap();
    protected boolean cacheProperties = true;
    protected boolean cachePropertiesDescriptors = true;
    protected Class stopClass = Object.class;
    protected static final Map ignoreProperties = new HashMap();

    public BeanProxy() {
        this(null);
    }

    public BeanProxy(Object defaultInstance) {
        super(defaultInstance);
        if (defaultInstance != null) {
            this.alias = this.getClassName(defaultInstance);
        }
    }

    public String getAlias(Object instance) {
        return this.getClassName(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPropertyNames(Object instance) {
        if (instance == null) {
            return null;
        }
        Class<?> c10 = instance.getClass();
        List<String> propertyNames = null;
        if (this.descriptor == null) {
            propertyNames = (ArrayList<String>)propertyNamesCache.get(c10);
        }
        if (propertyNames != null) {
            return propertyNames;
        }
        Map properties = this.getBeanProperties(instance);
        propertyNames = new ArrayList<String>(properties.size());
        Iterator it2 = properties.keySet().iterator();
        while (it2.hasNext()) {
            propertyNames.add(it2.next().toString());
        }
        if (this.cacheProperties && this.descriptor == null) {
            Map map = propertyNamesCache;
            synchronized (map) {
                List propertyNames2 = (List)propertyNamesCache.get(c10);
                if (propertyNames2 == null) {
                    propertyNamesCache.put(c10, propertyNames);
                } else {
                    propertyNames = propertyNames2;
                }
            }
        }
        return propertyNames;
    }

    public Class getType(Object instance, String propertyName) {
        if (instance == null || propertyName == null) {
            return null;
        }
        BeanProperty bp2 = this.getBeanProperty(instance, propertyName);
        if (bp2 != null) {
            return bp2.getType();
        }
        return null;
    }

    public Object getValue(Object instance, String propertyName) {
        if (instance == null || propertyName == null) {
            return null;
        }
        BeanProperty bp2 = this.getBeanProperty(instance, propertyName);
        if (bp2 != null) {
            return this.getBeanValue(instance, bp2);
        }
        SerializationContext context = this.getSerializationContext();
        if (!this.ignorePropertyErrors(context)) {
            MessageException ex2 = new MessageException();
            ex2.setMessage(10025, new Object[]{propertyName, this.getAlias(instance)});
            throw ex2;
        }
        return null;
    }

    protected final Object getBeanValue(Object instance, BeanProperty bp2) {
        String propertyName = bp2.getName();
        if (bp2.isRead()) {
            try {
                SerializationDescriptor subDescriptor;
                Object value = bp2.get(instance);
                if (value != null && this.descriptor != null && (subDescriptor = (SerializationDescriptor)this.descriptor.get(propertyName)) != null) {
                    PropertyProxy subProxy = PropertyProxyRegistry.getProxyAndRegister(value);
                    subProxy = (PropertyProxy)subProxy.clone();
                    subProxy.setDescriptor(subDescriptor);
                    subProxy.setDefaultInstance(value);
                    value = subProxy;
                }
                return value;
            }
            catch (Exception e10) {
                SerializationContext context = this.getSerializationContext();
                if (Log.isWarn() && this.logPropertyErrors(context)) {
                    Logger log = Log.getLogger("Endpoint.Type");
                    log.warn("Failed to get property {0} on type {1}.", new Object[]{propertyName, this.getAlias(instance)}, e10);
                }
                if (!this.ignorePropertyErrors(context)) {
                    MessageException ex2 = new MessageException();
                    ex2.setMessage(10021, new Object[]{propertyName, this.getAlias(instance)});
                    ex2.setRootCause(e10);
                    throw ex2;
                }
            }
        } else {
            SerializationContext context = this.getSerializationContext();
            if (!this.ignorePropertyErrors(context)) {
                MessageException ex3 = new MessageException();
                ex3.setMessage(10023, new Object[]{propertyName, this.getAlias(instance)});
                throw ex3;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object instance, String propertyName, Object value) {
        BeanProperty bp2 = this.getBeanProperty(instance, propertyName);
        if (bp2 != null) {
            if (bp2.isWrite()) {
                try {
                    Class desiredPropClass = bp2.getType();
                    TypeMarshaller marshaller = TypeMarshallingContext.getTypeMarshaller();
                    value = marshaller.convert(value, desiredPropClass);
                    bp2.set(instance, value);
                    return;
                }
                catch (Exception e10) {
                    SerializationContext context = this.getSerializationContext();
                    if (Log.isWarn() && this.logPropertyErrors(context)) {
                        Logger log = Log.getLogger("Endpoint.Type");
                        log.warn("Failed to set property {0} on type {1}.", new Object[]{propertyName, this.getAlias(instance)}, e10);
                    }
                    if (this.ignorePropertyErrors(context)) return;
                    MessageException ex2 = new MessageException();
                    ex2.setMessage(10022, new Object[]{propertyName, this.getAlias(instance)});
                    ex2.setRootCause(e10);
                    throw ex2;
                }
            }
            SerializationContext context = this.getSerializationContext();
            if (Log.isWarn() && this.logPropertyErrors(context)) {
                Logger log = Log.getLogger("Endpoint.Type");
                log.warn("Property {0} not writable on class {1}", new Object[]{propertyName, this.getAlias(instance)});
            }
            if (this.ignorePropertyErrors(context)) return;
            MessageException ex3 = new MessageException();
            ex3.setMessage(10024, new Object[]{propertyName, this.getAlias(instance)});
            throw ex3;
        }
        SerializationContext context = this.getSerializationContext();
        if (Log.isWarn() && this.logPropertyErrors(context)) {
            Logger log = Log.getLogger("Endpoint.Type");
            log.warn("Ignoring set property {0} for type {1} as a setter could not be found.", new Object[]{propertyName, this.getAlias(instance)});
        }
        if (this.ignorePropertyErrors(context)) return;
        MessageException ex4 = new MessageException();
        ex4.setMessage(10025, new Object[]{propertyName, this.getAlias(instance)});
        throw ex4;
    }

    protected boolean ignorePropertyErrors(SerializationContext context) {
        return context.ignorePropertyErrors;
    }

    protected boolean logPropertyErrors(SerializationContext context) {
        return context.logPropertyErrors;
    }

    protected String getClassName(Object instance) {
        String className;
        if (instance instanceof ASObject) {
            className = ((ASObject)instance).getType();
        } else if (instance instanceof ClassAlias) {
            className = ((ClassAlias)instance).getAlias();
        } else {
            className = instance.getClass().getName();
            ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
            String aliasedClass = registry.getClassName(className);
            className = aliasedClass == null ? className : aliasedClass;
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getBeanProperties(Object instance) {
        Map<String, BeanProperty> props;
        Class<?> c10 = instance.getClass();
        if (this.descriptor == null && (props = (Map)beanPropertyCache.get(c10)) != null) {
            return props;
        }
        props = new HashMap();
        PropertyDescriptor[] pds = this.getPropertyDescriptors(c10);
        if (pds == null) {
            return null;
        }
        List excludes = null;
        if (this.descriptor != null && (excludes = this.descriptor.getExcludesForInstance(instance)) == null) {
            excludes = this.descriptor.getExcludes();
        }
        for (int i10 = 0; i10 < pds.length; ++i10) {
            PropertyDescriptor pd2 = pds[i10];
            String propertyName = pd2.getName();
            Method readMethod = pd2.getReadMethod();
            Method writeMethod = pd2.getWriteMethod();
            if (readMethod == null || !BeanProxy.isPublicAccessor(readMethod.getModifiers()) || !this.includeReadOnly && writeMethod == null || excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c10, propertyName)) continue;
            props.put(propertyName, new BeanProperty(propertyName, pd2.getPropertyType(), readMethod, writeMethod, null));
        }
        Field[] fields = instance.getClass().getFields();
        for (int i11 = 0; i11 < fields.length; ++i11) {
            Field field = fields[i11];
            String propertyName = field.getName();
            int modifiers = field.getModifiers();
            if (!BeanProxy.isPublicField(modifiers) || props.containsKey(propertyName) || excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c10, propertyName)) continue;
            props.put(propertyName, new BeanProperty(propertyName, field.getType(), null, null, field));
        }
        if (this.descriptor == null && this.cacheProperties) {
            Map map = beanPropertyCache;
            synchronized (map) {
                Map props2 = (Map)beanPropertyCache.get(c10);
                if (props2 == null) {
                    beanPropertyCache.put(c10, props);
                } else {
                    props = props2;
                }
            }
        }
        return props;
    }

    protected final BeanProperty getBeanProperty(Object instance, String propertyName) {
        Class<?> c10 = instance.getClass();
        if (this.descriptor == null && this.cacheProperties) {
            Map props = this.getBeanProperties(instance);
            if (props != null) {
                return (BeanProperty)props.get(propertyName);
            }
            return null;
        }
        PropertyDescriptorCacheEntry pce = this.getPropertyDescriptorCacheEntry(c10);
        if (pce == null) {
            return null;
        }
        Object pType = pce.propertiesByName.get(propertyName);
        if (pType == null) {
            return null;
        }
        List excludes = null;
        if (this.descriptor != null && (excludes = this.descriptor.getExcludesForInstance(instance)) == null) {
            excludes = this.descriptor.getExcludes();
        }
        if (pType instanceof PropertyDescriptor) {
            PropertyDescriptor pd2 = (PropertyDescriptor)pType;
            Method readMethod = pd2.getReadMethod();
            Method writeMethod = pd2.getWriteMethod();
            if (readMethod != null && BeanProxy.isPublicAccessor(readMethod.getModifiers())) {
                if (!this.includeReadOnly && writeMethod == null) {
                    return null;
                }
                if (excludes != null && excludes.contains(propertyName)) {
                    return null;
                }
                if (BeanProxy.isPropertyIgnored(c10, propertyName)) {
                    return null;
                }
                return new BeanProperty(propertyName, pd2.getPropertyType(), readMethod, writeMethod, null);
            }
        } else if (pType instanceof Field) {
            Field field = (Field)pType;
            String pName = field.getName();
            int modifiers = field.getModifiers();
            if (BeanProxy.isPublicField(modifiers) && pName.equals(propertyName)) {
                if (excludes != null && excludes.contains(propertyName)) {
                    return null;
                }
                if (BeanProxy.isPropertyIgnored(c10, propertyName)) {
                    return null;
                }
                return new BeanProperty(propertyName, field.getType(), null, null, field);
            }
        }
        return null;
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class c10) {
        PropertyDescriptorCacheEntry pce = this.getPropertyDescriptorCacheEntry(c10);
        if (pce == null) {
            return null;
        }
        return pce.propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyDescriptorCacheEntry getPropertyDescriptorCacheEntry(Class c10) {
        PropertyDescriptorCacheEntry pce;
        block8: {
            pce = (PropertyDescriptorCacheEntry)propertyDescriptorCache.get(c10);
            try {
                if (pce != null) break block8;
                BeanInfo beanInfo = Introspector.getBeanInfo(c10, this.stopClass);
                pce = new PropertyDescriptorCacheEntry();
                pce.propertyDescriptors = beanInfo.getPropertyDescriptors();
                pce.propertiesByName = this.createPropertiesByNameMap(pce.propertyDescriptors, c10.getFields());
                if (!this.cachePropertiesDescriptors) break block8;
                Map map = propertyDescriptorCache;
                synchronized (map) {
                    PropertyDescriptorCacheEntry pce2 = (PropertyDescriptorCacheEntry)propertyDescriptorCache.get(c10);
                    if (pce2 == null) {
                        propertyDescriptorCache.put(c10, pce);
                    } else {
                        pce = pce2;
                    }
                }
            }
            catch (IntrospectionException ex2) {
                if (Log.isError()) {
                    Logger log = Log.getLogger("Endpoint.Type");
                    log.error("Failed to introspect object of type: " + c10 + " error: " + ExceptionUtil.toString(ex2));
                }
                pce = new PropertyDescriptorCacheEntry();
                pce.propertyDescriptors = new PropertyDescriptor[0];
                pce.propertiesByName = new TreeMap();
            }
        }
        return pce;
    }

    private Map createPropertiesByNameMap(PropertyDescriptor[] pds, Field[] fields) {
        int i10;
        HashMap<String, Object> m10 = new HashMap<String, Object>(pds.length);
        for (i10 = 0; i10 < pds.length; ++i10) {
            PropertyDescriptor pd2 = pds[i10];
            Method readMethod = pd2.getReadMethod();
            if (readMethod == null || !BeanProxy.isPublicAccessor(readMethod.getModifiers()) || !this.includeReadOnly && pd2.getWriteMethod() == null) continue;
            m10.put(pd2.getName(), pd2);
        }
        for (i10 = 0; i10 < fields.length; ++i10) {
            Field field = fields[i10];
            if (!BeanProxy.isPublicField(field.getModifiers()) || m10.containsKey(field.getName())) continue;
            m10.put(field.getName(), field);
        }
        return m10;
    }

    public static boolean isPropertyIgnored(Class c10, String propertyName) {
        boolean result = false;
        Set propertyOwners = (Set)ignoreProperties.get(propertyName);
        if (propertyOwners != null) {
            while (c10 != null) {
                if (propertyOwners.contains(c10)) {
                    result = true;
                    break;
                }
                c10 = c10.getSuperclass();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIgnoreProperty(Class c10, String propertyName) {
        Map map = ignoreProperties;
        synchronized (map) {
            HashSet<Class> propertyOwners = (HashSet<Class>)ignoreProperties.get(propertyName);
            if (propertyOwners == null) {
                propertyOwners = new HashSet<Class>();
                ignoreProperties.put(propertyName, propertyOwners);
            }
            propertyOwners.add(c10);
        }
    }

    public static boolean isPublicField(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }

    public static boolean isPublicAccessor(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    public Object clone() {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map map = ignoreProperties;
        synchronized (map) {
            ignoreProperties.clear();
        }
        map = propertyNamesCache;
        synchronized (map) {
            propertyNamesCache.clear();
        }
        map = beanPropertyCache;
        synchronized (map) {
            beanPropertyCache.clear();
        }
        map = propertyDescriptorCache;
        synchronized (map) {
            propertyDescriptorCache.clear();
        }
    }

    static {
        BeanProxy.addIgnoreProperty(AbstractMap.class, "empty");
        BeanProxy.addIgnoreProperty(AbstractCollection.class, "empty");
        BeanProxy.addIgnoreProperty(ASObject.class, "type");
        BeanProxy.addIgnoreProperty(Throwable.class, "stackTrace");
        BeanProxy.addIgnoreProperty(File.class, "parentFile");
        BeanProxy.addIgnoreProperty(File.class, "canonicalFile");
        BeanProxy.addIgnoreProperty(File.class, "absoluteFile");
    }

    protected static class PropertyDescriptorCacheEntry {
        PropertyDescriptor[] propertyDescriptors;
        Map propertiesByName;

        protected PropertyDescriptorCacheEntry() {
        }
    }

    protected static class BeanProperty {
        private String name;
        private Class type;
        private Method readMethod;
        private Method writeMethod;
        private Field field;

        protected BeanProperty(String name, Class type, Method read, Method write, Field field) {
            this.name = name;
            this.type = type;
            this.writeMethod = write;
            this.readMethod = read;
            this.field = field;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public boolean isWrite() {
            return this.writeMethod != null || this.field != null;
        }

        public boolean isRead() {
            return this.readMethod != null || this.field != null;
        }

        public Class getReadDeclaringClass() {
            if (this.readMethod != null) {
                return this.readMethod.getDeclaringClass();
            }
            if (this.field != null) {
                return this.field.getDeclaringClass();
            }
            return null;
        }

        public Class getReadType() {
            if (this.readMethod != null) {
                return this.readMethod.getReturnType();
            }
            if (this.field != null) {
                return this.field.getType();
            }
            return null;
        }

        public String getWriteName() {
            if (this.writeMethod != null) {
                return "method " + this.writeMethod.getName();
            }
            if (this.field != null) {
                return "field " + this.field.getName();
            }
            return null;
        }

        public void set(Object bean, Object value) throws IllegalAccessException, InvocationTargetException {
            if (this.writeMethod != null) {
                this.writeMethod.invoke(bean, value);
            } else if (this.field != null) {
                this.field.set(bean, value);
            } else {
                throw new MessageException("Setter not found for property " + this.name);
            }
        }

        public Object get(Object bean) throws IllegalAccessException, InvocationTargetException {
            Object obj = null;
            if (this.readMethod != null) {
                obj = this.readMethod.invoke(bean, null);
            } else if (this.field != null) {
                obj = this.field.get(bean);
            }
            return obj;
        }
    }
}

