/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.util.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf3Output
extends AbstractAmfOutput
implements Amf3Types {
    protected IdentityHashMap objectTable = new IdentityHashMap(64);
    protected HashMap traitsTable = new HashMap(10);
    protected HashMap stringTable = new HashMap(64);

    public Amf3Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = true;
    }

    public void reset() {
        super.reset();
        this.objectTable.clear();
        this.traitsTable.clear();
        this.stringTable.clear();
    }

    public void writeObject(Object o10) throws IOException {
        if (o10 == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o10 instanceof Externalizable) {
            this.writeCustomObject(o10);
        } else if (o10 instanceof String || o10 instanceof Character) {
            String s10 = o10.toString();
            this.writeAMFString(s10);
        } else if (o10 instanceof Number) {
            if (o10 instanceof Integer || o10 instanceof Short || o10 instanceof Byte) {
                int i10 = ((Number)o10).intValue();
                this.writeAMFInt(i10);
            } else if (!this.context.legacyBigNumbers && (o10 instanceof BigInteger || o10 instanceof BigDecimal)) {
                this.writeAMFString(((Number)o10).toString());
            } else {
                double d10 = ((Number)o10).doubleValue();
                this.writeAMFDouble(d10);
            }
        } else if (o10 instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o10);
        } else if (o10 instanceof Date) {
            this.writeAMFDate((Date)o10);
        } else if (o10 instanceof Calendar) {
            this.writeAMFDate(((Calendar)o10).getTime());
        } else if (o10 instanceof Document) {
            if (this.context.legacyXMLDocument) {
                this.out.write(7);
            } else {
                this.out.write(11);
            }
            if (!this.byReference(o10)) {
                String xml = this.documentToString(o10);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeAMFUTF(xml);
            }
        } else {
            Class<?> cls = o10.getClass();
            if (this.context.legacyMap && o10 instanceof Map && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
            } else if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, null);
                } else {
                    this.writeArrayCollection((Collection)o10, null);
                }
            } else if (cls.isArray()) {
                this.writeAMFArray(o10, cls.getComponentType());
            } else {
                if (o10 instanceof RowSet) {
                    o10 = new PagedRowSet((RowSet)o10, Integer.MAX_VALUE, false);
                } else if (this.context.legacyThrowable && o10 instanceof Throwable) {
                    o10 = new StatusInfoProxy((Throwable)o10);
                }
                this.writeCustomObject(o10);
            }
        }
    }

    public void writeObjectTraits(TraitsInfo ti2) throws IOException {
        String className = ti2.getClassName();
        if (this.isDebug) {
            if (ti2.isExternalizable()) {
                this.trace.startExternalizableObject(className, this.objectTable.size() - 1);
            } else {
                this.trace.startAMFObject(className, this.objectTable.size() - 1);
            }
        }
        if (!this.byReference(ti2)) {
            int count = 0;
            List propertyNames = null;
            boolean externalizable = ti2.isExternalizable();
            if (!externalizable && (propertyNames = ti2.getProperties()) != null) {
                count = propertyNames.size();
            }
            boolean dynamic = ti2.isDynamic();
            this.writeUInt29(3 | (externalizable ? 4 : 0) | (dynamic ? 8 : 0) | count << 4);
            this.writeStringWithoutType(className);
            if (!externalizable && propertyNames != null) {
                for (int i10 = 0; i10 < count; ++i10) {
                    String propName = ti2.getProperty(i10);
                    this.writeStringWithoutType(propName);
                }
            }
        }
    }

    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.writeObject(value);
    }

    public void writeObjectEnd() throws IOException {
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b10) throws IOException {
        if (this.isDebug) {
            this.trace.write(b10);
        }
        if (b10) {
            this.out.write(3);
        } else {
            this.out.write(2);
        }
    }

    protected void writeAMFDate(Date d10) throws IOException {
        this.out.write(8);
        if (!this.byReference(d10)) {
            if (this.isDebug) {
                this.trace.write(d10);
            }
            this.writeUInt29(1);
            this.out.writeDouble(d10.getTime());
        }
    }

    protected void writeAMFDouble(double d10) throws IOException {
        if (this.isDebug) {
            this.trace.write(d10);
        }
        this.out.write(5);
        this.out.writeDouble(d10);
    }

    protected void writeAMFInt(int i10) throws IOException {
        if (i10 >= -268435456 && i10 <= 0xFFFFFFF) {
            if (this.isDebug) {
                this.trace.write(i10);
            }
            this.out.write(4);
            this.writeUInt29(i10 &= 0x1FFFFFFF);
        } else {
            this.writeAMFDouble(i10);
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        this.out.write(9);
        if (!this.byReference(map)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(1);
            for (Object key : map.keySet()) {
                if (key == null) continue;
                String propName = key.toString();
                this.writeStringWithoutType(propName);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                this.writeObject(map.get(key));
            }
            this.writeStringWithoutType("");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(1);
    }

    protected void writeAMFString(String s10) throws IOException {
        this.out.write(6);
        this.writeStringWithoutType(s10);
        if (this.isDebug) {
            this.trace.writeString(s10);
        }
    }

    protected void writeStringWithoutType(String s10) throws IOException {
        if (s10.length() == 0) {
            this.writeUInt29(1);
            return;
        }
        if (!this.byReference(s10)) {
            this.writeAMFUTF(s10);
            return;
        }
    }

    protected void writeAMFArray(Object o10, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o10);
        } else if (componentType.equals(Byte.class)) {
            this.writeAMFByteArray((Byte[])o10);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o10);
        } else {
            this.writeObjectArray((Object[])o10, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        this.out.write(10);
        if (!this.byReference(col)) {
            ArrayCollection ac2;
            if (col instanceof ArrayCollection) {
                ac2 = (ArrayCollection)col;
            } else {
                ac2 = new ArrayCollection(col);
                if (desc != null) {
                    ac2.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac2);
            this.writePropertyProxy(proxy, ac2);
        }
    }

    protected void writeCustomObject(Object o10) throws IOException {
        PropertyProxy proxy = null;
        if (o10 instanceof PropertyProxy) {
            proxy = (PropertyProxy)o10;
            if ((o10 = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o10 instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o10, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o10, proxy.getDescriptor());
                }
                return;
            }
            if (o10.getClass().isArray()) {
                this.writeObjectArray((Object[])o10, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o10 instanceof Map && !(o10 instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o10);
                return;
            }
        }
        this.out.write(10);
        if (!this.byReference(o10)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o10);
            }
            this.writePropertyProxy(proxy, o10);
        }
    }

    protected void writePropertyProxy(PropertyProxy proxy, Object instance) throws IOException {
        Object newInst = proxy.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + proxy.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            proxy = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = proxy.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = proxy.getPropertyNames(instance);
        }
        TraitsInfo ti2 = new TraitsInfo(proxy.getAlias(instance), proxy.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti2);
        if (externalizable) {
            ((Externalizable)instance).writeExternal(this);
        } else if (propertyNames != null) {
            for (String propName : propertyNames) {
                Object value = null;
                value = proxy.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block17: {
            Class<?> aType;
            block18: {
                block16: {
                    aType = obj.getClass().getComponentType();
                    if (!aType.equals(Character.TYPE)) break block16;
                    char[] c10 = (char[])obj;
                    this.writeCharArrayAsString(c10);
                    break block17;
                }
                if (!aType.equals(Byte.TYPE)) break block18;
                this.writeAMFByteArray((byte[])obj);
                break block17;
            }
            this.out.write(9);
            if (this.byReference(obj)) break block17;
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b10 = (boolean[])obj;
                this.writeUInt29(b10.length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i10 = 0; i10 < b10.length; ++i10) {
                        this.trace.arrayElement(i10);
                        this.writeAMFBoolean(b10[i10]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i11 = 0; i11 < b10.length; ++i11) {
                        this.writeAMFBoolean(b10[i11]);
                    }
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i12 = 0; i12 < length; ++i12) {
                        this.trace.arrayElement(i12);
                        int v10 = Array.getInt(obj, i12);
                        this.writeAMFInt(v10);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i13 = 0; i13 < length; ++i13) {
                        int v11 = Array.getInt(obj, i13);
                        this.writeAMFInt(v11);
                    }
                }
            } else {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                    for (int i14 = 0; i14 < length; ++i14) {
                        this.trace.arrayElement(i14);
                        double v12 = Array.getDouble(obj, i14);
                        this.writeAMFDouble(v12);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i15 = 0; i15 < length; ++i15) {
                        double v13 = Array.getDouble(obj, i15);
                        this.writeAMFDouble(v13);
                    }
                }
            }
        }
    }

    protected void writeAMFByteArray(byte[] ba) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba)) {
            int length = ba.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.objectTable.size() - 1, length);
            }
            this.out.write(ba, 0, length);
        }
    }

    protected void writeAMFByteArray(Byte[] ba) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba)) {
            int length = ba.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.objectTable.size() - 1, length);
            }
            for (int i10 = 0; i10 < ba.length; ++i10) {
                Byte b10 = ba[i10];
                if (b10 == null) {
                    this.out.write(0);
                    continue;
                }
                this.out.write(b10.byteValue());
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i10 = 0; i10 < length; ++i10) {
            Character c10 = ca[i10];
            chars[i10] = c10 == null ? (char)'\u0000' : ca[i10].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        String str = new String(ca);
        this.writeAMFString(str);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(values.length << 1 | 1);
            this.writeStringWithoutType("");
            for (int i10 = 0; i10 < values.length; ++i10) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i10);
                }
                if (!((item = values[i10]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.writeObject(item);
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c10, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(c10)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.objectTable.size() - 1);
            }
            this.writeUInt29(c10.size() << 1 | 1);
            this.writeStringWithoutType("");
            Iterator it2 = c10.iterator();
            int i10 = 0;
            while (it2.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i10);
                }
                if (!((item = it2.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.writeObject(item);
                ++i10;
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeUInt29(int ref) throws IOException {
        if (ref < 128) {
            this.out.writeByte(ref);
        } else if (ref < 16384) {
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x200000) {
            this.out.writeByte(ref >> 14 & 0x7F | 0x80);
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x40000000) {
            this.out.writeByte(ref >> 22 & 0x7F | 0x80);
            this.out.writeByte(ref >> 15 & 0x7F | 0x80);
            this.out.writeByte(ref >> 8 & 0x7F | 0x80);
            this.out.writeByte(ref & 0xFF);
        } else {
            throw new MessageException("Integer out of range: " + ref);
        }
    }

    public void writeAMFUTF(String s10) throws IOException {
        char c10;
        int strlen = s10.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        s10.getChars(0, strlen, charr, 0);
        for (int i10 = 0; i10 < strlen; ++i10) {
            c10 = charr[i10];
            if (c10 <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c10 > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.writeUInt29(utflen << 1 | 1);
        byte[] bytearr = this.getTempByteArray(utflen);
        for (int i11 = 0; i11 < strlen; ++i11) {
            c10 = charr[i11];
            if (c10 <= '\u007f') {
                bytearr[count++] = (byte)c10;
                continue;
            }
            if (c10 > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c10 >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c10 >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c10 >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c10 >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c10 >> 0 & 0x3F);
        }
        this.out.write(bytearr, 0, utflen);
    }

    protected boolean byReference(Object o10) throws IOException {
        Object ref = this.objectTable.get(o10);
        if (ref != null) {
            try {
                int refNum = (Integer)ref;
                if (this.isDebug) {
                    this.trace.writeRef(refNum);
                }
                this.writeUInt29(refNum << 1);
            }
            catch (ClassCastException e10) {
                throw new IOException("Object reference is not an Integer");
            }
        } else {
            this.objectTable.put(o10, new Integer(this.objectTable.size()));
        }
        return ref != null;
    }

    public void addObjectReference(Object o10) throws IOException {
        this.byReference(o10);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(String s) throws IOException {
        ref = this.stringTable.get(s);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.writeUInt29(refNum << 1);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl13
                this.trace.writeStringRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        } else {
            this.stringTable.put(s, new Integer(this.stringTable.size()));
        }
lbl13:
        // 3 sources

        return ref != null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean byReference(TraitsInfo ti) throws IOException {
        ref = this.traitsTable.get(ti);
        if (ref != null) {
            try {
                refNum = (Integer)ref;
                this.writeUInt29(refNum << 2 | 1);
                if (!Trace.amf || !this.isDebug) ** GOTO lbl13
                this.trace.writeTraitsInfoRef(refNum);
            }
            catch (ClassCastException e) {
                throw new IOException("TraitsInfo reference is not an Integer");
            }
        } else {
            this.traitsTable.put(ti, new Integer(this.traitsTable.size()));
        }
lbl13:
        // 3 sources

        return ref != null;
    }
}

