/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.client;

import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfMessageSerializer;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amf.client.AMFHeaderProcessor;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFConnection {
    public static final String COOKIE = "Cookie";
    public static final String COOKIE2 = "Cookie2";
    public static final String COOKIE_SEPERATOR = ";";
    public static final String COOKIE_NAMEVALUE_SEPERATOR = "=";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    private static int DEFAULT_OBJECT_ENCODING = 3;
    private ActionContext actionContext;
    private boolean connected;
    private boolean instantiateTypes = true;
    private int objectEncoding;
    private boolean objectEncodingSet = false;
    private SerializationContext serializationContext;
    private String url;
    private URL urlObject;
    protected List<MessageHeader> amfHeaders;
    protected AMFHeaderProcessor amfHeaderProcessor;
    protected Map<String, String> cookies;
    protected Map<String, String> httpRequestHeaders;
    protected int responseCounter;
    protected HttpURLConnection urlConnection;

    public static void registerAlias(String alias, String className) {
        ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
        registry.registerAlias(alias, className);
        registry.registerAlias(className, alias);
    }

    public AMFHeaderProcessor getAMFHeaderProcessor() {
        return this.amfHeaderProcessor;
    }

    public void setAMFHeaderProcessor(AMFHeaderProcessor amfHeaderProcessor) {
        this.amfHeaderProcessor = amfHeaderProcessor;
    }

    public static int getDefaultObjectEncoding() {
        return DEFAULT_OBJECT_ENCODING;
    }

    public static void setDefaultObjectEncoding(int value) {
        DEFAULT_OBJECT_ENCODING = value;
    }

    public boolean isInstantiateTypes() {
        return this.instantiateTypes;
    }

    public void setInstantiateTypes(boolean instantiateTypes) {
        this.instantiateTypes = instantiateTypes;
    }

    public int getObjectEncoding() {
        if (!this.objectEncodingSet) {
            return AMFConnection.getDefaultObjectEncoding();
        }
        return this.objectEncoding;
    }

    public void setObjectEncoding(int objectEncoding) {
        this.objectEncoding = objectEncoding;
        this.objectEncodingSet = true;
    }

    public String getUrl() {
        return this.url;
    }

    public void addAmfHeader(String name, boolean mustUnderstand, Object data) {
        if (this.amfHeaders == null) {
            this.amfHeaders = new ArrayList<MessageHeader>();
        }
        MessageHeader header = new MessageHeader(name, mustUnderstand, data);
        this.amfHeaders.add(header);
    }

    public void addAmfHeader(String name, Object data) {
        this.addAmfHeader(name, false, data);
    }

    public boolean removeAmfHeader(String name) {
        boolean exists = false;
        if (this.amfHeaders != null) {
            Iterator<MessageHeader> iterator = this.amfHeaders.iterator();
            while (iterator.hasNext()) {
                MessageHeader header = iterator.next();
                if (!name.equals(header.getName())) continue;
                iterator.remove();
                exists = true;
            }
        }
        return exists;
    }

    public void removeAllAmfHeaders() {
        if (this.amfHeaders != null) {
            this.amfHeaders = null;
        }
    }

    public void addHttpRequestHeader(String name, String value) {
        if (this.httpRequestHeaders == null) {
            this.httpRequestHeaders = new HashMap<String, String>();
        }
        this.httpRequestHeaders.put(name, value);
    }

    public boolean removeHttpRequestHeader(String name) {
        boolean exists = false;
        if (this.httpRequestHeaders != null) {
            String previousValue = this.httpRequestHeaders.remove(name);
            exists = previousValue != null;
        }
        return exists;
    }

    public void removeAllHttpRequestHeaders() {
        if (this.httpRequestHeaders != null) {
            this.httpRequestHeaders = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(String command, Object ... arguments) throws ClientStatusException, ServerStatusException {
        Object object;
        if (!this.connected) {
            String message = "AMF connection is not connected";
            ClientStatusException cse = new ClientStatusException(message, "AMFConnection.Call.Failed");
            throw cse;
        }
        String responseURI = this.getResponseURI();
        ActionMessage requestMessage = new ActionMessage(this.getObjectEncoding());
        if (this.amfHeaders != null) {
            for (MessageHeader header : this.amfHeaders) {
                requestMessage.addHeader(header);
            }
        }
        MessageBody amfMessage = new MessageBody(command, responseURI, arguments);
        requestMessage.addBody(amfMessage);
        this.actionContext.setRequestMessage(requestMessage);
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfMessageSerializer amfMessageSerializer = new AmfMessageSerializer();
        amfMessageSerializer.initialize(this.serializationContext, outBuffer, null);
        try {
            try {
                Object result;
                amfMessageSerializer.writeMessage(requestMessage);
                object = result = this.send(outBuffer);
                Object var11_14 = null;
            }
            catch (Exception e10) {
                if (e10 instanceof ClientStatusException) {
                    throw (ClientStatusException)e10;
                }
                if (e10 instanceof ServerStatusException) {
                    throw (ServerStatusException)e10;
                }
                ClientStatusException exception = new ClientStatusException(e10, "AMFConnection.Call.Failed");
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                outBuffer.close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return object;
        }
        outBuffer.close();
        return object;
    }

    public void close() {
        if (this.cookies != null) {
            this.cookies.clear();
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
            this.urlConnection = null;
        }
        this.url = null;
        this.urlObject = null;
        this.serializationContext = null;
        this.connected = false;
    }

    public void connect(String url) throws ClientStatusException {
        if (this.connected) {
            this.close();
        }
        this.url = url;
        try {
            this.urlObject = new URL(url);
            this.serializationContext = new SerializationContext();
            this.serializationContext.createASObjectForMissingType = true;
            this.internalConnect();
        }
        catch (IOException e10) {
            ClientStatusException exception = new ClientStatusException(e10, "AMFConnection.Connect.Failed");
            throw exception;
        }
    }

    protected ServerStatusException.HttpResponseInfo generateHttpResponseInfo() {
        ServerStatusException.HttpResponseInfo httpResponseInfo = null;
        try {
            int responseCode = this.urlConnection.getResponseCode();
            String responseMessage = this.urlConnection.getResponseMessage();
            httpResponseInfo = new ServerStatusException.HttpResponseInfo(responseCode, responseMessage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return httpResponseInfo;
    }

    protected String getResponseURI() {
        String responseURI = "/" + this.responseCounter;
        ++this.responseCounter;
        return responseURI;
    }

    protected void internalConnect() throws IOException {
        this.serializationContext.instantiateTypes = this.instantiateTypes;
        this.urlConnection = (HttpURLConnection)this.urlObject.openConnection();
        this.urlConnection.setDoOutput(true);
        this.setHttpRequestHeaders();
        this.actionContext = new ActionContext();
        this.connected = true;
    }

    protected Object processHttpResponse(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        this.processHttpResponseHeaders();
        return this.processHttpResponseBody(inputStream);
    }

    protected Object processHttpResponseBody(InputStream inputStream) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        DataInputStream din = new DataInputStream(inputStream);
        ActionMessage message = new ActionMessage();
        this.actionContext.setRequestMessage(message);
        AmfMessageDeserializer deserializer = new AmfMessageDeserializer();
        deserializer.initialize(this.serializationContext, din, null);
        deserializer.readMessage(message, this.actionContext);
        din.close();
        return this.processAmfPacket(message);
    }

    protected void processHttpResponseHeaders() throws IOException {
        Map<String, List<String>> headers = this.urlConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> element : headers.entrySet()) {
            String headerName = element.getKey();
            List<String> headerValues = element.getValue();
            for (String headerValue : headerValues) {
                if (!SET_COOKIE.equals(headerName) && !COOKIE.equals(headerName) && !SET_COOKIE2.equals(headerName) && !COOKIE2.equals(headerName)) continue;
                this.processSetCookieHeader(headerValue);
            }
        }
    }

    protected Object processAmfPacket(ActionMessage packet) throws ClientStatusException, ServerStatusException {
        this.processAmfHeaders(packet.getHeaders());
        return this.processAmfBody(packet.getBodies());
    }

    protected void processAmfHeaders(ArrayList<MessageHeader> headers) throws ClientStatusException {
        if (this.amfHeaderProcessor == null) {
            return;
        }
        for (MessageHeader header : headers) {
            this.amfHeaderProcessor.processHeader(header);
        }
    }

    protected Object processAmfBody(ArrayList<MessageBody> messages) throws ServerStatusException {
        for (MessageBody message : messages) {
            String targetURI = message.getTargetURI();
            if (targetURI.endsWith("/onResult")) {
                return message.getData();
            }
            if (!targetURI.endsWith("/onStatus")) continue;
            String exMessage = "Server error";
            ServerStatusException.HttpResponseInfo responseInfo = this.generateHttpResponseInfo();
            ServerStatusException exception = new ServerStatusException(exMessage, message.getData(), responseInfo);
            throw exception;
        }
        return null;
    }

    protected Object send(ByteArrayOutputStream outBuffer) throws ClassNotFoundException, IOException, ClientStatusException, ServerStatusException {
        this.internalConnect();
        outBuffer.writeTo(this.urlConnection.getOutputStream());
        outBuffer.flush();
        outBuffer.close();
        return this.processHttpResponse(this.urlConnection.getInputStream());
    }

    protected void processSetCookieHeader(String headerValue) {
        String cookie = headerValue;
        cookie = headerValue.substring(0, cookie.indexOf(COOKIE_SEPERATOR));
        String name = cookie.substring(0, cookie.indexOf(COOKIE_NAMEVALUE_SEPERATOR));
        String value = cookie.substring(cookie.indexOf(COOKIE_NAMEVALUE_SEPERATOR) + 1, cookie.length());
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
    }

    protected void setHttpRequestHeaders() {
        this.setHttpRequestCookieHeader();
        if (this.httpRequestHeaders != null) {
            for (Map.Entry<String, String> element : this.httpRequestHeaders.entrySet()) {
                String key = element.getKey();
                String value = element.getValue();
                this.urlConnection.setRequestProperty(key, value);
            }
        }
    }

    protected void setHttpRequestCookieHeader() {
        if (this.cookies == null) {
            return;
        }
        StringBuffer cookieHeaderValue = null;
        for (Map.Entry<String, String> element : this.cookies.entrySet()) {
            String name = element.getKey();
            String value = element.getValue();
            if (cookieHeaderValue == null) {
                cookieHeaderValue = new StringBuffer(name + COOKIE_NAMEVALUE_SEPERATOR + value);
                continue;
            }
            cookieHeaderValue.append("; " + name + COOKIE_NAMEVALUE_SEPERATOR + value);
        }
        if (cookieHeaderValue != null) {
            this.urlConnection.setRequestProperty(COOKIE, cookieHeaderValue.toString());
        }
    }
}

