/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMessage
implements Message,
Cloneable {
    private static final long serialVersionUID = -834697863344344313L;
    private static final short HAS_NEXT_FLAG = 128;
    private static final short BODY_FLAG = 1;
    private static final short CLIENT_ID_FLAG = 2;
    private static final short DESTINATION_FLAG = 4;
    private static final short HEADERS_FLAG = 8;
    private static final short MESSAGE_ID_FLAG = 16;
    private static final short TIMESTAMP_FLAG = 32;
    private static final short TIME_TO_LIVE_FLAG = 64;
    private static final short CLIENT_ID_BYTES_FLAG = 1;
    private static final short MESSAGE_ID_BYTES_FLAG = 2;
    protected Object clientId;
    protected String destination;
    protected String messageId;
    protected long timestamp;
    protected long timeToLive;
    protected Map headers;
    protected Object body;
    private byte[] clientIdBytes;
    private byte[] messageIdBytes;
    static final String[] indentLevels = new String[]{"", "  ", "    ", "      ", "        ", "          "};

    public Object getClientId() {
        return this.clientId;
    }

    public void setClientId(Object clientId) {
        this.clientId = clientId;
        this.clientIdBytes = null;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
        this.messageIdBytes = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Map getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        return this.headers;
    }

    public void setHeaders(Map newHeaders) {
        for (Map.Entry entry : newHeaders.entrySet()) {
            String propName = (String)entry.getKey();
            this.setHeader(propName, entry.getValue());
        }
    }

    public Object getHeader(String headerName) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(headerName);
    }

    public void setHeader(String headerName, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        if (value == null) {
            this.headers.remove(headerName);
        } else {
            this.headers.put(headerName, value);
        }
    }

    public boolean headerExists(String headerName) {
        return this.headers != null && this.headers.containsKey(headerName);
    }

    public boolean equals(Object o10) {
        if (o10 instanceof Message) {
            if (this.messageId == null) {
                return this == o10;
            }
            Message m10 = (Message)o10;
            if (m10.getMessageId().equals(this.getMessageId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.messageId == null) {
            return super.hashCode();
        }
        return this.messageId.hashCode();
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int indent) {
        return this.toStringHeader(indent) + this.toStringFields(indent + 1);
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        short[] flagsArray = this.readFlags(input);
        for (int i10 = 0; i10 < flagsArray.length; ++i10) {
            short flags = flagsArray[i10];
            int reservedPosition = 0;
            if (i10 == 0) {
                if ((flags & 1) != 0) {
                    this.body = input.readObject();
                }
                if ((flags & 2) != 0) {
                    this.clientId = input.readObject();
                }
                if ((flags & 4) != 0) {
                    this.destination = (String)input.readObject();
                }
                if ((flags & 8) != 0) {
                    this.headers = (Map)input.readObject();
                }
                if ((flags & 0x10) != 0) {
                    this.messageId = (String)input.readObject();
                }
                if ((flags & 0x20) != 0) {
                    this.timestamp = ((Number)input.readObject()).longValue();
                }
                if ((flags & 0x40) != 0) {
                    this.timeToLive = ((Number)input.readObject()).longValue();
                }
                reservedPosition = 7;
            } else if (i10 == 1) {
                if ((flags & 1) != 0) {
                    this.clientIdBytes = (byte[])input.readObject();
                    this.clientId = UUIDUtils.fromByteArray(this.clientIdBytes);
                }
                if ((flags & 2) != 0) {
                    this.messageIdBytes = (byte[])input.readObject();
                    this.messageId = UUIDUtils.fromByteArray(this.messageIdBytes);
                }
                reservedPosition = 2;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j10 = reservedPosition; j10 < 6; j10 = (int)((short)(j10 + 1))) {
                if ((flags >> j10 & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        short flags = 0;
        if (this.clientIdBytes == null && this.clientId instanceof String) {
            this.clientIdBytes = UUIDUtils.toByteArray((String)this.clientId);
        }
        if (this.messageIdBytes == null) {
            this.messageIdBytes = UUIDUtils.toByteArray(this.messageId);
        }
        if (this.body != null) {
            flags = (short)(flags | 1);
        }
        if (this.clientId != null && this.clientIdBytes == null) {
            flags = (short)(flags | 2);
        }
        if (this.destination != null) {
            flags = (short)(flags | 4);
        }
        if (this.headers != null) {
            flags = (short)(flags | 8);
        }
        if (this.messageId != null && this.messageIdBytes == null) {
            flags = (short)(flags | 0x10);
        }
        if (this.timestamp != 0L) {
            flags = (short)(flags | 0x20);
        }
        if (this.timeToLive != 0L) {
            flags = (short)(flags | 0x40);
        }
        if (this.clientIdBytes != null || this.messageIdBytes != null) {
            flags = (short)(flags | 0x80);
        }
        output.writeByte(flags);
        flags = 0;
        if (this.clientIdBytes != null) {
            flags = (short)(flags | 1);
        }
        if (this.messageIdBytes != null) {
            flags = (short)(flags | 2);
        }
        if (flags != 0) {
            output.writeByte(flags);
        }
        if (this.body != null) {
            output.writeObject(this.body);
        }
        if (this.clientId != null && this.clientIdBytes == null) {
            output.writeObject(this.clientId);
        }
        if (this.destination != null) {
            output.writeObject(this.destination);
        }
        if (this.headers != null) {
            output.writeObject(this.headers);
        }
        if (this.messageId != null && this.messageIdBytes == null) {
            output.writeObject(this.messageId);
        }
        if (this.timestamp != 0L) {
            output.writeObject(new Long(this.timestamp));
        }
        if (this.timeToLive != 0L) {
            output.writeObject(new Long(this.timeToLive));
        }
        if (this.clientIdBytes != null) {
            output.writeObject(this.clientIdBytes);
        }
        if (this.messageIdBytes != null) {
            output.writeObject(this.messageIdBytes);
        }
    }

    public Object clone() {
        AbstractMessage m10 = null;
        try {
            m10 = (AbstractMessage)super.clone();
            if (this.headers != null) {
                m10.headers = (HashMap)((HashMap)this.headers).clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return m10;
    }

    protected String getIndent(int indentLevel) {
        if (indentLevel < indentLevels.length) {
            return indentLevels[indentLevel];
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(indentLevels[indentLevels.length - 1]);
        indentLevel -= indentLevels.length - 1;
        for (int i10 = 0; i10 < indentLevel; ++i10) {
            sb2.append("  ");
        }
        return sb2.toString();
    }

    protected String getFieldSeparator(int indentLevel) {
        String indStr = this.getIndent(indentLevel);
        indStr = indentLevel > 0 ? StringUtils.NEWLINE + indStr : " ";
        return indStr;
    }

    protected String toStringHeader(int indentLevel) {
        String s10 = "Flex Message";
        s10 = s10 + " (" + this.getClass().getName() + ") ";
        return s10;
    }

    protected String toStringFields(int indentLevel) {
        if (this.headers != null) {
            String sep = this.getFieldSeparator(indentLevel);
            String s10 = "";
            for (Map.Entry e10 : this.headers.entrySet()) {
                String key = e10.getKey().toString();
                s10 = s10 + sep + "hdr(" + key + ") = ";
                if (Log.isExcludedProperty(key)) {
                    s10 = s10 + "** [Value Suppressed] **";
                    continue;
                }
                s10 = s10 + this.bodyToString(e10.getValue(), indentLevel + 1);
            }
            return s10;
        }
        return "";
    }

    protected final String bodyToString(Object body, int indentLevel) {
        return this.bodyToString(body, indentLevel, null);
    }

    protected final String bodyToString(Object body, int indentLevel, Map visited) {
        try {
            if (visited == null && ++indentLevel > 18) {
                return StringUtils.NEWLINE + this.getFieldSeparator(indentLevel) + "<..max-depth-reached..>";
            }
            return this.internalBodyToString(body, indentLevel, visited);
        }
        catch (RuntimeException exc) {
            return "Exception in body toString: " + ExceptionUtil.toString(exc);
        }
    }

    protected String internalBodyToString(Object body, int indentLevel) {
        return this.internalBodyToString(body, indentLevel, null);
    }

    protected String internalBodyToString(Object body, int indentLevel, Map visited) {
        if (body instanceof Object[]) {
            if ((visited = this.checkVisited(visited, body)) == null) {
                return "<--";
            }
            String sep = this.getFieldSeparator(indentLevel);
            StringBuffer sb2 = new StringBuffer();
            Object[] arr = (Object[])body;
            sb2.append(this.getFieldSeparator(indentLevel - 1));
            sb2.append("[");
            sb2.append(sep);
            for (int i10 = 0; i10 < arr.length; ++i10) {
                if (i10 != 0) {
                    sb2.append(",");
                    sb2.append(sep);
                }
                sb2.append(this.bodyToString(arr[i10], indentLevel, visited));
            }
            sb2.append(this.getFieldSeparator(indentLevel - 1));
            sb2.append("]");
            return sb2.toString();
        }
        if (body instanceof Map) {
            Map bodyMap = (Map)body;
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            Iterator it2 = bodyMap.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry e10 = it2.next();
                Object key = e10.getKey();
                Object value = e10.getValue();
                buf.append((Object)(key == this ? "(recursive Map as key)" : key));
                buf.append("=");
                if (value == this) {
                    buf.append("(recursive Map as value)");
                } else if (Log.isExcludedProperty(key.toString())) {
                    buf.append("** [Value Suppressed] **");
                } else {
                    buf.append(this.bodyToString(value, indentLevel + 1, visited));
                }
                if (!it2.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }
        if (body instanceof AbstractMessage) {
            return ((AbstractMessage)body).toString(indentLevel);
        }
        if (body != null) {
            return body.toString();
        }
        return "null";
    }

    protected short[] readFlags(ObjectInput input) throws IOException {
        boolean hasNextFlag = true;
        short[] flagsArray = new short[2];
        int i10 = 0;
        while (hasNextFlag) {
            short flags = (short)input.readUnsignedByte();
            if (i10 == flagsArray.length) {
                short[] tempArray = new short[i10 * 2];
                System.arraycopy(flagsArray, 0, tempArray, 0, flagsArray.length);
                flagsArray = tempArray;
            }
            flagsArray[i10] = flags;
            hasNextFlag = (flags & 0x80) != 0;
            ++i10;
        }
        return flagsArray;
    }

    public String logCategory() {
        return "Message.General";
    }

    private Map checkVisited(Map visited, Object obj) {
        if (visited == null) {
            visited = new IdentityHashMap<Object, Boolean>();
        } else if (visited.get(obj) != null) {
            return null;
        }
        visited.put(obj, Boolean.TRUE);
        return visited;
    }
}

