/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.MessageException;
import flex.messaging.log.Log;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.Message;
import java.util.Map;

public class ErrorMessage
extends AcknowledgeMessage {
    private static final long serialVersionUID = -9069412644250075809L;
    public String faultCode;
    public String faultString;
    public String faultDetail;
    public Object rootCause;
    public Map extendedData;

    public ErrorMessage(MessageException mxe) {
        Map extendedData;
        this.faultCode = mxe.getCode();
        this.faultString = mxe.getMessage();
        this.faultDetail = mxe.getDetails();
        if (mxe.getRootCause() != null) {
            this.rootCause = mxe.getRootCauseErrorMessage();
        }
        if ((extendedData = mxe.getExtendedData()) != null) {
            this.extendedData = extendedData;
        }
    }

    public ErrorMessage() {
    }

    public Message getSmallMessage() {
        return null;
    }

    protected String toStringFields(int indentLevel) {
        String sep = this.getFieldSeparator(indentLevel);
        String s10 = super.toStringFields(indentLevel);
        s10 = s10 + sep + "code =  " + this.faultCode;
        s10 = s10 + sep + "message =  " + this.faultString;
        s10 = s10 + sep + "details =  " + this.faultDetail;
        s10 = s10 + sep + "rootCause =  ";
        s10 = this.rootCause == null ? s10 + "null" : s10 + this.rootCause.toString();
        s10 = Log.isExcludedProperty("body") ? s10 + sep + "body = " + "** [Value Suppressed] **" : s10 + sep + "body =  " + this.bodyToString(this.body, indentLevel);
        s10 = s10 + sep + "extendedData =  " + this.bodyToString(this.extendedData, indentLevel);
        return s10;
    }
}

