/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.io.amf.ActionContext;
import flex.messaging.log.Log;
import flex.messaging.messages.BatchableMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;

public class MessagePerformanceUtils {
    static final String LOG_CATEGORY = "Message.General";
    public static final String MPI_HEADER_IN = "DSMPII";
    public static final String MPI_HEADER_OUT = "DSMPIO";
    public static final String MPI_HEADER_PUSH = "DSMPIP";
    public static int MPI_NONE = 0;
    public static int MPI_TIMING = 1;
    public static int MPI_TIMING_AND_SIZING = 2;

    public static void propogateMPIDownBatch(Message message) {
        BatchableMessage dm2;
        long overhead = System.currentTimeMillis();
        if (message instanceof BatchableMessage && (dm2 = (BatchableMessage)((Object)message)).isBatched()) {
            Object[] batchedMessages = (Object[])message.getBody();
            int batchedLength = batchedMessages.length;
            for (int a10 = 0; a10 < batchedLength; ++a10) {
                Message currentMess = (Message)batchedMessages[a10];
                MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
                MessagePerformanceUtils.setMPII(currentMess, (MessagePerformanceInfo)mpi.clone());
                MessagePerformanceUtils.propogateMPIDownBatch(currentMess);
            }
        }
        overhead = System.currentTimeMillis() - overhead;
        MessagePerformanceUtils.getMPII(message).addToOverhead(overhead);
    }

    public static void setupMPII(ActionContext context, Message inMessage) {
        block3: {
            try {
                MessagePerformanceInfo mpii = MessagePerformanceUtils.getMPII(inMessage);
                MessagePerformanceInfo contextMPI = context.getMPII();
                if (contextMPI != null && mpii != null) {
                    contextMPI.sendTime = mpii.sendTime;
                    MessagePerformanceUtils.setMPII(inMessage, (MessagePerformanceInfo)contextMPI.clone());
                    MessagePerformanceUtils.propogateMPIDownBatch(inMessage);
                }
            }
            catch (Exception e10) {
                if (!Log.isDebug()) break block3;
                Log.getLogger(LOG_CATEGORY).error("MPI error: setting up response MPI : " + e10.toString());
            }
        }
    }

    public static void updateOutgoingMPI(ActionContext context, Message inMessage, Object outMessage) {
        block10: {
            try {
                MessagePerformanceInfo mpio = null;
                if (context != null) {
                    mpio = context.getMPIO();
                    if (mpio == null) {
                        mpio = new MessagePerformanceInfo();
                        if (MessagePerformanceUtils.getMPII(inMessage) != null && MessagePerformanceUtils.getMPII((Message)inMessage).sendTime != 0L) {
                            mpio.infoType = "OUT";
                        }
                    }
                    Message mess = (Message)outMessage;
                    if (MessagePerformanceUtils.getMPII(inMessage) != null) {
                        MessagePerformanceUtils.setMPII(mess, (MessagePerformanceInfo)MessagePerformanceUtils.getMPII(inMessage).clone());
                    }
                    MessagePerformanceUtils.setMPIO(mess, mpio);
                    context.setMPIO(mpio);
                }
                if (outMessage instanceof CommandMessage && ((CommandMessage)outMessage).getOperation() == 4) {
                    CommandMessage cmd = (CommandMessage)outMessage;
                    Object[] cmdBody = (Object[])cmd.getBody();
                    int batchedLength = cmdBody.length;
                    for (int i10 = 0; i10 < batchedLength; ++i10) {
                        Message currentMess = (Message)cmdBody[i10];
                        MessagePerformanceInfo origMPII = MessagePerformanceUtils.getMPII(currentMess);
                        if (origMPII == null || MessagePerformanceUtils.getMPII(inMessage) == null) {
                            if (Log.isError()) {
                                Log.getLogger(LOG_CATEGORY).error("MPI is enabled but could not get message performance information for incoming MPI instance from client message.  The client might have created a new channel not configured to send message performance after declaring a different destination which does.  The client channel should either be configured to add MPI properties, or a server destion which has the same MPI properties as the client channel should be used.");
                            }
                            return;
                        }
                        MessagePerformanceUtils.setMPIP(currentMess, (MessagePerformanceInfo)origMPII.clone());
                        MessagePerformanceInfo newMPII = (MessagePerformanceInfo)MessagePerformanceUtils.getMPII(inMessage).clone();
                        mpio.pushedFlag = true;
                        MessagePerformanceUtils.setMPII(currentMess, newMPII);
                        MessagePerformanceUtils.setMPIO(currentMess, mpio);
                    }
                }
            }
            catch (Exception e10) {
                if (!Log.isDebug()) break block10;
                Log.getLogger(LOG_CATEGORY).error("MPI error: setting up response MPI : " + e10.toString());
            }
        }
    }

    public static void setMPII(Message message, MessagePerformanceInfo mpi) {
        message.setHeader(MPI_HEADER_IN, mpi);
    }

    public static void setMPIO(Message message, MessagePerformanceInfo mpi) {
        message.setHeader(MPI_HEADER_OUT, mpi);
    }

    public static void setMPIP(Message message, MessagePerformanceInfo mpi) {
        message.setHeader(MPI_HEADER_PUSH, mpi);
    }

    public static MessagePerformanceInfo getMPII(Message message) {
        return (MessagePerformanceInfo)message.getHeader(MPI_HEADER_IN);
    }

    public static MessagePerformanceInfo getMPIO(Message message) {
        return (MessagePerformanceInfo)message.getHeader(MPI_HEADER_OUT);
    }

    public static MessagePerformanceInfo getMPIP(Message message) {
        return (MessagePerformanceInfo)message.getHeader(MPI_HEADER_PUSH);
    }

    public static void markServerPrePushTime(Message message) {
        if (MessagePerformanceUtils.getMPII(message) == null || MessagePerformanceUtils.getMPII((Message)message).sendTime == 0L) {
            return;
        }
        MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
        mpi.serverPrePushTime = System.currentTimeMillis();
    }

    public static void markServerPreAdapterTime(Message message) {
        if (MessagePerformanceUtils.getMPII(message) == null || MessagePerformanceUtils.getMPII((Message)message).sendTime == 0L) {
            return;
        }
        MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
        if (mpi.serverPreAdapterTime != 0L) {
            return;
        }
        mpi.serverPreAdapterTime = System.currentTimeMillis();
    }

    public static void markServerPostAdapterTime(Message message) {
        if (MessagePerformanceUtils.getMPII(message) == null || MessagePerformanceUtils.getMPII((Message)message).sendTime == 0L || MessagePerformanceUtils.getMPII((Message)message).serverPostAdapterTime != 0L) {
            return;
        }
        MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
        mpi.serverPostAdapterTime = System.currentTimeMillis();
    }

    public static void markServerPreAdapterExternalTime(Message message) {
        if (MessagePerformanceUtils.getMPII(message) == null || MessagePerformanceUtils.getMPII((Message)message).sendTime == 0L) {
            return;
        }
        MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
        mpi.serverPreAdapterExternalTime = System.currentTimeMillis();
    }

    public static void markServerPostAdapterExternalTime(Message message) {
        if (MessagePerformanceUtils.getMPII(message) == null || MessagePerformanceUtils.getMPII((Message)message).sendTime == 0L || MessagePerformanceUtils.getMPII((Message)message).serverPostAdapterExternalTime != 0L) {
            return;
        }
        MessagePerformanceInfo mpi = MessagePerformanceUtils.getMPII(message);
        mpi.serverPostAdapterExternalTime = System.currentTimeMillis();
    }
}

