/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import flex.management.ManageableComponent;
import flex.messaging.FlexContext;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.log.Log;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.MessagingSecurity;
import flex.messaging.services.MessageService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubscriptionManager
extends ManageableComponent {
    public static final String TYPE = "SubscriptionManager";
    private static final Object classMutex = new Object();
    private static int instanceCount = 0;
    protected final MessageDestination destination;
    private long subscriptionTimeoutMillis;
    protected final Map allSubscriptions = new ConcurrentHashMap();
    private final TopicSubscription globalSubscribers = new TopicSubscription();
    private final Map subscribersPerSubtopic = new ConcurrentHashMap();
    private final Map subscribersPerSubtopicWildcard = new ConcurrentHashMap();
    private static final int SUBTOPICS_NOT_SUPPORTED = 10553;
    private TimeoutManager subscriberSessionManager;

    public SubscriptionManager(MessageDestination destination) {
        this(destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionManager(MessageDestination destination, boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
        this.destination = destination;
        this.subscriptionTimeoutMillis = 0L;
    }

    public void setId(String id2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        if (this.isManaged() && this.getControl() != null) {
            this.getControl().unregister();
            this.setControl(null);
            this.setManaged(false);
        }
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (!this.allSubscriptions.isEmpty()) {
                for (Map.Entry subscription : this.allSubscriptions.entrySet()) {
                    this.removeSubscriber((MessageClient)subscription.getValue());
                }
            }
        }
    }

    public void setSubscriptionTimeoutMillis(long value) {
        this.subscriptionTimeoutMillis = value;
        if (this.subscriptionTimeoutMillis > 0L) {
            this.subscriberSessionManager = new TimeoutManager();
        }
    }

    public long getSubscriptionTimeoutMillis() {
        return this.subscriptionTimeoutMillis;
    }

    public Object getSubscriptionState() {
        ArrayList subState = new ArrayList();
        if (this.globalSubscribers.defaultSubscriptions != null && !this.globalSubscribers.defaultSubscriptions.isEmpty()) {
            subState.add(null);
            subState.add(null);
        }
        if (this.globalSubscribers.selectorSubscriptions != null) {
            Iterator it2 = this.globalSubscribers.selectorSubscriptions.keySet().iterator();
            while (it2.hasNext()) {
                subState.add(it2.next());
                subState.add(null);
            }
        }
        this.addSubscriptionState(subState, this.subscribersPerSubtopic);
        this.addSubscriptionState(subState, this.subscribersPerSubtopicWildcard);
        if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Retrieved subscription state to send to new cluster member for destination: " + this.destination.getId() + ": " + StringUtils.NEWLINE + subState);
        }
        return subState;
    }

    private void addSubscriptionState(List subState, Map subsPerSubtopic) {
        for (Map.Entry entry : subsPerSubtopic.entrySet()) {
            Subtopic subtopic = (Subtopic)entry.getKey();
            TopicSubscription tc2 = (TopicSubscription)entry.getValue();
            if (tc2.defaultSubscriptions != null && !tc2.defaultSubscriptions.isEmpty()) {
                subState.add(null);
                subState.add(subtopic.toString());
            }
            if (tc2.selectorSubscriptions == null) continue;
            Iterator sit = tc2.selectorSubscriptions.keySet().iterator();
            while (sit.hasNext()) {
                subState.add(sit.next());
                subState.add(subtopic.toString());
            }
        }
    }

    protected String getDebugSubscriptionState() {
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" global subscriptions: " + this.globalSubscribers + StringUtils.NEWLINE);
        sb2.append(" regular subtopic subscriptions: " + this.subscribersPerSubtopic + StringUtils.NEWLINE);
        sb2.append(" wildcard subtopic subscriptions: " + this.subscribersPerSubtopicWildcard + StringUtils.NEWLINE);
        return sb2.toString();
    }

    public Set getSubscriberIds() {
        return this.allSubscriptions.keySet();
    }

    public Set getSubscriberIds(Message message, boolean evalSelector) {
        LinkedHashSet ids = new LinkedHashSet();
        List<Object> subtopicObj = message.getHeader("DSSubtopic");
        if (subtopicObj instanceof Object[]) {
            subtopicObj = Arrays.asList((Object[])subtopicObj);
        }
        if (subtopicObj instanceof String) {
            String subtopicString = (String)((Object)subtopicObj);
            if (subtopicString.length() > 0) {
                this.addSubtopicSubscribers(subtopicString, message, ids, evalSelector);
            } else {
                this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
            }
        } else if (subtopicObj instanceof List) {
            List<Object> subtopicList = subtopicObj;
            for (int i10 = 0; i10 < subtopicList.size(); ++i10) {
                this.addSubtopicSubscribers((String)subtopicList.get(i10), message, ids, evalSelector);
            }
        } else {
            this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
        }
        return ids;
    }

    public Set getSubscriberIds(String subtopicPattern, Map messageHeaders) {
        AsyncMessage msg = new AsyncMessage();
        msg.setHeader("DSSubtopic", subtopicPattern);
        if (messageHeaders != null) {
            msg.setHeaders(messageHeaders);
        }
        return this.getSubscriberIds(msg, true);
    }

    void addSubtopicSubscribers(String subtopicString, Message message, Set ids, boolean evalSelector) {
        if (!this.destination.getServerSettings().getAllowSubtopics()) {
            ServiceException se2 = new ServiceException();
            se2.setMessage(10553, new Object[]{subtopicString, this.destination.getId()});
            throw se2;
        }
        Subtopic subtopic = this.getSubtopic(subtopicString);
        ServiceAdapter adapter = this.destination.getAdapter();
        if (adapter instanceof MessagingSecurity && !((MessagingSecurity)((Object)adapter)).allowSend(subtopic)) {
            ServiceException se3 = new ServiceException();
            se3.setMessage(10558, new Object[]{subtopicString});
            throw se3;
        }
        TopicSubscription ts2 = (TopicSubscription)this.subscribersPerSubtopic.get(subtopic);
        this.addTopicSubscribers(ts2, message, ids, evalSelector);
        Set subtopics = this.subscribersPerSubtopicWildcard.keySet();
        for (Subtopic st2 : subtopics) {
            if (!st2.matches(subtopic)) continue;
            ts2 = (TopicSubscription)this.subscribersPerSubtopicWildcard.get(st2);
            this.addTopicSubscribers(ts2, message, ids, evalSelector);
        }
    }

    void addTopicSubscribers(TopicSubscription ts2, Message message, Set ids, boolean evalSelector) {
        if (ts2 == null) {
            return;
        }
        Map subs = ts2.defaultSubscriptions;
        if (subs != null) {
            ids.addAll(subs.keySet());
        }
        if (ts2.selectorSubscriptions != null) {
            for (Map.Entry entry : ts2.selectorSubscriptions.entrySet()) {
                String selector = (String)entry.getKey();
                subs = (Map)entry.getValue();
                if (!evalSelector) {
                    ids.addAll(subs.keySet());
                    continue;
                }
                JMSSelector jmsSel = new JMSSelector(selector);
                try {
                    if (!jmsSel.match(message)) continue;
                    ids.addAll(subs.keySet());
                }
                catch (JMSSelectorException jmse) {
                    if (!Log.isWarn()) continue;
                    Log.getLogger("Message.Selector").warn("Error processing message selector: " + jmsSel + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + "  selector: " + selector);
                }
            }
        }
    }

    public MessageClient getSubscriber(Object clientId) {
        MessageClient client = (MessageClient)this.allSubscriptions.get(clientId);
        if (client != null && !client.isTimingOut()) {
            this.monitorTimeout(client);
        }
        return client;
    }

    public void removeSubscriber(MessageClient client) {
        client.invalidate();
        if (this.getSubscriber(client.getClientId()) != null) {
            Log.getLogger("Service.Message").error("Failed to remove client: " + client.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        Subtopic subtopic = this.getSubtopic(subtopicString);
        MessageClient client = null;
        try {
            Map subs;
            SubscriptionManager subscriptionManager;
            TopicSubscription topicSub;
            boolean subscriptionAlreadyExists = this.getSubscriber(clientId) != null;
            client = this.getMessageClient(clientId, endpointId);
            FlexClient flexClient = FlexContext.getFlexClient();
            if (subscriptionAlreadyExists) {
                if (flexClient != null && !flexClient.getId().equals(client.getFlexClient().getId())) {
                    ServiceException se2 = new ServiceException();
                    se2.setMessage(10559, new Object[]{clientId});
                    throw se2;
                }
                client.resetEndpoint(endpointId);
            }
            ServiceAdapter adapter = this.destination.getAdapter();
            client.updateLastUse();
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                if (!this.destination.getServerSettings().getAllowSubtopics()) {
                    ServiceException se3 = new ServiceException();
                    se3.setMessage(10553, new Object[]{subtopicString, this.destination.getId()});
                    throw se3;
                }
                if (adapter instanceof MessagingSecurity && subtopic != null && !((MessagingSecurity)((Object)adapter)).allowSubscribe(subtopic)) {
                    ServiceException se4 = new ServiceException();
                    se4.setMessage(10557, new Object[]{subtopicString});
                    throw se4;
                }
                Map map = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                topicSub = (TopicSubscription)map.get(subtopic);
                if (topicSub == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        topicSub = (TopicSubscription)map.get(subtopic);
                        if (topicSub == null) {
                            topicSub = new TopicSubscription();
                            map.put(subtopic, topicSub);
                        }
                    }
                }
            }
            if (selector == null) {
                subs = topicSub.defaultSubscriptions;
                if (subs == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = topicSub.defaultSubscriptions;
                        if (subs == null) {
                            topicSub.defaultSubscriptions = subs = new ConcurrentHashMap();
                        }
                    }
                }
            } else {
                if (topicSub.selectorSubscriptions == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        if (topicSub.selectorSubscriptions == null) {
                            topicSub.selectorSubscriptions = new ConcurrentHashMap();
                        }
                    }
                }
                if ((subs = (Map)topicSub.selectorSubscriptions.get(selector)) == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = (Map)topicSub.selectorSubscriptions.get(selector);
                        if (subs == null) {
                            subs = new ConcurrentHashMap();
                            topicSub.selectorSubscriptions.put(selector, subs);
                        }
                    }
                }
            }
            if (subs.containsKey(clientId)) {
                if (Log.isWarn()) {
                    Log.getLogger("Message.Selector").warn("Client: " + clientId + " already subscribed to: " + this.destination.getId() + " selector: " + selector + " subtopic: " + subtopicString);
                }
            } else {
                client.addSubscription(selector, subtopicString);
                subscriptionManager = this;
                synchronized (subscriptionManager) {
                    if (subs.isEmpty() && this.destination.isClustered() && !this.destination.getServerSettings().isBroadcastRoutingMode()) {
                        this.sendSubscriptionToPeer(true, selector, subtopicString);
                    }
                    subs.put(clientId, client);
                }
                this.monitorTimeout(client);
                if (!subscriptionAlreadyExists) {
                    client.notifyCreatedListeners();
                }
            }
            this.releaseMessageClient(client);
        }
        catch (Throwable throwable) {
            this.releaseMessageClient(client);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        MessageClient client = null;
        try {
            TopicSubscription topicSub;
            Map map = this.allSubscriptions;
            // MONITORENTER : map
            client = (MessageClient)this.allSubscriptions.get(clientId);
            if (client == null) {
                // MONITOREXIT : map
                if (client == null) return;
                this.releaseMessageClient(client);
                return;
            }
            client = this.getMessageClient(clientId, endpointId);
            // MONITOREXIT : map
            Subtopic subtopic = this.getSubtopic(subtopicString);
            Map map2 = null;
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                map2 = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                topicSub = (TopicSubscription)map2.get(subtopic);
                if (topicSub == null) {
                    throw new MessageException("Client: " + clientId + " not subscribed to subtopic: " + subtopic);
                }
            }
            Map subs = selector == null ? topicSub.defaultSubscriptions : (Map)topicSub.selectorSubscriptions.get(selector);
            if (subs == null) throw new MessageException("Client: " + clientId + " not subscribed to destination with selector: " + selector);
            if (subs.get(clientId) == null) {
                throw new MessageException("Client: " + clientId + " not subscribed to destination with selector: " + selector);
            }
            SubscriptionManager subscriptionManager = this;
            // MONITORENTER : subscriptionManager
            subs.remove(clientId);
            if (subs.isEmpty() && this.destination.isClustered() && !this.destination.getServerSettings().isBroadcastRoutingMode()) {
                this.sendSubscriptionToPeer(false, selector, subtopicString);
            }
            if (subs.isEmpty()) {
                if (selector != null && topicSub.selectorSubscriptions != null && topicSub.selectorSubscriptions.isEmpty()) {
                    topicSub.selectorSubscriptions.remove(selector);
                }
                if (!(subtopic == null || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty() || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty())) {
                    map2.remove(subtopic);
                }
            }
            // MONITOREXIT : subscriptionManager
            if (client.removeSubscription(selector, subtopicString)) {
                this.allSubscriptions.remove(clientId);
                client.invalidate();
            }
            if (client == null) return;
            this.releaseMessageClient(client);
            return;
        }
        catch (Throwable throwable) {
            if (client == null) throw throwable;
            this.releaseMessageClient(client);
            throw throwable;
        }
    }

    protected MessageClient newMessageClient(Object clientId, String endpointId) {
        return new MessageClient(clientId, this.destination, endpointId);
    }

    public MessageClient registerMessageClient(Object clientId, String endpointId) {
        MessageClient client = this.getMessageClient(clientId, endpointId);
        this.monitorTimeout(client);
        if (client.isRegistered()) {
            this.releaseMessageClient(client);
        } else {
            client.setRegistered(true);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageClient getMessageClient(Object clientId, String endpointId) {
        Map map = this.allSubscriptions;
        synchronized (map) {
            MessageClient client = (MessageClient)this.allSubscriptions.get(clientId);
            if (client == null) {
                client = this.newMessageClient(clientId, endpointId);
                this.allSubscriptions.put(clientId, client);
            }
            client.incrementReferences();
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageClient(MessageClient client) {
        if (client == null) {
            return;
        }
        Map map = this.allSubscriptions;
        synchronized (map) {
            if (client.decrementReferences()) {
                this.allSubscriptions.remove(client.getClientId());
                client.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorTimeout(MessageClient client) {
        if (this.subscriberSessionManager != null) {
            MessageClient messageClient = client;
            synchronized (messageClient) {
                if (!client.isTimingOut()) {
                    this.subscriberSessionManager.scheduleTimeout(client);
                    client.setTimingOut(true);
                }
            }
        }
    }

    private Subtopic getSubtopic(String subtopic) {
        if (subtopic == null) {
            return null;
        }
        return new Subtopic(subtopic, this.destination.getServerSettings().getSubtopicSeparator());
    }

    protected void sendSubscriptionToPeer(boolean subscribe, String selector, String subtopic) {
        if (Log.isDebug()) {
            Log.getLogger("Service.Message").debug("Sending subscription to peers for subscribe? " + subscribe + " selector: " + selector + " subtopic: " + subtopic);
        }
        ((MessageService)this.destination.getService()).sendSubscribeFromPeer(this.destination.getId(), subscribe ? Boolean.TRUE : Boolean.FALSE, selector, subtopic);
    }

    protected String getLogCategory() {
        return "Service.Message";
    }

    static class TopicSubscription {
        Map defaultSubscriptions;
        Map selectorSubscriptions;

        TopicSubscription() {
        }

        public String toString() {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("default subscriptions: " + this.defaultSubscriptions + StringUtils.NEWLINE);
            sb2.append("selector subscriptions: " + this.selectorSubscriptions + StringUtils.NEWLINE);
            return sb2.toString();
        }
    }
}

