/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatcher {
    private final Map methodCache = new HashMap();
    private static final int ARGUMENT_CONVERSION_ERROR = 10006;
    private static final int CANNOT_INVOKE_METHOD = 10007;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c10, String methodName, List parameters) {
        Method method = null;
        Match bestMatch = new Match(methodName);
        Class[] suppliedParamTypes = MethodMatcher.paramTypes(parameters);
        MethodKey methodKey = new MethodKey(c10, methodName, suppliedParamTypes);
        if (this.methodCache.containsKey(methodKey)) {
            String thisMethodName;
            method = (Method)this.methodCache.get(methodKey);
            bestMatch.matchedMethodName = thisMethodName = method.getName();
            Class[] desiredParamTypes = method.getParameterTypes();
            bestMatch.methodParamTypes = desiredParamTypes;
            MethodMatcher.convertParams(parameters, desiredParamTypes, bestMatch);
        } else {
            Method[] methods = c10.getMethods();
            for (int i10 = 0; i10 < methods.length; ++i10) {
                Method thisMethod = methods[i10];
                String thisMethodName = thisMethod.getName();
                if (!thisMethodName.equalsIgnoreCase(methodName)) continue;
                Match currentMatch = new Match(methodName);
                currentMatch.matchedMethodName = thisMethodName;
                if (bestMatch.matchedMethodName == null) {
                    bestMatch = currentMatch;
                }
                Class[] desiredParamTypes = thisMethod.getParameterTypes();
                currentMatch.methodParamTypes = desiredParamTypes;
                if (desiredParamTypes.length != suppliedParamTypes.length) continue;
                currentMatch.matchedByNumberOfParams = true;
                if (!bestMatch.matchedByNumberOfParams && bestMatch.matchedParamCount == 0) {
                    bestMatch = currentMatch;
                }
                MethodMatcher.convertParams(parameters, desiredParamTypes, currentMatch);
                if (currentMatch.matchedParamCount >= bestMatch.matchedParamCount) {
                    bestMatch = currentMatch;
                }
                if (currentMatch.matchedParamCount != desiredParamTypes.length) continue;
                method = thisMethod;
                bestMatch = currentMatch;
                Map map = this.methodCache;
                synchronized (map) {
                    Method method2 = (Method)this.methodCache.get(methodKey);
                    if (method2 == null) {
                        this.methodCache.put(methodKey, method);
                    } else {
                        method = method2;
                    }
                    break;
                }
            }
        }
        if (method == null) {
            MethodMatcher.methodNotFound(methodName, suppliedParamTypes, bestMatch);
        } else if (bestMatch.paramTypeConversionFailure != null) {
            MessageException me2 = new MessageException();
            me2.setMessage(10006);
            me2.setCode("Server.Processing");
            me2.setRootCause(bestMatch.paramTypeConversionFailure);
            throw me2;
        }
        return method;
    }

    public static void convertParams(List parameters, Class[] desiredParamTypes, Match currentMatch) {
        int matchCount = 0;
        currentMatch.matchedParamCount = 0;
        currentMatch.convertedSuppliedTypes = new Class[desiredParamTypes.length];
        TypeMarshaller marshaller = TypeMarshallingContext.getTypeMarshaller();
        for (int i10 = 0; i10 < desiredParamTypes.length; ++i10) {
            Object param = parameters.get(i10);
            if (param != null) {
                Class objClass;
                Object obj;
                block5: {
                    obj = null;
                    objClass = null;
                    if (marshaller != null) {
                        try {
                            obj = marshaller.convert(param, desiredParamTypes[i10]);
                            break block5;
                        }
                        catch (MessageException ex2) {
                            currentMatch.paramTypeConversionFailure = ex2;
                            break;
                        }
                    }
                    obj = param;
                }
                Class clazz = currentMatch.convertedSuppliedTypes[i10] = obj != null ? (objClass = obj.getClass()) : null;
                if (!(obj == null || desiredParamTypes[i10].isAssignableFrom(objClass) || desiredParamTypes[i10] == Integer.TYPE && Integer.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Double.TYPE && Double.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Long.TYPE && Long.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Boolean.TYPE && Boolean.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Character.TYPE && Character.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Float.TYPE && Float.class.isAssignableFrom(objClass) || desiredParamTypes[i10] == Short.TYPE && Short.class.isAssignableFrom(objClass)) && (desiredParamTypes[i10] != Byte.TYPE || !Byte.class.isAssignableFrom(objClass))) break;
                parameters.set(i10, obj);
                ++matchCount;
                continue;
            }
            ++matchCount;
        }
        currentMatch.matchedParamCount = matchCount;
    }

    public static Class[] paramTypes(List parameters) {
        Class[] paramTypes = new Class[parameters.size()];
        for (int i10 = 0; i10 < paramTypes.length; ++i10) {
            Object p10 = parameters.get(i10);
            paramTypes[i10] = p10 == null ? Object.class : p10.getClass();
        }
        return paramTypes;
    }

    public static void methodNotFound(String methodName, Class[] suppliedParamTypes, Match bestMatch) {
        int errorCode = 10007;
        Object[] errorParams = new Object[]{methodName};
        String errorDetailVariant = "0";
        Object[] errorDetailParams = new Object[]{methodName};
        if (bestMatch.matchedMethodName != null) {
            int expectedParamCount;
            errorCode = 10007;
            errorParams = new Object[]{bestMatch.matchedMethodName};
            int suppliedParamCount = suppliedParamTypes.length;
            int n10 = expectedParamCount = bestMatch.methodParamTypes != null ? bestMatch.methodParamTypes.length : 0;
            if (suppliedParamCount != expectedParamCount) {
                errorDetailVariant = "1";
                errorDetailParams = new Object[]{new Integer(suppliedParamCount), new Integer(expectedParamCount)};
            } else {
                String suppliedTypes = bestMatch.listTypes(suppliedParamTypes);
                String convertedTypes = bestMatch.listConvertedTypes();
                String expectedTypes = bestMatch.listExpectedTypes();
                if (expectedTypes != null) {
                    if (suppliedTypes != null) {
                        if (convertedTypes != null) {
                            errorDetailVariant = "2";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes, convertedTypes};
                        } else {
                            errorDetailVariant = "3";
                            errorDetailParams = new Object[]{expectedTypes, suppliedTypes};
                        }
                    } else {
                        errorDetailVariant = "4";
                        errorDetailParams = new Object[]{expectedTypes};
                    }
                } else {
                    errorDetailVariant = "5";
                    errorDetailParams = new Object[]{suppliedTypes};
                }
            }
        }
        MessageException ex2 = new MessageException();
        ex2.setMessage(errorCode, errorParams);
        ex2.setCode("Server.ResourceUnavailable");
        if (errorDetailVariant != null) {
            ex2.setDetails(errorCode, errorDetailVariant, errorDetailParams);
        }
        if (bestMatch.paramTypeConversionFailure != null) {
            ex2.setRootCause(bestMatch.paramTypeConversionFailure);
        }
        throw ex2;
    }

    public static class Match {
        final String methodName;
        String matchedMethodName;
        boolean matchedByNumberOfParams;
        int matchedParamCount;
        Class[] methodParamTypes;
        Class[] convertedSuppliedTypes;
        Exception paramTypeConversionFailure;

        public Match(String name) {
            this.methodName = name;
        }

        public boolean matchedExactlyByName() {
            if (this.matchedMethodName != null) {
                return this.matchedMethodName.equals(this.methodName);
            }
            return false;
        }

        public boolean matchedLooselyByName() {
            if (this.matchedMethodName != null) {
                return !this.matchedExactlyByName() && this.matchedMethodName.equalsIgnoreCase(this.methodName);
            }
            return false;
        }

        public String listExpectedTypes() {
            return this.listTypes(this.methodParamTypes);
        }

        public String listConvertedTypes() {
            return this.listTypes(this.convertedSuppliedTypes);
        }

        public String listTypes(Class[] types) {
            if (types != null && types.length > 0) {
                StringBuffer sb2 = new StringBuffer();
                for (int i10 = 0; i10 < types.length; ++i10) {
                    Class<?> c10;
                    if (i10 > 0) {
                        sb2.append(", ");
                    }
                    if ((c10 = types[i10]) != null) {
                        if (c10.isArray()) {
                            c10 = c10.getComponentType();
                            sb2.append(c10.getName()).append("[]");
                            continue;
                        }
                        sb2.append(c10.getName());
                        continue;
                    }
                    sb2.append("null");
                }
                return sb2.toString();
            }
            return null;
        }
    }
}

