/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import java.security.SecureRandom;
import java.util.Random;

public class UUIDUtils {
    private static SecureRandom _rand = new SecureRandom();
    private static Random _weakRand = new Random();
    private static final int MAX_IDS_PER_MILLI = 10000;
    private static long lastUsedTOD = 0L;
    private static int numIdsThisMilli = 0;
    private static final String alphaNum = "0123456789ABCDEF";
    private static final int BITS_PER_DIGIT = 4;
    private static final int BITS_PER_INT = 32;
    private static final int BITS_PER_LONG = 64;
    private static final int DIGITS_PER_INT = 8;
    private static final int DIGITS_PER_LONG = 16;
    private static char[] UPPER_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UUIDUtils() {
    }

    public static String createUUID() {
        return UUIDUtils.createUUID(true);
    }

    public static String createUUID(boolean secure) {
        Random rand = secure ? _rand : _weakRand;
        StringBuffer s10 = new StringBuffer(36);
        UUIDUtils.appendHexString(UUIDUtils.uniqueTOD(), false, 11, s10);
        s10.append(alphaNum.charAt(rand.nextInt(16) | 8));
        UUIDUtils.appendRandomHexChars(32 - s10.length(), rand, s10);
        s10.insert(8, "-");
        s10.insert(13, "-");
        s10.insert(18, "-");
        s10.insert(23, "-");
        return s10.toString();
    }

    public static String fromByteArray(byte[] ba) {
        if (ba != null && ba.length == 16) {
            StringBuffer result = new StringBuffer(36);
            for (int i10 = 0; i10 < 16; ++i10) {
                if (i10 == 4 || i10 == 6 || i10 == 8 || i10 == 10) {
                    result.append("-");
                }
                result.append(UPPER_DIGITS[(ba[i10] & 0xF0) >>> 4]);
                result.append(UPPER_DIGITS[ba[i10] & 0xF]);
            }
            return result.toString();
        }
        return null;
    }

    public static boolean isUID(String uid) {
        if (uid != null && uid.length() == 36) {
            char[] chars = uid.toCharArray();
            for (int i10 = 0; i10 < 36; ++i10) {
                char c10 = chars[i10];
                if (!(i10 == 8 || i10 == 13 || i10 == 18 || i10 == 23 ? c10 != '-' : c10 < '0' || c10 > 'F' || c10 > '9' && c10 < 'A')) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] toByteArray(String uid) {
        if (UUIDUtils.isUID(uid)) {
            byte[] result = new byte[16];
            char[] chars = uid.toCharArray();
            int r10 = 0;
            for (int i10 = 0; i10 < chars.length; ++i10) {
                if (chars[i10] == '-') continue;
                int h12 = Character.digit(chars[i10], 16);
                int h22 = Character.digit(chars[++i10], 16);
                result[r10++] = (byte)((h12 << 4 | h22) & 0xFF);
            }
            return result;
        }
        return null;
    }

    private static void appendRandomHexChars(int n10, Random rand, StringBuffer result) {
        int digitsPerInt = 8;
        while (n10 > 0) {
            int digitsToUse = Math.min(n10, digitsPerInt);
            n10 -= digitsToUse;
            UUIDUtils.appendHexString(rand.nextInt(), true, digitsToUse, result);
        }
    }

    private static void appendHexString(long value, boolean prependZeroes, int nLeastSignificantDigits, StringBuffer result) {
        int bitsPerDigit = 4;
        long mask = (1L << bitsPerDigit) - 1L;
        if (nLeastSignificantDigits < 16) {
            value &= (1L << bitsPerDigit * nLeastSignificantDigits) - 1L;
        }
        int i10 = 0;
        long reorderedValue = 0L;
        if (value == 0L) {
            ++i10;
        } else {
            do {
                reorderedValue = reorderedValue << bitsPerDigit | value & mask;
                ++i10;
            } while ((value >>>= bitsPerDigit) != 0L);
        }
        if (prependZeroes) {
            for (int j10 = nLeastSignificantDigits - i10; j10 > 0; --j10) {
                result.append('0');
            }
        }
        while (i10 > 0) {
            result.append(alphaNum.charAt((int)(reorderedValue & mask)));
            reorderedValue >>>= bitsPerDigit;
            --i10;
        }
    }

    private static synchronized long uniqueTOD() {
        long currentTOD = System.currentTimeMillis();
        if (currentTOD < lastUsedTOD) {
            lastUsedTOD = currentTOD;
        }
        if (currentTOD == lastUsedTOD) {
            if (++numIdsThisMilli >= 10000) {
                while (currentTOD == lastUsedTOD) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    currentTOD = System.currentTimeMillis();
                }
                lastUsedTOD = currentTOD;
                numIdsThisMilli = 0;
            }
        } else {
            lastUsedTOD = currentTOD;
            numIdsThisMilli = 0;
        }
        return lastUsedTOD * 10000L + (long)numIdsThisMilli;
    }
}

