/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import flex.messaging.log.Log;
import flex.messaging.util.concurrent.Executor;
import flex.messaging.util.concurrent.FailedExecutionHandler;

public class DefaultThreadPoolExecutor
extends ThreadPoolExecutor
implements Executor {
    private final Object lock = new Object();
    private FailedExecutionHandler handler;

    public DefaultThreadPoolExecutor() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue());
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailedExecutionHandler getFailedExecutionHandler() {
        Object object = this.lock;
        synchronized (object) {
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedExecutionHandler(FailedExecutionHandler value) {
        Object object = this.lock;
        synchronized (object) {
            this.handler = value;
        }
    }

    public void execute(Runnable command) {
        block3: {
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException e10) {
                FailedExecutionHandler handler = this.getFailedExecutionHandler();
                if (handler != null) {
                    handler.failedExecution(command, this, (Exception)((Object)e10));
                }
                if (!Log.isError()) break block3;
                Log.getLogger("Executor").error("DefaultThreadPoolExecutor hit a RejectedExecutionException but no FailedExecutionHandler is registered to handle the error.", e10);
            }
        }
    }
}

