/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.AttrImpl;
import org.lobobrowser.html.domimpl.CDataSectionImpl;
import org.lobobrowser.html.domimpl.CommentImpl;
import org.lobobrowser.html.domimpl.DOMConfigurationImpl;
import org.lobobrowser.html.domimpl.DOMImplementationImpl;
import org.lobobrowser.html.domimpl.DocumentFragmentImpl;
import org.lobobrowser.html.domimpl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.ElementFactory;
import org.lobobrowser.html.domimpl.FilteredHTMLCollectionImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.LocalErrorHandler;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.TextImpl;
import org.lobobrowser.html.io.WritableLineReader;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.WeakValueHashMap;
import org.lobobrowser.util.io.EmptyReader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLDocument;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLFrameElement;
import org.w3c.dom.html2.HTMLIFrameElement;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class HTMLDocumentImpl
extends NodeImpl
implements HTMLDocument {
    private static final Logger logger = null;
    private final ElementFactory factory;
    private final HtmlRendererContext rcontext;
    private final UserAgentContext ucontext;
    private final Map elementsById = new WeakValueHashMap();
    private String documentURI;
    private URL documentURL;
    private WritableLineReader reader;
    private volatile String baseURI;
    private String defaultTarget;
    private String title;
    private String referrer;
    private String domain;
    private HTMLCollection images;
    private HTMLCollection applets;
    private HTMLCollection links;
    private HTMLCollection forms;
    private HTMLCollection anchors;
    private HTMLCollection frames;
    private DocumentType doctype;
    private final Map elementsByName = new HashMap(0);
    private String inputEncoding;
    private String xmlEncoding;
    private boolean xmlStandalone;
    private String xmlVersion = null;
    private boolean strictErrorChecking = true;
    private DOMConfiguration domConfig;
    private DOMImplementation domImplementation;
    private HTMLElement body;
    private final Collection styleSheets = new LinkedList();
    private StyleSheetAggregator styleSheetAggregator = null;
    private final ArrayList documentNotificationListeners = new ArrayList(1);
    private final Map imageInfos = new HashMap(4);
    private final ImageEvent BLANK_IMAGE_EVENT = new ImageEvent(this, null);

    public HTMLDocumentImpl(HtmlRendererContext rcontext) {
        this(rcontext.getUserAgentContext(), rcontext, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext ucontext) {
        this(ucontext, null, null, null);
    }

    public HTMLDocumentImpl(UserAgentContext ucontext, HtmlRendererContext rcontext, WritableLineReader reader, String documentURI) {
        this.factory = ElementFactory.getInstance();
        this.rcontext = rcontext;
        this.ucontext = ucontext;
        this.reader = reader;
        this.documentURI = documentURI;
        try {
            URL docURL = new URL(documentURI);
            SecurityManager sm2 = System.getSecurityManager();
            if (sm2 != null) {
                sm2.checkPermission(new SocketPermission(docURL.getHost(), "connect"));
            }
            this.documentURL = docURL;
            this.domain = docURL.getHost();
        }
        catch (MalformedURLException mfu) {
            // empty catch block
        }
        this.document = this;
    }

    String getDocumentHost() {
        URL docUrl = this.documentURL;
        return docUrl == null ? null : docUrl.getHost();
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setElementById(String id2, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.put(id2, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElementById(String id2) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsById.remove(id2);
        }
    }

    public String getBaseURI() {
        String buri = this.baseURI;
        return buri == null ? this.documentURI : buri;
    }

    public void setBaseURI(String value) {
        this.baseURI = value;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String value) {
        this.defaultTarget = value;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String value) {
        this.referrer = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        String oldDomain = this.domain;
        if (oldDomain == null || !Domains.isValidCookieDomain(domain, oldDomain)) {
            throw new SecurityException("Cannot set domain to '" + domain + "' when current domain is '" + oldDomain + "'");
        }
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLElement getBody() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            return this.body;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getImages() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.images == null) {
                this.images = new FilteredHTMLCollectionImpl(this, this.elementsById, new ImageFilter(), this.treeLock);
            }
            return this.images;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getApplets() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.applets == null) {
                this.applets = new FilteredHTMLCollectionImpl(this, this.elementsById, new AppletFilter(), this.treeLock);
            }
            return this.applets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getLinks() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.links == null) {
                this.links = new FilteredHTMLCollectionImpl(this, this.elementsById, new LinkFilter(), this.treeLock);
            }
            return this.links;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getForms() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.forms == null) {
                this.forms = new FilteredHTMLCollectionImpl(this, this.elementsById, new FormFilter(), this.treeLock);
            }
            return this.forms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getFrames() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.frames == null) {
                this.frames = new FilteredHTMLCollectionImpl(this, this.elementsById, new FrameFilter(), this.treeLock);
            }
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLCollection getAnchors() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.anchors == null) {
                this.anchors = new FilteredHTMLCollectionImpl(this, this.elementsById, new AnchorFilter(), this.treeLock);
            }
            return this.anchors;
        }
    }

    public String getCookie() {
        SecurityManager sm2 = System.getSecurityManager();
        if (sm2 != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return HTMLDocumentImpl.this.ucontext.getCookie(HTMLDocumentImpl.this.documentURL);
                }
            });
        }
        return this.ucontext.getCookie(this.documentURL);
    }

    public void setCookie(final String cookie) throws DOMException {
        SecurityManager sm2 = System.getSecurityManager();
        if (sm2 != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HTMLDocumentImpl.this.ucontext.setCookie(HTMLDocumentImpl.this.documentURL, cookie);
                    return null;
                }
            });
        } else {
            this.ucontext.setCookie(this.documentURL, cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                if (this.reader instanceof LocalWritableLineReader) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.reader = null;
                } else {
                    return;
                }
            }
            this.removeAllChildrenImpl();
            this.reader = new LocalWritableLineReader(new EmptyReader());
        }
    }

    public void load() throws IOException, SAXException, UnsupportedEncodingException {
        this.load(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean closeReader) throws IOException, SAXException, UnsupportedEncodingException {
        WritableLineReader reader;
        Object object = this.treeLock;
        synchronized (object) {
            this.removeAllChildrenImpl();
            this.setTitle(null);
            this.setBaseURI(null);
            this.setDefaultTarget(null);
            this.styleSheets.clear();
            this.styleSheetAggregator = null;
            reader = this.reader;
        }
        if (reader != null) {
            try {
                String systemId;
                LocalErrorHandler errorHandler = new LocalErrorHandler();
                String publicId = systemId = this.documentURI;
                HtmlParser parser = new HtmlParser(this.ucontext, (HTMLDocument)this, (ErrorHandler)errorHandler, publicId, systemId);
                parser.parse(reader);
            }
            finally {
                if (closeReader) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    object = this.treeLock;
                    synchronized (object) {
                        this.reader = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader instanceof LocalWritableLineReader) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(text);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String text) {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.write(text + "\r\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void openBufferChanged(String text) {
        String systemId;
        LocalErrorHandler errorHandler = new LocalErrorHandler();
        String publicId = systemId = this.documentURI;
        HtmlParser parser = new HtmlParser(this.ucontext, (HTMLDocument)this, (ErrorHandler)errorHandler, publicId, systemId);
        StringReader strReader = new StringReader(text);
        try {
            parser.parse(strReader);
        }
        catch (Exception err) {
            this.warn("Unable to parse written HTML text. BaseURI=[" + this.getBaseURI() + "].", err);
        }
    }

    public NodeList getElementsByName(String elementName) {
        return this.getNodeList(new ElementNameFilter(elementName));
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public void setDoctype(DocumentType doctype) {
        this.doctype = doctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getDocumentElement() {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                while (i10.hasNext()) {
                    Object node = i10.next();
                    if (!(node instanceof Element)) continue;
                    return (Element)node;
                }
            }
            return null;
        }
    }

    public Element createElement(String tagName) throws DOMException {
        return this.factory.createElement(this, tagName);
    }

    public DocumentFragment createDocumentFragment() {
        DocumentFragmentImpl node = new DocumentFragmentImpl();
        node.setOwnerDocument(this);
        return node;
    }

    public Text createTextNode(String data) {
        TextImpl node = new TextImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    public Comment createComment(String data) {
        CommentImpl node = new CommentImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        CDataSectionImpl node = new CDataSectionImpl(data);
        node.setOwnerDocument(this);
        return node;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public Attr createAttribute(String name) throws DOMException {
        return new AttrImpl(name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public NodeList getElementsByTagName(String tagname) {
        if ("*".equals(tagname)) {
            return this.getNodeList(new ElementFilter());
        }
        return this.getNodeList(new TagNameFilter(tagname));
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "Not implemented");
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "HTML document");
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new DOMException(9, "HTML document");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElementById(String elementId) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = (Element)this.elementsById.get(elementId);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element namedItem(String name) {
        Element element;
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            element = (Element)this.elementsByName.get(name);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNamedItem(String name, Element element) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.put(name, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNamedItem(String name) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.elementsByName.remove(name);
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.xmlVersion = xmlVersion;
    }

    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    public String getDocumentURI() {
        return this.documentURI;
    }

    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    public Node adoptNode(Node source) throws DOMException {
        if (source instanceof NodeImpl) {
            NodeImpl node = (NodeImpl)source;
            node.setOwnerDocument(this, true);
            return node;
        }
        throw new DOMException(9, "Invalid Node implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMConfiguration getDomConfig() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domConfig == null) {
                this.domConfig = new DOMConfigurationImpl();
            }
            return this.domConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalizeDocument() {
        Object object = this.treeLock;
        synchronized (object) {
            this.visitImpl(new NodeVisitor(){

                public void visit(Node node) {
                    node.normalize();
                }
            });
        }
    }

    public Node renameNode(Node n10, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "No renaming");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMImplementation getImplementation() {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            if (this.domImplementation == null) {
                this.domImplementation = new DOMImplementationImpl(this.ucontext);
            }
            return this.domImplementation;
        }
    }

    public String getLocalName() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(13, "Cannot set node value of document");
    }

    public final HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    public UserAgentContext getUserAgentContext() {
        return this.ucontext;
    }

    public final URL getFullURL(String uri) {
        try {
            String baseURI = this.getBaseURI();
            URL documentURL = baseURI == null ? null : new URL(baseURI);
            return Urls.createURL(documentURL, uri);
        }
        catch (MalformedURLException mfu) {
            try {
                return new URL(uri);
            }
            catch (MalformedURLException mfu2) {
                return null;
            }
        }
    }

    public String getURL() {
        return this.documentURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBody(HTMLElement body) {
        HTMLDocumentImpl hTMLDocumentImpl = this;
        synchronized (hTMLDocumentImpl) {
            this.body = body;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addStyleSheet(CSSStyleSheet ss2) {
        Object object = this.treeLock;
        synchronized (object) {
            this.styleSheets.add(ss2);
            this.styleSheetAggregator = null;
            this.forgetRenderState();
            ArrayList nl2 = this.nodeList;
            if (nl2 != null) {
                Iterator i10 = nl2.iterator();
                while (i10.hasNext()) {
                    Object node = i10.next();
                    if (!(node instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)node).forgetStyle(true);
                }
            }
        }
        this.allInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StyleSheetAggregator getStyleSheetAggregator() {
        Object object = this.treeLock;
        synchronized (object) {
            StyleSheetAggregator ssa = this.styleSheetAggregator;
            if (ssa == null) {
                ssa = new StyleSheetAggregator(this);
                try {
                    ssa.addStyleSheets(this.styleSheets);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.styleSheetAggregator = ssa;
            }
            return ssa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentNotificationListener(DocumentNotificationListener listener) {
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            listenersList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentNotificationListener(DocumentNotificationListener listener) {
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            listenersList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeInvalidated(NodeImpl node) {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.sizeInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookInvalidated(NodeImpl node) {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.lookInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionInParentInvalidated(NodeImpl node) {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.positionInvalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidated(NodeImpl node) {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.invalidated(node);
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeLoaded(NodeImpl node) {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.nodeLoaded(node);
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allInvalidated() {
        int size;
        ArrayList listenersList;
        ArrayList arrayList = listenersList = this.documentNotificationListeners;
        synchronized (arrayList) {
            size = listenersList.size();
        }
        for (int i10 = 0; i10 < size; ++i10) {
            try {
                DocumentNotificationListener dnl = (DocumentNotificationListener)listenersList.get(i10);
                dnl.allInvalidated();
                continue;
            }
            catch (IndexOutOfBoundsException iob2) {
                // empty catch block
            }
        }
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return new StyleSheetRenderState(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadImage(String relativeUri, ImageListener imageListener) {
        HtmlRendererContext rcontext = this.getHtmlRendererContext();
        if (rcontext == null) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final URL url = this.getFullURL(relativeUri);
        if (url == null) {
            imageListener.imageLoaded(this.BLANK_IMAGE_EVENT);
            return;
        }
        final String urlText = url.toExternalForm();
        final Map map = this.imageInfos;
        ImageEvent event = null;
        Map map2 = map;
        synchronized (map2) {
            ImageInfo info = (ImageInfo)map.get(urlText);
            if (info != null) {
                if (info.loaded) {
                    event = info.imageEvent;
                } else {
                    info.addListener(imageListener);
                }
            } else {
                this.nodeLoaded(null);
                UserAgentContext uac = rcontext.getUserAgentContext();
                final HttpRequest httpRequest = uac.createHttpRequest();
                final ImageInfo newInfo = new ImageInfo();
                map.put(urlText, newInfo);
                newInfo.addListener(imageListener);
                httpRequest.addReadyStateChangeListener(new ReadyStateChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void readyStateChanged() {
                        if (httpRequest.getReadyState() == 4) {
                            ImageListener[] listeners;
                            ImageEvent newEvent = new ImageEvent(HTMLDocumentImpl.this, httpRequest.getResponseImage());
                            Map map2 = map;
                            synchronized (map2) {
                                newInfo.imageEvent = newEvent;
                                newInfo.loaded = true;
                                listeners = newInfo.getListeners();
                                map.remove(urlText);
                            }
                            int llength = listeners.length;
                            for (int i10 = 0; i10 < llength; ++i10) {
                                listeners[i10].imageLoaded(newEvent);
                            }
                        }
                    }
                });
                SecurityManager sm2 = System.getSecurityManager();
                if (sm2 == null) {
                    httpRequest.open("GET", url, true);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            httpRequest.open("GET", url, true);
                            return null;
                        }
                    });
                }
            }
        }
        if (event != null) {
            imageListener.imageLoaded(event);
        }
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return super.setUserData(key, data, handler);
    }

    protected Node createSimilarNode() {
        return new HTMLDocumentImpl(this.ucontext, this.rcontext, this.reader, this.documentURI);
    }

    private class LocalWritableLineReader
    extends WritableLineReader {
        public LocalWritableLineReader(LineNumberReader reader) {
            super(reader);
        }

        public LocalWritableLineReader(Reader reader) {
            super(reader);
        }

        public void write(String text) throws IOException {
            super.write(text);
            if ("".equals(text)) {
                HTMLDocumentImpl.this.openBufferChanged(text);
            }
        }
    }

    private class TagNameFilter
    implements NodeFilter {
        private final String name;

        public TagNameFilter(String name) {
            this.name = name;
        }

        public boolean accept(Node node) {
            if (!(node instanceof Element)) {
                return false;
            }
            String n10 = this.name;
            return n10.equalsIgnoreCase(((Element)node).getTagName());
        }
    }

    private class ElementFilter
    implements NodeFilter {
        public boolean accept(Node node) {
            return node instanceof Element;
        }
    }

    private class ElementNameFilter
    implements NodeFilter {
        private final String name;

        public ElementNameFilter(String name) {
            this.name = name;
        }

        public boolean accept(Node node) {
            return node instanceof Element && this.name.equals(((Element)node).getAttribute("name"));
        }
    }

    private class FrameFilter
    implements NodeFilter {
        private FrameFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLFrameElement || node instanceof HTMLIFrameElement;
        }
    }

    private class FormFilter
    implements NodeFilter {
        private FormFilter() {
        }

        public boolean accept(Node node) {
            String nodeName = node.getNodeName();
            return "FORM".equalsIgnoreCase(nodeName);
        }
    }

    private class AnchorFilter
    implements NodeFilter {
        private AnchorFilter() {
        }

        public boolean accept(Node node) {
            String nodeName = node.getNodeName();
            return "A".equalsIgnoreCase(nodeName) || "ANCHOR".equalsIgnoreCase(nodeName);
        }
    }

    private class LinkFilter
    implements NodeFilter {
        private LinkFilter() {
        }

        public boolean accept(Node node) {
            String nodeName = node.getNodeName();
            return "LINK".equalsIgnoreCase(nodeName);
        }
    }

    private class AppletFilter
    implements NodeFilter {
        private AppletFilter() {
        }

        public boolean accept(Node node) {
            return "APPLET".equalsIgnoreCase(node.getNodeName());
        }
    }

    private class ImageFilter
    implements NodeFilter {
        private ImageFilter() {
        }

        public boolean accept(Node node) {
            return "IMG".equalsIgnoreCase(node.getNodeName());
        }
    }

    private static class ImageInfo {
        public ImageEvent imageEvent;
        public boolean loaded;
        private ArrayList listeners = new ArrayList(1);

        private ImageInfo() {
        }

        void addListener(ImageListener listener) {
            this.listeners.add(listener);
        }

        ImageListener[] getListeners() {
            return this.listeners.toArray(ImageListener.EMPTY_ARRAY);
        }
    }
}

