/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Logger;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;

abstract class BaseBoundableRenderable
extends BaseRenderable
implements BoundableRenderable {
    protected static final Logger logger = Logger.getLogger((class$org$lobobrowser$html$renderer$BaseBoundableRenderable == null ? (class$org$lobobrowser$html$renderer$BaseBoundableRenderable = BaseBoundableRenderable.class$("org.lobobrowser.html.renderer.BaseBoundableRenderable")) : class$org$lobobrowser$html$renderer$BaseBoundableRenderable).getName());
    protected static final Color SELECTION_COLOR = Color.BLUE;
    protected static final Color SELECTION_XOR = Color.LIGHT_GRAY;
    protected final RenderableContainer container;
    protected final ModelNode modelNode;
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean layoutUpTreeCanBeInvalidated = true;
    protected RCollection parent;
    protected RCollection originalParent;
    static /* synthetic */ Class class$org$lobobrowser$html$renderer$BaseBoundableRenderable;

    public BaseBoundableRenderable(RenderableContainer container, ModelNode modelNode) {
        this.container = container;
        this.modelNode = modelNode;
    }

    public Point getGUIPoint(int clientX, int clientY) {
        RCollection parent = this.getParent();
        if (parent instanceof BoundableRenderable) {
            return ((BoundableRenderable)parent).getGUIPoint(clientX + this.x, clientY + this.y);
        }
        if (parent == null) {
            return this.container.getGUIPoint(clientX + this.x, clientY + this.y);
        }
        throw new IllegalStateException("parent=" + parent);
    }

    public Point getRenderablePoint(int guiX, int guiY) {
        RCollection parent = this.getParent();
        if (parent instanceof BoundableRenderable) {
            return ((BoundableRenderable)parent).getRenderablePoint(guiX - this.x, guiY - this.y);
        }
        if (parent == null) {
            return new Point(guiX - this.x, guiY - this.y);
        }
        throw new IllegalStateException("parent=" + parent);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean contains(int x10, int y10) {
        return x10 >= this.x && y10 >= this.y && x10 < this.x + this.width && y10 < this.y + this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public ModelNode getModelNode() {
        return this.modelNode;
    }

    public void setBounds(int x10, int y10, int width, int height) {
        this.x = x10;
        this.y = y10;
        this.width = width;
        this.height = height;
    }

    public void setX(int x10) {
        this.x = x10;
    }

    public void setY(int y10) {
        this.y = y10;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setOrigin(int x10, int y10) {
        this.x = x10;
        this.y = y10;
    }

    protected abstract void invalidateLayoutLocal();

    public final void invalidateLayoutUpTree() {
        if (this.layoutUpTreeCanBeInvalidated) {
            this.layoutUpTreeCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            RCollection parent = this.originalParent;
            if (parent == null) {
                parent = this.parent;
                if (parent == null) {
                    RenderableContainer rc2 = this.container;
                    if (rc2 != null) {
                        rc2.invalidateLayoutUpTree();
                    }
                } else {
                    parent.invalidateLayoutUpTree();
                }
            } else {
                parent.invalidateLayoutUpTree();
            }
        }
    }

    protected boolean isValid() {
        return this.layoutUpTreeCanBeInvalidated;
    }

    protected final void relayoutImpl(boolean invalidateLocal) {
        RCollection parent;
        if (invalidateLocal) {
            this.invalidateLayoutUpTree();
        }
        if ((parent = this.parent) instanceof BaseBoundableRenderable) {
            ((BaseBoundableRenderable)((Object)parent)).relayoutImpl(false);
        } else if (parent == null) {
            this.container.relayout();
        }
    }

    public void relayout() {
        if (EventQueue.isDispatchThread()) {
            this.relayoutImpl(true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BaseBoundableRenderable.this.relayout();
                }
            });
        }
    }

    public void setParent(RCollection parent) {
        this.parent = parent;
    }

    public RCollection getParent() {
        return this.parent;
    }

    public void setOriginalParent(RCollection origParent) {
        this.originalParent = origParent;
    }

    public RCollection getOriginalParent() {
        return this.originalParent;
    }

    public RCollection getOriginalOrCurrentParent() {
        RCollection origParent = this.originalParent;
        if (origParent == null) {
            return this.parent;
        }
        return origParent;
    }

    public void repaint(int x10, int y10, int width, int height) {
        RCollection parent = this.parent;
        if (parent instanceof BoundableRenderable) {
            ((BoundableRenderable)parent).repaint(x10 + this.x, y10 + this.y, width, height);
        } else if (parent == null) {
            this.container.repaint(x10, y10, width, height);
        }
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintTranslated(Graphics g10) {
        int x10 = this.x;
        int y10 = this.y;
        g10.translate(x10, y10);
        try {
            this.paint(g10);
        }
        finally {
            g10.translate(-x10, -y10);
        }
    }

    protected final Point translateDescendentPoint(BoundableRenderable descendent, int x10, int y10) {
        while (descendent != this) {
            if (descendent == null) {
                throw new IllegalStateException("Not descendent");
            }
            x10 += descendent.getX();
            y10 += descendent.getY();
            descendent = descendent.getParent();
        }
        return new Point(x10, y10);
    }

    static /* synthetic */ Class class$(String x02) {
        try {
            return Class.forName(x02);
        }
        catch (ClassNotFoundException x12) {
            throw new NoClassDefFoundError(x12.getMessage());
        }
    }
}

