/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import javax.swing.JButton;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputButtonControl
extends BaseInputControl {
    private final JButton widget;

    public InputButtonControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        JButton widget;
        this.setLayout(WrapperLayout.getInstance());
        this.widget = widget = new JButton();
        this.add(widget);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLInputElementImpl element = (HTMLInputElementImpl)this.controlElement;
        String text = element.getAttribute("value");
        if (text == null || text == "") {
            String type = element.getType();
            text = "submit".equalsIgnoreCase(type) ? "Submit Query" : ("reset".equalsIgnoreCase(type) ? "Reset" : "");
        }
        this.widget.setText(text);
    }

    public void click() {
        this.widget.doClick();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void setValue(String value) {
        this.widget.setText(value);
    }

    public void resetInput() {
    }
}

