/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import java.awt.Insets;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.DisplayRenderState;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableElement;

public class TableCellRenderState
extends DisplayRenderState {
    private int alignXPercent = -1;
    private int alignYPercent = -1;
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;
    private Insets paddingInsets = INVALID_INSETS;

    public TableCellRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element, 5);
    }

    public void invalidate() {
        super.invalidate();
        this.alignXPercent = -1;
        this.alignYPercent = -1;
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
        this.paddingInsets = INVALID_INSETS;
    }

    public int getAlignXPercent() {
        String textAlign;
        int axp = this.alignXPercent;
        if (axp != -1) {
            return axp;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        if (props != null && (textAlign = props.getTextAlign()) != null && textAlign.length() != 0) {
            return super.getAlignXPercent();
        }
        String align = this.element.getAttribute("align");
        HTMLElementImpl element = this.element;
        HTMLElement rowElement = null;
        Node parent = element.getParentNode();
        if (parent instanceof HTMLElement) {
            rowElement = (HTMLElement)parent;
        }
        if (align == null || align.length() == 0) {
            if (rowElement != null) {
                align = rowElement.getAttribute("align");
                if (align != null && align.length() == 0) {
                    align = null;
                }
            } else {
                align = null;
            }
        }
        axp = align == null ? ("TH".equalsIgnoreCase(element.getNodeName()) ? 50 : 0) : ("center".equalsIgnoreCase(align) || "middle".equalsIgnoreCase(align) ? 50 : ("left".equalsIgnoreCase(align) ? 0 : ("right".equalsIgnoreCase(align) ? 100 : 0)));
        this.alignXPercent = axp;
        return axp;
    }

    public int getAlignYPercent() {
        String textAlign;
        int ayp = this.alignYPercent;
        if (ayp != -1) {
            return ayp;
        }
        CSS2PropertiesImpl props = this.getCssProperties();
        if (props != null && (textAlign = props.getVerticalAlign()) != null && textAlign.length() != 0) {
            return super.getAlignYPercent();
        }
        String valign = this.element.getAttribute("valign");
        HTMLElementImpl element = this.element;
        HTMLElement rowElement = null;
        Node parent = element.getParentNode();
        if (parent instanceof HTMLElement) {
            rowElement = (HTMLElement)parent;
        }
        if (valign == null || valign.length() == 0) {
            if (rowElement != null) {
                valign = rowElement.getAttribute("valign");
                if (valign != null && valign.length() == 0) {
                    valign = null;
                }
            } else {
                valign = null;
            }
        }
        ayp = valign == null ? 50 : ("top".equalsIgnoreCase(valign) ? 0 : ("middle".equalsIgnoreCase(valign) || "center".equalsIgnoreCase(valign) ? 50 : ("bottom".equalsIgnoreCase(valign) ? 100 : 50)));
        this.alignYPercent = ayp;
        return ayp;
    }

    public BackgroundInfo getBackgroundInfo() {
        String background;
        BackgroundInfo binfo = this.backgroundInfo;
        if (binfo != INVALID_BACKGROUND_INFO) {
            return binfo;
        }
        binfo = super.getBackgroundInfo();
        HTMLTableCellElementImpl element = (HTMLTableCellElementImpl)this.element;
        HTMLTableRowElementImpl rowElement = null;
        Node parentNode = element.getParentNode();
        if (parentNode instanceof HTMLTableRowElementImpl) {
            rowElement = (HTMLTableRowElementImpl)parentNode;
        }
        if (binfo == null || binfo.backgroundColor == null) {
            String bgColor = element.getBgColor();
            if ((bgColor == null || "".equals(bgColor)) && rowElement != null) {
                bgColor = rowElement.getBgColor();
            }
            if (bgColor != null && !"".equals(bgColor)) {
                Color bgc = ColorFactory.getInstance().getColor(bgColor);
                if (binfo == null) {
                    binfo = new BackgroundInfo();
                }
                binfo.backgroundColor = bgc;
            }
        }
        if (!(binfo != null && binfo.backgroundImage != null || (background = element.getAttribute("background")) == null || "".equals(background))) {
            if (binfo == null) {
                binfo = new BackgroundInfo();
            }
            binfo.backgroundImage = background;
        }
        this.backgroundInfo = binfo;
        return binfo;
    }

    private HTMLTableElement getTableElement() {
        Node ancestor;
        for (ancestor = this.element.getParentNode(); ancestor != null && !(ancestor instanceof HTMLTableElement); ancestor = ancestor.getParentNode()) {
        }
        return (HTMLTableElement)ancestor;
    }

    public Insets getPaddingInsets() {
        Insets insets = this.paddingInsets;
        if (insets != INVALID_INSETS) {
            return insets;
        }
        insets = super.getPaddingInsets();
        if (insets == null) {
            HTMLTableElement tableElement = this.getTableElement();
            if (tableElement == null) {
                return null;
            }
            String cellPaddingText = tableElement.getAttribute("cellpadding");
            if (cellPaddingText != null && cellPaddingText.length() != 0) {
                int cellPadding = HtmlValues.getOldSyntaxPixelSize(cellPaddingText, 600, 0);
                insets = new Insets(cellPadding, cellPadding, cellPadding, cellPadding);
            }
        }
        this.paddingInsets = insets;
        return insets;
    }
}

