/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventObject;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class SimpleHttpRequest
implements HttpRequest {
    private static final Logger logger = null;
    private int readyState;
    private int status;
    private String statusText;
    private byte[] responseBytes;
    private Map responseHeadersMap;
    private String responseHeaders;
    private final UserAgentContext context;
    private URLConnection connection;
    private final EventDispatch readyEvent = new EventDispatch();

    public SimpleHttpRequest(UserAgentContext context) {
        this.context = context;
    }

    public synchronized int getReadyState() {
        return this.readyState;
    }

    public synchronized String getResponseText() {
        byte[] bytes = this.responseBytes;
        try {
            return bytes == null ? null : new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public synchronized Document getResponseXML() {
        byte[] bytes = this.responseBytes;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream in2 = new ByteArrayInputStream(bytes);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in2);
        }
        catch (Exception err) {
            return null;
        }
    }

    public synchronized byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public synchronized Image getResponseImage() {
        byte[] bytes = this.responseBytes;
        if (bytes == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(bytes);
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized String getStatusText() {
        return this.statusText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        URLConnection c10;
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            c10 = this.connection;
        }
        if (c10 instanceof HttpURLConnection) {
            ((HttpURLConnection)c10).disconnect();
        } else if (c10 != null) {
            try {
                c10.getInputStream().close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public synchronized String getAllResponseHeaders() {
        return this.responseHeaders;
    }

    public synchronized String getResponseHeader(String headerName) {
        Map headers = this.responseHeadersMap;
        return headers == null ? null : (String)headers.get(headerName);
    }

    public void open(String method, String url) {
        this.open(method, url, true);
    }

    public void open(String method, URL url) {
        this.open(method, url, true, null, null);
    }

    public void open(String method, URL url, boolean asyncFlag) {
        this.open(method, url, asyncFlag, null, null);
    }

    public void open(String method, String url, boolean asyncFlag) {
        this.open(method, url, asyncFlag, null);
    }

    public void open(String method, String url, boolean asyncFlag, String userName) {
        this.open(method, url, asyncFlag, userName, null);
    }

    public void open(String method, String url, boolean asyncFlag, String userName, String password) {
        try {
            URL urlObj = new URL(url);
            this.open(method, urlObj, asyncFlag, userName, password);
        }
        catch (MalformedURLException mfu) {
            this.changeState(4, 400, "Malformed URI", null);
        }
    }

    public void open(final String method, final URL url, boolean asyncFlag, final String userName, final String password) {
        if (asyncFlag) {
            new Thread("Request"){

                public void run() {
                    SimpleHttpRequest.this.openSync(method, url, userName, password);
                }
            }.start();
        } else {
            this.openSync(method, url, userName, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int readyState, int status, String statusMessage, byte[] bytes) {
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.readyState = readyState;
            this.status = status;
            this.statusText = statusMessage;
            this.responseBytes = bytes;
        }
        this.readyEvent.fireEvent(null);
    }

    private String getAllResponseHeaders(URLConnection c10) {
        String value;
        int idx = 0;
        StringBuffer buf = new StringBuffer();
        while ((value = c10.getHeaderField(idx)) != null) {
            String key = c10.getHeaderFieldKey(idx);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
            ++idx;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openSync(String method, URL url, String userName, String password) {
        try {
            this.abort();
            URLConnection c10 = url.openConnection();
            SimpleHttpRequest simpleHttpRequest = this;
            synchronized (simpleHttpRequest) {
                this.connection = c10;
            }
            try {
                c10.setRequestProperty("User-Agent", this.context.getUserAgent());
                this.changeState(1, 0, "", null);
                InputStream in2 = c10.getInputStream();
                int contentLength = c10.getContentLength();
                byte[] bytes = IORoutines.load(in2, contentLength == -1 ? 4096 : contentLength);
                int status = 0;
                String statusText = "";
                if (c10 instanceof HttpURLConnection) {
                    HttpURLConnection hc2 = (HttpURLConnection)c10;
                    status = hc2.getResponseCode();
                    statusText = hc2.getResponseMessage();
                }
                SimpleHttpRequest simpleHttpRequest2 = this;
                synchronized (simpleHttpRequest2) {
                    this.responseHeaders = this.getAllResponseHeaders(c10);
                    this.responseHeadersMap = c10.getHeaderFields();
                }
                this.changeState(4, status, statusText, bytes);
            }
            finally {
                simpleHttpRequest = this;
                synchronized (simpleHttpRequest) {
                    this.connection = null;
                }
            }
        }
        catch (Exception err) {
            this.changeState(4, err instanceof FileNotFoundException ? 404 : 400, err.getMessage(), null);
        }
    }

    public void addReadyStateChangeListener(final ReadyStateChangeListener listener) {
        this.readyEvent.addListener(new GenericEventListener(){

            public void processEvent(EventObject event) {
                listener.readyStateChanged();
            }
        });
    }
}

