/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class LRUCache
implements Serializable {
    private static final long serialVersionUID = 940427225784212823L;
    private final int approxMaxSize;
    private final Map cacheMap = new HashMap();
    private final TreeSet timedSet = new TreeSet();
    private int currentSize = 0;

    public LRUCache(int approxMaxSize) {
        this.approxMaxSize = approxMaxSize;
    }

    public void put(Object key, Object value, int approxSize) {
        if (approxSize > this.approxMaxSize) {
            throw new IllegalArgumentException("Max size is " + this.approxMaxSize);
        }
        OrderedValue ordVal = (OrderedValue)this.cacheMap.get(key);
        if (ordVal != null) {
            this.currentSize += approxSize - ordVal.approximateSize;
            this.timedSet.remove(ordVal);
            ordVal.approximateSize = approxSize;
            ordVal.value = value;
            ordVal.touch();
            this.timedSet.add(ordVal);
        } else {
            ordVal = new OrderedValue(value, approxSize);
            this.cacheMap.put(key, ordVal);
            this.timedSet.add(ordVal);
            this.currentSize += approxSize;
        }
        while (this.currentSize > this.approxMaxSize) {
            this.removeLRU();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeLRU() {
        OrderedValue ordVal = (OrderedValue)this.timedSet.first();
        if (ordVal == null) throw new IllegalStateException("Cannot remove LRU since the cache is empty.");
        if (!this.timedSet.remove(ordVal)) throw new IllegalStateException("Could not remove existing tree node.");
        this.currentSize -= ordVal.approximateSize;
    }

    public Object get(Object key) {
        OrderedValue ordVal = (OrderedValue)this.cacheMap.get(key);
        if (ordVal != null) {
            this.timedSet.remove(ordVal);
            ordVal.touch();
            this.timedSet.add(ordVal);
            return ordVal.value;
        }
        return null;
    }

    private class OrderedValue
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 340227625744215821L;
        private long timestamp;
        private int approximateSize;
        private Object value;

        private OrderedValue(Object value, int approxSize) {
            this.value = value;
            this.approximateSize = approxSize;
            this.touch();
        }

        private final void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public int compareTo(Object arg0) {
            int hc2;
            if (this == arg0) {
                return 0;
            }
            OrderedValue other = (OrderedValue)arg0;
            long diff = this.timestamp - other.timestamp;
            if (diff != 0L) {
                return (int)diff;
            }
            int hc1 = System.identityHashCode(this);
            if (hc1 == (hc2 = System.identityHashCode(other))) {
                hc1 = System.identityHashCode(this.value);
                hc2 = System.identityHashCode(other.value);
            }
            return hc1 - hc2;
        }
    }
}

