//-----------------------------------------------------------------------------
// Layer
//-----------------------------------------------------------------------------

#include "layer.h"
#include "consts.h"
#include "system.h"
#include <stdlib.h>

LayerManager::LayerManager(void)
{
}

LayerManager::~LayerManager(void)
{
}

// CreateLayer allocates a layer and fills it with default values
Layer *LayerManager::CreateLayer(void)
{
  Layer *layer = new Layer;
  if (!layer) ThrowException(ALLOCATION_ERROR, "LayerManager::CreateLayer.layer");

  layer->flags = 0;
  layer->num_maps = 0;
  layer->anim_speed = 0;
  
  for (int i = 0; i < MAX_ANIMFRAMES; ++i) layer->map[i] = NULL;

  layer->tcMod = NULL;
  layer->aGen = NULL;

  layer->alphaGen = ALPHAGEN_NONE;
  layer->alphaGenParams[0] = 0;

  layer->tcGen = TCGEN_BASE;
  layer->rgbGen = RGBGEN_IDENTITY;

  layer->alphafunc = IntForConst("GL_ALWAYS");
  layer->alphafuncref = 1.0f;

  layer->blendsrc = IntForConst("GL_ONE");
  layer->blenddst = IntForConst("GL_ZERO");

  layer->depthFunc = IntForConst("GL_LEQUAL");
  layer->depthWrite = true;
  
  return layer;
}

void LayerManager::DeleteLayer(Layer *layer)
{
  if (layer != NULL)
  {
    funclist *f, *fnext;
    for (f = layer->tcMod; f; f = fnext)
    {
      fnext = f->next;
      delete f;
    }

    layer->tcMod = NULL;
    for (f = layer->aGen; f; f = fnext)
    {
      fnext = f->next;
      delete f;
    }
    layer->aGen = NULL;

    // NOTE: we do not delete the map here, because it is shared by other layers.

    delete layer;
  }
}
