#ifndef _H_ADA_NAME_
#define _H_ADA_NAME_

typedef enum {
	Upper,
	Lower,
	Cap
} ident_case_t;

/* Function to determine if an identifier is an Ada reserved word */
extern int is_ada_keyword _ANSI_PROTO_((char*));

/* Function to make a legal Ada identifier out of a C identifier */
extern void make_ada_identifier _ANSI_PROTO_((char*, char*));

/* Function to create a unique name */
extern char *uniq_name _ANSI_PROTO_((char *name, int unit));

/* Function to create a possibly unique Ada identifier for a given unit */
extern char *ada_name _ANSI_PROTO_((char *name, int unit));

/* Function to determine if an identifier is unique */
extern int is_uniq_name _ANSI_PROTO_((char *name, int unit));

/* Function to determine the case of an identifier */
extern ident_case_t id_case _ANSI_PROTO_((char*));

/* Function to force an identifier into a specified case */
extern void id_format _ANSI_PROTO_((char*,ident_case_t));

#endif /* _H_ADA_NAME_ */
