/*
 * Rediculous heap routines
 */
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include "ansi.h"
#include "config.h"
#include "allocate.h"

#undef NULL
#define NULL			0

/* should be defined in unistd.h */
#ifndef STDERR_FILENO
#define STDERR_FILENO	2
#endif


static char nomem[] = "\nMemory exhausted\n";

char*
new_string(str)
	char *str;
{
	char *result;
	int len;

	assert(str != NULL);
	len = strlen(str);
	assert(len >= 0);
	result = (char*)malloc(len + 1);
	if (result == NULL) {
		write(STDERR_FILENO, nomem, sizeof(nomem) - 1);
		exit(1);
	}
	strcpy(result, str);
	return result;
}

void*
allocate(size)
	size_t size;
{
	void *ptr;

	assert(size > 0);
	ptr = (void*)malloc(size);
	if (ptr == NULL) {
		write(STDERR_FILENO, nomem, sizeof(nomem) - 1);
		exit(1);
	}
	memset(ptr, 0, size);
	return ptr;
}

void
deallocate(ptr)
	void *ptr;
{
	free(ptr);
}
