/*
 * This type info format closely matches that defined in
 * the book "Compiler Design in C" by Holub.  Feel free
 * to borrow it from me if you need to reference it.
 */
#ifndef _H_TYPES_
#define _H_TYPES_

#define nyi()	not_implemented(__FILE__,__LINE__)

extern void not_implemented _ANSI_PROTO_((char*,int));

extern void type_init _ANSI_PROTO_((void));

extern typeinfo_t *typeof_void _ANSI_PROTO_((void));
extern typeinfo_t *typeof_char _ANSI_PROTO_((void));
extern typeinfo_t *typeof_int _ANSI_PROTO_((int is_unsigned));
extern typeinfo_t *typeof_float _ANSI_PROTO_((void));
extern typeinfo_t *typeof_double _ANSI_PROTO_((void));

extern typeinfo_t *typeof_typemod _ANSI_PROTO_((int));
extern typeinfo_t *typeof_typespec _ANSI_PROTO_((typeinfo_t*));
extern typeinfo_t *typeof_specifier _ANSI_PROTO_((symbol_t*));

extern decl_class_t decl_class _ANSI_PROTO_((typeinfo_t*));

extern symbol_t *copy_sym _ANSI_PROTO_((symbol_t*));
extern symbol_t *concat_symbols _ANSI_PROTO_((symbol_t*,symbol_t*));
extern symbol_t *grok_enumerator _ANSI_PROTO_((node_t*,node_t*));

extern void grok_declarations _ANSI_PROTO_((symbol_t*));

extern void start_typedef _ANSI_PROTO_((void));
extern void storage_class _ANSI_PROTO_((int));
extern void type_mod _ANSI_PROTO_((int));
extern void type_qual _ANSI_PROTO_((int));

extern symbol_t *anonymous_enum _ANSI_PROTO_((symbol_t*));
extern symbol_t *named_enum _ANSI_PROTO_((node_t*,symbol_t*));
extern symbol_t *enum_reference _ANSI_PROTO_((node_t*));
extern symbol_t *anonymous_rec _ANSI_PROTO_((int,symbol_t*));
extern symbol_t *named_rec _ANSI_PROTO_((int,node_t*,symbol_t*));
extern symbol_t *rec_reference _ANSI_PROTO_((int,node_t*));
extern symbol_t *novar_declaration _ANSI_PROTO_((typeinfo_t*));
extern symbol_t *var_declaration _ANSI_PROTO_((typeinfo_t*, node_t*));
extern symbol_t *field_declaration _ANSI_PROTO_((typeinfo_t*, node_t*));
extern symbol_t *function_spec _ANSI_PROTO_((typeinfo_t*, node_t*));

extern symbol_t *elipsis_arg _ANSI_PROTO_((void));

extern typeinfo_t *noname_type _ANSI_PROTO_((typeinfo_t*, node_t*));

extern symbol_t *noname_simple_param _ANSI_PROTO_((typeinfo_t*));
extern symbol_t *noname_abstract_param _ANSI_PROTO_((typeinfo_t*, node_t*));
extern symbol_t *named_abstract_param _ANSI_PROTO_((typeinfo_t*, node_t*));

extern void typed_external_decl _ANSI_PROTO_((symbol_t*));
extern void function_def _ANSI_PROTO_((symbol_t*));
extern void KnR_params _ANSI_PROTO_((symbol_t*,symbol_t*));

#endif /* _H_TYPES_ */
