/*
 * Interface to generated Ada units.  We not only have to
 * keep tract of what we generated, but also what packages
 * we must "with" when generating a package.  The unit_ref
 * and direct_ref sets keep tract of that info.
 */
#ifndef _H_UNITS_
#define _H_UNITS_

#define BITS_PER_INT			(sizeof(int) * BITS_PER_BYTE)
#define UNIT_SET_SIZE			((MAX_UNIQ_FNAMES + BITS_PER_INT - 1) / BITS_PER_INT)

typedef int unit_ref_t[UNIT_SET_SIZE];

typedef struct {
	unsigned	initialized:1;
	char 		*src_path;		/* C source file name */
	char 		*unit_name;		/* Ada package name */
	char 		*unit_path;		/* Output file name */
	unit_ref_t 	unit_ref;		/* Set of all units to be withed */
	unit_ref_t 	direct_ref;		/* Set of all units to be withed */
} ada_unit_t;

extern void unit_start_gen _ANSI_PROTO_((void));
extern int set_unit _ANSI_PROTO_((int));
extern int current_unit _ANSI_PROTO_((void));
extern void unit_completed _ANSI_PROTO_((void));
extern void unit_included _ANSI_PROTO_((file_pos_t, int));
extern void init_unit _ANSI_PROTO_((file_pos_t));
extern void unit_dependency _ANSI_PROTO_((int,int));
extern char *cur_unit_source _ANSI_PROTO_((void));
extern char *cur_unit_name _ANSI_PROTO_((void));
extern char *cur_unit_path _ANSI_PROTO_((void));
extern char *unit_name _ANSI_PROTO_((int));
extern char *include_path _ANSI_PROTO_((int));
extern int nth_ref_unit_ord _ANSI_PROTO_((int));
extern int nth_direct_ref_unit_ord _ANSI_PROTO_((int));

#endif /* _H_UNITS_ */
