/*
 * Decompiled with CFR 0.152.
 */
package cbviewer;

import cbviewer.CBAboutBox;
import cbviewer.CBJumpMenu;
import cbviewer.CBViewer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class CBMenu
extends JMenuBar {
    private CBViewer theApp;
    private JMenu fileMenu = new JMenu();
    private JMenuItem openItem = new JMenuItem();
    private JMenuItem closeItem = new JMenuItem();
    private JMenuItem quitItem = new JMenuItem();
    protected CBJumpMenu jumpMenu;
    private JMenu helpMenu = new JMenu();
    private JMenuItem aboutItem = new JMenuItem();
    private CBAboutBox aboutDialog;
    private JMenu optionsMenu = new JMenu();
    private JMenuItem barsItem = new JMenuItem();
    private JMenuItem controlsItem = new JMenuItem();

    public CBMenu(CBViewer cBViewer) {
        this.theApp = cBViewer;
        this.fileMenu.setText("File");
        this.fileMenu.setToolTipText("File Menu");
        this.openItem.setText("Open Archive");
        this.openItem.setToolTipText("Open a comic archive");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.openActionPerformed(actionEvent);
            }
        });
        this.closeItem.setText("Close Archive");
        this.closeItem.setToolTipText("Close archive");
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.closeActionPerformed(actionEvent);
            }
        });
        this.closeItem.setEnabled(false);
        this.quitItem.setText("Quit");
        this.quitItem.setToolTipText("Quit CBViewer");
        this.quitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.quitActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(this.closeItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.quitItem);
        this.add(this.fileMenu);
        this.jumpMenu = new CBJumpMenu(cBViewer);
        this.jumpMenu.setText("Jump");
        this.jumpMenu.setToolTipText("Jump Menu");
        this.add(this.jumpMenu);
        this.optionsMenu.setText("Options");
        this.optionsMenu.setToolTipText("Select program options");
        this.barsItem.setText("Scrollbars Visible");
        this.barsItem.setToolTipText("Make scroll bars visible/not visible");
        this.barsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.barsActionPerformed(actionEvent);
            }
        });
        this.controlsItem.setText("Controls Visible");
        this.controlsItem.setToolTipText("Make controls visible/not visible");
        this.controlsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.controlsActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.barsItem);
        this.optionsMenu.add(this.controlsItem);
        this.add(this.optionsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setToolTipText("Help Menu");
        this.aboutItem.setText("About");
        this.aboutItem.setToolTipText("About this program");
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CBMenu.this.aboutActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.add(this.helpMenu);
    }

    private void openActionPerformed(ActionEvent actionEvent) {
        this.theApp.loader.openArchive(0, "");
    }

    private void closeActionPerformed(ActionEvent actionEvent) {
        this.theApp.loader.closeArchive(actionEvent);
    }

    private void quitActionPerformed(ActionEvent actionEvent) {
        this.theApp.exitCBViewer();
    }

    private void aboutActionPerformed(ActionEvent actionEvent) {
        this.aboutDialog = new CBAboutBox(this.theApp.frame);
        this.aboutDialog.setVisible(true);
    }

    private void barsActionPerformed(ActionEvent actionEvent) {
        if (this.theApp.prefs.getBoolean("scrollbars_visible", true)) {
            this.theApp.prefs.putBoolean("scrollbars_visible", false);
        } else {
            this.theApp.prefs.putBoolean("scrollbars_visible", true);
        }
        this.theApp.redrawCBViewer();
    }

    private void controlsActionPerformed(ActionEvent actionEvent) {
        if (this.theApp.prefs.getBoolean("toolbar_visible", true)) {
            this.theApp.prefs.putBoolean("toolbar_visible", false);
        } else {
            this.theApp.prefs.putBoolean("toolbar_visible", true);
        }
        this.theApp.redrawCBViewer();
    }

    protected void enableCloseArchive(boolean bl) {
        this.closeItem.setEnabled(bl);
    }
}

