/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuildMessages;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class HeadlessBuilder
implements IApplication {
    private static final String PREF_BUILD_ALL_CONFIGS = "build.all.configs.enabled";
    public static final Integer ERROR = -1;
    public static final Integer OK = IApplication.EXIT_OK;
    private final Set<String> projectsToImport = new HashSet<String>();
    private final Set<String> projectsToBuild = new HashSet<String>();
    private final Set<String> projectsToClean = new HashSet<String>();
    private boolean buildAll = false;
    private boolean cleanAll = false;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        monitor = new PrintingProgressMonitor();
        root = ResourcesPlugin.getWorkspace().getRoot();
        isAutoBuilding = root.getWorkspace().isAutoBuilding();
        try {
            block40: {
                desc = root.getWorkspace().getDescription();
                desc.setAutoBuilding(false);
                root.getWorkspace().setDescription(desc);
                if (!root.isAccessible()) {
                    System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Workspace) + root.getLocationURI().toString() + HeadlessBuildMessages.HeadlessBuilder_is_not_accessible);
                    var16_6 = HeadlessBuilder.ERROR;
                    return var16_6;
                }
                if (!this.getArguments((String[])context.getArguments().get("application.args"))) {
                    var16_7 = HeadlessBuilder.ERROR;
                    return var16_7;
                }
                if (System.getProperty("org.eclipse.cdt.core.console") == null) {
                    System.setProperty("org.eclipse.cdt.core.console", "org.eclipse.cdt.core.systemConsole");
                }
                var6_15 = this.projectsToImport.iterator();
                while (true) {
                    block39: {
                        block37: {
                            block36: {
                                block41: {
                                    if (var6_15.hasNext()) break block41;
                                    prefs = CCorePlugin.getDefault().getPluginPreferences();
                                    buildAllConfigs = prefs.getBoolean("build.all.configs.enabled");
                                    ** try [egrp 11[TRYBLOCK] [5 : 919->1200)] { 
lbl24:
                                    // 1 sources

                                    ** GOTO lbl-1000
                                }
                                projURIStr = var6_15.next();
                                in = null;
                                project_uri = null;
                                try {
                                    project_uri = URI.create(projURIStr);
                                }
                                catch (Exception v0) {}
                                if (project_uri == null || project_uri.getScheme() == null) {
                                    p = new Path(projURIStr).addTrailingSeparator();
                                    project_uri = URIUtil.toURI((IPath)p);
                                }
                                if (!(uri_string = project_uri.toASCIIString()).endsWith("/")) {
                                    uri_string = String.valueOf(uri_string) + '/';
                                    project_uri = new URI(uri_string);
                                }
                                if (!(fstore = EFS.getStore((URI)project_uri.resolve(".project"))).fetchInfo().exists()) {
                                    System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + project_uri.resolve(".project") + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                                    var14_24 = HeadlessBuilder.ERROR;
                                    if (in == null) break block36;
                                }
                                ** GOTO lbl-1000
                                in.close();
                            }
lbl-1000:
                            // 1 sources

                            {
                                in = fstore.openInputStream(0, (IProgressMonitor)monitor);
                                desc = root.getWorkspace().loadProjectDescription(in);
                                project = root.getProject(desc.getName());
                                if (!project.exists()) ** GOTO lbl-1000
                                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + desc.getName() + HeadlessBuildMessages.HeadlessBuilder_already_exists_in_workspace);
                                var14_25 = HeadlessBuilder.ERROR;
                                if (in == null) break block37;
                            }
                            in.close();
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (root.getWorkspace().validateProjectLocationURI(project, project_uri).equals(Status.OK_STATUS)) break;
                            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_URI) + project_uri + HeadlessBuildMessages.HeadlessBuilder_is_not_valid_in_workspace);
                            var14_26 = HeadlessBuilder.ERROR;
                            if (in == null) break block39;
                        }
                        in.close();
                    }
                    ** try [egrp 10[TRYBLOCK] [4 : 837->867)] { 
lbl70:
                    // 1 sources

                    desc.setLocationURI(project_uri);
                    project.create(desc, (IProgressMonitor)monitor);
                    project.open((IProgressMonitor)monitor);
                }
lbl74:
                // 1 sources

                finally {
                    if (in != null) {
                        in.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    prefs.setValue("build.all.configs.enabled", true);
                    if (this.cleanAll) {
                        System.out.println(HeadlessBuildMessages.HeadlessBuilder_cleaning_all_projects);
                        root.getWorkspace().build(15, (IProgressMonitor)monitor);
                    } else {
                        for (String project : this.projectsToClean) {
                            prj = root.getProject(project);
                            if (!prj.exists()) {
                                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_clean_failed) + project + HeadlessBuildMessages.HeadlessBuilder_16);
                                continue;
                            }
                            prj.build(15, (IProgressMonitor)monitor);
                        }
                    }
                    if (this.buildAll) {
                        System.out.println(HeadlessBuildMessages.HeadlessBuilder_building_all);
                        root.getWorkspace().build(6, (IProgressMonitor)monitor);
                        break block40;
                    } else {
                        for (String project : this.projectsToBuild) {
                            prj = root.getProject(project);
                            if (!prj.exists()) {
                                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_build_failed) + project + HeadlessBuildMessages.HeadlessBuilder_16);
                                continue;
                            }
                            prj.build(6, (IProgressMonitor)monitor);
                        }
                    }
                }
lbl102:
                // 1 sources

                catch (Throwable var10_21) {
                    prefs.setValue("build.all.configs.enabled", buildAllConfigs);
                    CCorePlugin.getDefault().savePluginPreferences();
                    throw var10_21;
                }
            }
            prefs.setValue("build.all.configs.enabled", buildAllConfigs);
            CCorePlugin.getDefault().savePluginPreferences();
        }
        finally {
            desc = root.getWorkspace().getDescription();
            desc.setAutoBuilding(isAutoBuilding);
            root.getWorkspace().setDescription(desc);
        }
        while (true) {
            if (Job.getJobManager().isIdle()) {
                return var16_6;
            }
            Thread.sleep(10L);
        }
    }

    private boolean getArguments(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new Exception(HeadlessBuildMessages.HeadlessBuilder_no_arguments);
            }
            int i = 0;
            while (i < args.length) {
                if ("-import".equals(args[i])) {
                    this.projectsToImport.add(args[++i]);
                } else if ("-build".equals(args[i])) {
                    this.projectsToBuild.add(args[++i]);
                } else if ("-cleanBuild".equals(args[i])) {
                    this.projectsToClean.add(args[++i]);
                } else {
                    System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_unknown_argument) + args[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_invalid_argument) + args != null ? Arrays.toString(args) : "");
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Error) + e.getMessage());
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_import);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_build);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_clean_build);
            return false;
        }
        if (this.projectsToClean.contains("all")) {
            this.cleanAll = true;
            this.buildAll = true;
            this.projectsToClean.remove("all");
        }
        if (this.projectsToBuild.contains("all")) {
            this.buildAll = true;
            this.projectsToBuild.remove("all");
        }
        this.projectsToBuild.addAll(this.projectsToClean);
        return true;
    }

    public void stop() {
    }

    private class PrintingProgressMonitor
    extends NullProgressMonitor {
        private PrintingProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                System.out.println(name);
            }
        }
    }
}

