/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.variable;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.DsfDebugUITools;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.BreakpointHitUpdatePolicy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableColumnPresentation;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class VariableVMProvider
extends AbstractDMVMProvider
implements IColumnPresentationFactory {
    private IPropertyChangeListener fPreferencesListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("delaySteppingForViewUpdatesEnable")) {
                IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
                VariableVMProvider.this.setDelayEventHandleForViewUpdate(store.getBoolean(property));
            }
        }
    };
    private IPropertyChangeListener fPresentationContextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            VariableVMProvider.this.handleEvent(event);
        }
    };

    public VariableVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.addPropertyChangeListener(this.fPresentationContextListener);
        IPreferenceStore store = DsfDebugUITools.getPreferenceStore();
        store.addPropertyChangeListener(this.fPreferencesListener);
        this.setDelayEventHandleForViewUpdate(store.getBoolean("delaySteppingForViewUpdatesEnable"));
        SyncVariableDataAccess varAccess = new SyncVariableDataAccess(session);
        RootDMVMNode rootNode = new RootDMVMNode(this);
        this.setRootNode(rootNode);
        VariableVMNode subExpressioNode = new VariableVMNode((AbstractDMVMProvider)this, this.getSession(), varAccess);
        this.addChildNodes(rootNode, new IVMNode[]{subExpressioNode});
        this.addChildNodes(subExpressioNode, new IVMNode[]{subExpressioNode});
    }

    public void dispose() {
        DsfDebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferencesListener);
        this.getPresentationContext().removePropertyChangeListener(this.fPresentationContextListener);
        super.dispose();
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new VariableColumnPresentation();
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.cdt.dsf.ui.VARIABLES_COLUMN_PRESENTATION_ID";
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy(), new ManualUpdatePolicy(), new BreakpointHitUpdatePolicy()};
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return newEvent instanceof IRunControl.ISuspendedDMEvent;
    }

    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), VariableVMProvider.this.getSession().getId());
                    IExpressions expressionsService = (IExpressions)tracker.getService(IExpressions.class);
                    if (expressionsService instanceof ICachingService) {
                        ((ICachingService)expressionsService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }
}

