/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;

public class VMDelta
extends ModelDelta {
    private VMDelta fParent;
    private Object fElement;
    private int fFlags;
    private VMDelta[] fNodes = EMPTY_NODES;
    private Object fReplacement;
    private int fIndex;
    private static final VMDelta[] EMPTY_NODES = new VMDelta[0];
    private int fChildCount = -1;

    public VMDelta(Object element, int flags) {
        super(element, flags);
        this.fElement = element;
        this.fFlags = flags;
    }

    public VMDelta(Object element, Object replacement, int flags) {
        super(element, replacement, flags);
        this.fElement = element;
        this.fReplacement = replacement;
        this.fFlags = flags;
    }

    public VMDelta(Object element, int index, int flags) {
        super(element, index, flags);
        this.fElement = element;
        this.fIndex = index;
        this.fFlags = flags;
    }

    public VMDelta(Object element, int index, int flags, int childCount) {
        super(element, index, flags, childCount);
        this.fElement = element;
        this.fIndex = index;
        this.fFlags = flags;
        this.fChildCount = childCount;
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }

    public void setChildCount(int count) {
        this.fChildCount = count;
    }

    public VMDelta addNode(Object element, int flags) {
        VMDelta node = new VMDelta(element, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public VMDelta addNode(Object element, Object replacement, int flags) {
        VMDelta node = new VMDelta(element, replacement, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public VMDelta addNode(Object element, int index, int flags) {
        VMDelta node = new VMDelta(element, index, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public VMDelta addNode(Object element, int index, int flags, int numChildren) {
        VMDelta node = new VMDelta(element, index, flags, numChildren);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public VMDelta getChildDelta(Object element) {
        if (this.fNodes != null) {
            int i = 0;
            while (i < this.fNodes.length) {
                VMDelta delta = this.fNodes[i];
                if (element.equals(delta.getElement())) {
                    return delta;
                }
                ++i;
            }
        }
        return null;
    }

    void setParent(VMDelta node) {
        this.fParent = node;
    }

    public VMDelta getParentDelta() {
        return this.fParent;
    }

    public Object getReplacementElement() {
        return this.fReplacement;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public VMDelta[] getChildDeltas() {
        return this.fNodes;
    }

    private void addDelta(VMDelta delta) {
        if (this.fNodes.length == 0) {
            this.fNodes = new VMDelta[]{delta};
        } else {
            VMDelta[] nodes = new VMDelta[this.fNodes.length + 1];
            System.arraycopy(this.fNodes, 0, nodes, 0, this.fNodes.length);
            nodes[this.fNodes.length] = delta;
            this.fNodes = nodes;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Model Delta Start\n");
        this.appendDetail(buf, this);
        buf.append("Model Delta End\n");
        return buf.toString();
    }

    private void appendDetail(StringBuffer buf, VMDelta delta) {
        buf.append("\tElement: ");
        buf.append(delta.getElement());
        buf.append('\n');
        buf.append("\t\tFlags: ");
        int flags = delta.getFlags();
        if (flags == 0) {
            buf.append("NO_CHANGE");
        } else {
            if ((flags & 1) > 0) {
                buf.append("ADDED | ");
            }
            if ((flags & 0x400) > 0) {
                buf.append("CONTENT | ");
            }
            if ((flags & 0x100000) > 0) {
                buf.append("EXPAND | ");
            }
            if ((flags & 0x10) > 0) {
                buf.append("INSERTED | ");
            }
            if ((flags & 2) > 0) {
                buf.append("REMOVED | ");
            }
            if ((flags & 8) > 0) {
                buf.append("REPLACED | ");
            }
            if ((flags & 0x200000) > 0) {
                buf.append("SELECT | ");
            }
            if ((flags & 0x800) > 0) {
                buf.append("STATE | ");
            }
            if ((flags & 0x400000) > 0) {
                buf.append("INSTALL | ");
            }
            if ((flags & 0x800000) > 0) {
                buf.append("UNINSTALL | ");
            }
        }
        buf.append('\n');
        buf.append("\t\tIndex: ");
        buf.append(delta.fIndex);
        buf.append(" Child Count: ");
        buf.append(delta.fChildCount);
        buf.append('\n');
        VMDelta[] nodes = delta.getChildDeltas();
        int i = 0;
        while (i < nodes.length) {
            this.appendDetail(buf, nodes[i]);
            ++i;
        }
    }

    public int getChildCount() {
        return this.fChildCount;
    }

    public void accept(IModelDeltaVisitor visitor) {
        this.doAccept(visitor, 0);
    }

    protected void doAccept(IModelDeltaVisitor visitor, int depth) {
        if (visitor.visit((IModelDelta)this, depth)) {
            VMDelta[] childDeltas = this.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                childDeltas[i].doAccept(visitor, depth + 1);
                ++i;
            }
        }
    }
}

