/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager2;

public class BorderLayout
implements LayoutManager2 {
    private int _hgap = 0;
    private int _vgap = 0;
    private Component _north = null;
    private Component _south = null;
    private Component _west = null;
    private Component _east = null;
    private Component _center = null;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";

    public void addLayoutComponent(Component component_, Object constraint_) {
        String constraint = (String)constraint_;
        if (constraint.equals(NORTH)) {
            this._north = component_;
        } else if (constraint.equals(SOUTH)) {
            this._south = component_;
        } else if (constraint.equals(WEST)) {
            this._west = component_;
        } else if (constraint.equals(EAST)) {
            this._east = component_;
        } else if (constraint.equals(CENTER)) {
            this._center = component_;
        }
    }

    public Dimension minimumSize(Container container_) {
        int width = 0;
        int height = 0;
        Dimension northSize = null;
        Dimension eastSize = null;
        Dimension southSize = null;
        Dimension westSize = null;
        Dimension centerSize = null;
        if (this._west != null) {
            westSize = this._west.minimumSize();
            height = westSize.height;
            width = westSize.width;
        }
        if (this._center != null) {
            centerSize = this._center.minimumSize();
            if (centerSize.height > height) {
                height = centerSize.height;
            }
            width += centerSize.width;
        }
        if (this._east != null) {
            eastSize = this._east.minimumSize();
            if (eastSize.height > height) {
                height = eastSize.height;
            }
            width += eastSize.width;
        }
        if (this._north != null) {
            northSize = this._north.minimumSize();
            height += northSize.height;
            if (northSize.width > width) {
                width = northSize.width;
            }
        }
        if (this._south != null) {
            southSize = this._south.minimumSize();
            height += southSize.height;
            if (southSize.width > width) {
                width = southSize.width;
            }
        }
        Insets insets = container_.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public void doLayout(Container container_) {
        int padding;
        Dimension size = container_.getSize();
        Insets insets = container_.getInsets();
        this.expandContainers(container_);
        int availableHeight = size.height - insets.top - insets.bottom;
        int availableWidth = size.width - insets.left - insets.bottom;
        int northbottom = insets.top;
        int westright = insets.left;
        if (this._north != null) {
            padding = size.width - this._north.getSize().width;
            this._north.setLocation(padding / 2, insets.top);
            availableHeight -= this._north.getSize().height;
            northbottom += this._north.getSize().height;
        }
        if (this._south != null) {
            padding = size.width - this._south.getSize().width;
            this._south.setLocation(padding / 2, size.height - insets.bottom - this._south.getSize().height);
            availableHeight -= this._south.getSize().height;
        }
        if (this._west != null) {
            this._west.setLocation(insets.left, northbottom + (availableHeight - this._west.getSize().height) / 2);
            availableWidth -= this._west.getSize().width;
            westright += this._west.getSize().width;
        }
        if (this._east != null) {
            this._east.setLocation(size.width - insets.right - this._east.getSize().width, northbottom + (availableHeight - this._east.getSize().height) / 2);
            availableWidth -= this._east.getSize().width;
        }
        if (this._center != null) {
            this._center.setLocation(westright + (availableWidth - this._center.getSize().width) / 2, northbottom + (availableHeight - this._center.getSize().height) / 2);
        }
    }

    public void invalidateLayout(Container target_) {
    }

    private void expandContainers(Container container_) {
        Dimension size = container_.getSize();
        Insets insets = container_.getInsets();
        int availableHeight = size.height - insets.top - insets.bottom;
        int availableWidth = size.width - insets.left - insets.right;
        if (this._north != null) {
            if (this._north instanceof Container) {
                ((Container)this._north).setWidth(availableWidth);
                ((Container)this._north).setHeight(this._north.minimumSize().height);
                ((Container)this._north).doLayout();
            }
            availableHeight -= this._north.getSize().height;
        }
        if (this._south != null) {
            if (this._south instanceof Container) {
                ((Container)this._south).setWidth(availableWidth);
                ((Container)this._south).setHeight(this._south.minimumSize().height);
                ((Container)this._south).doLayout();
            }
            availableHeight -= this._south.getSize().height;
        }
        if (this._west != null) {
            if (this._west instanceof Container) {
                ((Container)this._west).setWidth(this._west.minimumSize().width);
                ((Container)this._west).setHeight(availableHeight);
                ((Container)this._west).doLayout();
            }
            availableWidth -= this._west.getSize().width;
        }
        if (this._east != null) {
            if (this._east instanceof Container) {
                ((Container)this._east).setWidth(this._east.minimumSize().width);
                ((Container)this._east).setHeight(availableHeight);
                ((Container)this._east).doLayout();
            }
            availableWidth -= this._east.getSize().width;
        }
        if (this._center != null && this._center instanceof Container) {
            ((Container)this._center).setSize(availableWidth, availableHeight);
            ((Container)this._center).doLayout();
        }
    }
}

