/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.BorderLayout;
import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.IllegalComponentStateException;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.LayoutManager2;
import charva.awt.Point;
import charva.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Container
extends Component {
    protected Vector _components = new Vector();
    protected Dimension _size = new Dimension(1, 1);
    protected LayoutManager _layoutMgr = null;
    protected Component _currentFocus = null;
    protected Insets _insets = new Insets(0, 0, 0, 0);
    protected boolean _isValid = false;
    protected Dimension _minimumSize;

    public void doLayout() {
        if (this._isValid) {
            return;
        }
        if (this._layoutMgr != null) {
            this._layoutMgr.doLayout(this);
            if (!(this._layoutMgr instanceof LayoutManager2)) {
                this._isValid = true;
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this._size);
    }

    public int getHeight() {
        return this._size.height;
    }

    public int getWidth() {
        return this._size.width;
    }

    public void setSize(Dimension size_) {
        this._size = new Dimension(size_);
        this.invalidate();
    }

    public void setSize(int width_, int height_) {
        this._size.width = width_;
        this._size.height = height_;
        this.invalidate();
    }

    public void setHeight(int height_) {
        this._size.height = height_;
        this.invalidate();
    }

    public void setWidth(int width_) {
        this._size.width = width_;
        this.invalidate();
    }

    public Dimension minimumSize() {
        if (this._layoutMgr == null) {
            return this._size;
        }
        if (!this._isValid) {
            this._minimumSize = this._layoutMgr.minimumSize(this);
        }
        return this._minimumSize;
    }

    public Component getComponent(int n) {
        return (Component)this._components.elementAt(n);
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public Component getComponentAt(int x, int y) {
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.contains(x, y)) continue;
            if (c instanceof Container) {
                Point origin = c.getLocation();
                return ((Container)c).getComponentAt(x - origin.x, y - origin.y);
            }
            return c;
        }
        return null;
    }

    public Component add(Component component_) {
        this._addComponent(component_);
        if (this._layoutMgr != null && this._layoutMgr instanceof LayoutManager2) {
            if (this._layoutMgr instanceof BorderLayout) {
                ((BorderLayout)this._layoutMgr).addLayoutComponent(component_, "Center");
            } else {
                throw new IllegalArgumentException("LayoutManager2 requires a constraint object");
            }
        }
        this.invalidate();
        return component_;
    }

    public void remove(Component component_) {
        this._components.remove(component_);
        component_.setParent(null);
        if (this._currentFocus == component_) {
            this._currentFocus = null;
            this._currentFocus = this.getCurrentFocus();
        }
        this.invalidate();
    }

    private void _addComponent(Component component_) {
        this._components.addElement(component_);
        component_.setParent(this);
    }

    public void add(Component component_, Object constraint_) {
        this._addComponent(component_);
        if (this._layoutMgr != null && this._layoutMgr instanceof LayoutManager2) {
            ((LayoutManager2)this._layoutMgr).addLayoutComponent(component_, constraint_);
        }
    }

    public void setLayout(LayoutManager mgr_) {
        this._layoutMgr = mgr_;
    }

    public Component[] getComponents() {
        int arraylen = this._components.size();
        Component[] array = new Component[arraylen];
        for (int i = 0; i < arraylen; ++i) {
            array[i] = (Component)this._components.elementAt(i);
        }
        return array;
    }

    public int getComponentCount() {
        return this._components.size();
    }

    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.isVisible()) continue;
            c.draw();
        }
    }

    public void setForeground(Color color_) {
        super.setForeground(color_);
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c.getForeground() != null) continue;
            c.setForeground(color_);
        }
    }

    public void setBackground(Color color_) {
        super.setBackground(color_);
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c.getBackground() != null) continue;
            c.setBackground(color_);
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        if (this._currentFocus != null) {
            this._currentFocus.processKeyEvent(ke_);
        }
    }

    public void requestFocus() {
        this.getCurrentFocus().requestFocus();
    }

    public Component getCurrentFocus() {
        if (this._currentFocus == null) {
            Enumeration e = this._components.elements();
            while (e.hasMoreElements()) {
                Component c = (Component)e.nextElement();
                if (!c.isFocusTraversable()) continue;
                this._currentFocus = c;
                break;
            }
        }
        if (this._currentFocus == null) {
            throw new IllegalComponentStateException("no focus-traversable components inside this Container");
        }
        if (this._currentFocus instanceof Container) {
            return ((Container)this._currentFocus).getCurrentFocus();
        }
        return this._currentFocus;
    }

    public void nextFocus() {
        Component focusCandidate;
        int index = this._components.indexOf(this._currentFocus);
        if (index == -1) {
            throw new IllegalComponentStateException("focus component not found in parent");
        }
        do {
            if (++index < this._components.size()) continue;
            if (this.getParent() != null) {
                this.getParent().nextFocus();
                return;
            }
            index = 0;
        } while (!(focusCandidate = (Component)this._components.elementAt(index)).isFocusTraversable());
        if (focusCandidate instanceof Container) {
            ((Container)focusCandidate).firstFocus();
        }
        focusCandidate.requestFocus();
    }

    public void previousFocus() {
        Component focusCandidate;
        int index = this._components.indexOf(this._currentFocus);
        if (index == -1) {
            throw new IllegalArgumentException("focus component not found in parent");
        }
        do {
            if (--index >= 0) continue;
            if (this.getParent() != null) {
                this.getParent().previousFocus();
                return;
            }
            index = this._components.size() - 1;
        } while (!(focusCandidate = (Component)this._components.elementAt(index)).isFocusTraversable());
        if (focusCandidate instanceof Container) {
            ((Container)focusCandidate).lastFocus();
        }
        focusCandidate.requestFocus();
    }

    public void setFocus(Component focus_) {
        this._currentFocus = focus_;
        if (this.getParent() != null) {
            this.getParent().setFocus(this);
        }
    }

    public boolean isFocusTraversable() {
        if (!super.isFocusTraversable()) {
            return false;
        }
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.isFocusTraversable()) continue;
            return true;
        }
        return false;
    }

    public Insets getInsets() {
        return this._insets;
    }

    public void debug(int level_) {
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            c.debug(level_ + 1);
        }
    }

    private void firstFocus() {
        Enumeration e = this._components.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.isFocusTraversable()) continue;
            if (c instanceof Container) {
                ((Container)c).firstFocus();
            }
            this._currentFocus = c;
            return;
        }
    }

    private void lastFocus() {
        for (int i = this._components.size() - 1; i >= 0; --i) {
            Component c = (Component)this._components.elementAt(i);
            if (!c.isFocusTraversable()) continue;
            if (c instanceof Container) {
                ((Container)c).lastFocus();
            }
            this._currentFocus = c;
            return;
        }
    }

    public void validate() {
        if (this._isValid) {
            return;
        }
        this.doLayout();
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void invalidate() {
        this._isValid = false;
        super.invalidate();
    }
}

