/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.MouseEventInfo;
import charva.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlaybackThread
extends Thread {
    private File _scriptFile;
    private Toolkit _toolkit;
    private int numberOfLoops = 1;
    private long playbackRate = 1L;
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$PlaybackThread == null ? (class$charva$awt$PlaybackThread = PlaybackThread.class$("charva.awt.PlaybackThread")) : class$charva$awt$PlaybackThread));
    static /* synthetic */ Class class$charva$awt$PlaybackThread;

    PlaybackThread(File scriptFile) {
        String rate;
        this._scriptFile = scriptFile;
        this._toolkit = Toolkit.getDefaultToolkit();
        String loops = System.getProperty("charva.script.playbackLoops");
        if (loops != null) {
            try {
                this.numberOfLoops = Integer.parseInt(loops);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Property charva.script.playbackLoops (value=[" + loops + "" + "]) must be an integer!"));
            }
            if (this.numberOfLoops <= 0) {
                LOG.warn((Object)("Property charva.script.playbackLoops (value=[" + loops + "" + "]) must be greater than 0!"));
                this.numberOfLoops = 1;
            }
        }
        if ((rate = System.getProperty("charva.script.playbackRate")) != null) {
            this.playbackRate = Long.parseLong(rate);
            if (this.playbackRate < 1L) {
                LOG.warn((Object)("Property charva.script.playbackRate (value=" + rate + ") must be greater than 1!"));
                this.playbackRate = 1L;
            }
        }
    }

    public void run() {
        try {
            for (int i = 0; i < this.numberOfLoops; ++i) {
                LOG.debug((Object)("Starting script loop " + (i + 1) + " out of " + this.numberOfLoops));
                this.runScriptOnce(this._scriptFile);
                LOG.debug((Object)("Ended script loop " + (i + 1)));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error reading script file: " + e.getMessage()));
        }
    }

    private void runScriptOnce(File scriptfile) throws IOException {
        String line;
        int lineno = 0;
        BufferedReader scriptReader = null;
        try {
            scriptReader = new BufferedReader(new FileReader(scriptfile));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        while ((line = scriptReader.readLine()) != null) {
            String gestureToken;
            ++lineno;
            StringTokenizer st = new StringTokenizer(line);
            String delayToken = st.nextToken();
            long delay = Long.parseLong(delayToken);
            if (delay > 500L) {
                delay /= this.playbackRate;
            }
            if ((gestureToken = st.nextToken()).equals("KEY")) {
                String keycodeToken = st.nextToken();
                int keycode = Integer.parseInt(keycodeToken, 16);
                if (delay != 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ei) {
                        // empty catch block
                    }
                }
                this._toolkit.fireKeystroke(keycode);
                continue;
            }
            if (gestureToken.equals("MOUSE")) {
                String buttonToken = st.nextToken();
                int button = Integer.parseInt(buttonToken);
                String xToken = st.nextToken();
                int x = Integer.parseInt(xToken);
                String yToken = st.nextToken();
                int y = Integer.parseInt(yToken);
                MouseEventInfo mouseEventInfo = new MouseEventInfo(button, x, y);
                if (delay != 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ei) {
                        // empty catch block
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Mouse-click (button " + button + ") at (" + mouseEventInfo.getX() + "," + mouseEventInfo.getY() + ")"));
                }
                this._toolkit.fireMouseEvent(mouseEventInfo);
                continue;
            }
            throw new IOException("Parse error [" + line + "] on line " + lineno + " of script file " + scriptfile.getAbsolutePath());
        }
        scriptReader.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

