/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Dimension;
import charva.awt.Rectangle;

public class Point
implements Cloneable {
    public int x;
    public int y;

    public Point(int x_, int y_) {
        this.x = x_;
        this.y = y_;
    }

    public Point(Point point_) {
        this.x = point_.x;
        this.y = point_.y;
    }

    public Point addOffset(Point p_) {
        return new Point(this.x + p_.x, this.y + p_.y);
    }

    public Point addOffset(Dimension d_) {
        return new Point(this.x + d_.width, this.y + d_.height);
    }

    public Point addOffset(int x_, int y_) {
        return new Point(this.x + x_, this.y + y_);
    }

    public Point subtractOffset(Point p) {
        return new Point(this.x - p.x, this.y - p.y);
    }

    public void translate(int dx_, int dy_) {
        this.x += dx_;
        this.y += dy_;
    }

    public void translate(Point point_) {
        this.x += point_.x;
        this.y += point_.y;
    }

    public boolean isInside(Rectangle rect_) {
        if (this.x < rect_.getLeft()) {
            return false;
        }
        if (this.x > rect_.getRight()) {
            return false;
        }
        if (this.y < rect_.getTop()) {
            return false;
        }
        return this.y <= rect_.getBottom();
    }

    public boolean equals(Point other_) {
        return this.x == other_.x && this.y == other_.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Object clone() {
        return new Point(this);
    }
}

