/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Dimension;
import charva.awt.Point;

public class Rectangle {
    private int _top;
    private int _left;
    private int _bottom;
    private int _right;

    public Rectangle(int top_, int left_, int bottom_, int right_) {
        this._top = top_;
        this._left = left_;
        this._bottom = bottom_;
        this._right = right_;
    }

    public Rectangle(Point topleft_, Point bottomright_) {
        this._top = topleft_.y;
        this._left = topleft_.x;
        this._bottom = bottomright_.y;
        this._right = bottomright_.x;
    }

    public Rectangle(Point topleft_, Dimension size_) {
        this._top = topleft_.y;
        this._left = topleft_.x;
        this._bottom = this._top + size_.height - 1;
        this._right = this._left + size_.width - 1;
    }

    public Rectangle(Rectangle rect_) {
        this._top = rect_.getTop();
        this._left = rect_.getLeft();
        this._bottom = rect_.getBottom();
        this._right = rect_.getRight();
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return x >= this._left && x <= this._right && y >= this._top && y <= this._bottom;
    }

    public int getLeft() {
        return this._left;
    }

    public int getRight() {
        return this._right;
    }

    public int getTop() {
        return this._top;
    }

    public int getBottom() {
        return this._bottom;
    }

    public boolean intersects(Rectangle rect_) {
        if (rect_._left > this._right) {
            return false;
        }
        if (rect_._right < this._left) {
            return false;
        }
        if (rect_._top > this._bottom) {
            return false;
        }
        return rect_._bottom >= this._top;
    }

    public Rectangle intersection(Rectangle rect_) {
        if (this._top > rect_._bottom) {
            return null;
        }
        if (this._bottom < rect_._top) {
            return null;
        }
        if (this._left > rect_._right) {
            return null;
        }
        if (this._right < rect_._left) {
            return null;
        }
        Rectangle ret = new Rectangle(0, 0, 0, 0);
        ret._left = this._left > rect_._left ? this._left : rect_._left;
        ret._right = this._right < rect_._right ? this._right : rect_._right;
        ret._top = this._top > rect_._top ? this._top : rect_._top;
        ret._bottom = this._bottom < rect_._bottom ? this._bottom : rect_._bottom;
        return ret;
    }

    public boolean equals(Rectangle rect_) {
        if (rect_ == null) {
            return false;
        }
        if (this._top != rect_._top) {
            return false;
        }
        if (this._bottom != rect_._bottom) {
            return false;
        }
        if (this._left != rect_._left) {
            return false;
        }
        return this._right == rect_._right;
    }

    public Object clone() {
        return new Rectangle(this._top, this._left, this._bottom, this._right);
    }

    public String toString() {
        return "(" + this._top + "," + this._left + "," + this._bottom + "," + this._right + ")";
    }
}

