/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager;

public class BoxLayout
implements LayoutManager {
    private Container _target;
    private int _axis;
    public static final int X_AXIS = 100;
    public static final int Y_AXIS = 101;

    public BoxLayout(Container target_, int axis_) {
        this._target = target_;
        if (axis_ != 100 && axis_ != 101) {
            throw new IllegalArgumentException("illegal axis");
        }
        this._axis = axis_;
    }

    public Dimension minimumSize(Container container_) {
        Dimension size = new Dimension(0, 0);
        Component[] components = container_.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            Dimension d = c.minimumSize();
            if (this._axis == 100) {
                size.width += d.width;
                if (d.height <= size.height) continue;
                size.height = d.height;
                continue;
            }
            size.height += d.height;
            if (d.width <= size.width) continue;
            size.width = d.width;
        }
        Insets insets = container_.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public void doLayout(Container container_) {
        Dimension containersize = container_.getSize();
        Dimension minsize = this.minimumSize(container_);
        if (containersize.width < minsize.width) {
            containersize.width = minsize.width;
        }
        if (containersize.height < minsize.height) {
            containersize.height = minsize.height;
        }
        container_.setSize(containersize);
        Component[] components = container_.getComponents();
        int hoffset = container_.getInsets().left;
        int voffset = container_.getInsets().top;
        for (int i = 0; i < components.length; ++i) {
            float alignment;
            Component c = components[i];
            if (c instanceof Container) {
                Container cont = (Container)c;
                cont.setSize(cont.minimumSize());
                cont.doLayout();
            }
            Dimension componentsize = c.getSize();
            if (this._axis == 100) {
                alignment = c.getAlignmentY();
                if (alignment == 0.0f) {
                    voffset = container_.getInsets().top;
                } else if (alignment == 0.5f) {
                    voffset = (containersize.height - componentsize.height) / 2;
                } else if (alignment == 1.0f) {
                    voffset = containersize.height - container_.getInsets().bottom - componentsize.height;
                }
                c.setLocation(hoffset, voffset);
                hoffset += componentsize.width;
                continue;
            }
            alignment = c.getAlignmentX();
            if (alignment == 0.0f) {
                hoffset = container_.getInsets().left;
            } else if (alignment == 0.5f) {
                hoffset = (containersize.width - componentsize.width) / 2;
            } else if (alignment == 1.0f) {
                hoffset = containersize.width - container_.getInsets().right - componentsize.width;
            }
            c.setLocation(hoffset, voffset);
            voffset += componentsize.height;
        }
    }
}

