/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class DefaultListSelectionModel
implements ListSelectionModel {
    protected ArrayList _listeners = new ArrayList();
    protected TreeSet _selection = new TreeSet();
    private int _selectionMode = 201;

    public void addListSelectionListener(ListSelectionListener l_) {
        this._listeners.add(l_);
    }

    public void removeListSelectionListener(ListSelectionListener l_) {
        this._listeners.remove(l_);
    }

    public void setSelectionMode(int mode_) {
        this._selectionMode = mode_;
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public boolean isSelectedIndex(int index) {
        return this._selection.contains(new Integer(index));
    }

    public int getMinSelectionIndex() {
        try {
            Integer first = (Integer)this._selection.first();
            return first;
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    public int getMaxSelectionIndex() {
        try {
            Integer last = (Integer)this._selection.last();
            return last;
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    public void clearSelection() {
        if (!this.isSelectionEmpty()) {
            int first = this.getMinSelectionIndex();
            int last = this.getMaxSelectionIndex();
            this.fireValueChanged(first, last);
            this._selection.clear();
        }
    }

    public void addSelectionInterval(int index0, int index1) {
        TreeSet range = this.getRange(index0, index1);
        TreeSet newSelection = (TreeSet)this._selection.clone();
        newSelection.addAll(range);
        this.handleSelectionChange(newSelection);
    }

    public void removeSelectionInterval(int index0, int index1) {
        TreeSet range = this.getRange(index0, index1);
        TreeSet newSelection = (TreeSet)this._selection.clone();
        newSelection.removeAll(range);
        this.handleSelectionChange(newSelection);
    }

    public void setSelectionInterval(int index0, int index1) {
        TreeSet newSelection = this.getRange(index0, index1);
        this.handleSelectionChange(newSelection);
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        if (before) {
            for (int i = index - length; i >= index; ++i) {
                this._selection.add(new Integer(i));
            }
        } else {
            for (int i = index; i <= index + length; ++i) {
                this._selection.add(new Integer(i));
            }
        }
    }

    public void removeIndexInterval(int index0, int index1) {
        for (int i = index0; i <= index1; ++i) {
            this._selection.remove(new Integer(i));
        }
    }

    protected void fireValueChanged(int firstindex_, int lastindex_) {
        ListSelectionEvent event = new ListSelectionEvent(this, firstindex_, lastindex_, false);
        Iterator iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ListSelectionListener l = (ListSelectionListener)iter.next();
            l.valueChanged(event);
        }
    }

    private TreeSet getRange(int index0, int index1) {
        int start = 0;
        int end = 0;
        if (index0 <= index1) {
            start = index0;
            end = index1;
        } else {
            start = index1;
            end = index0;
        }
        TreeSet<Integer> range = new TreeSet<Integer>();
        for (int i = start; i <= end; ++i) {
            range.add(new Integer(i));
        }
        return range;
    }

    private void handleSelectionChange(TreeSet newSelection_) {
        TreeSet copyOld = (TreeSet)this._selection.clone();
        TreeSet differences = (TreeSet)newSelection_.clone();
        differences.removeAll(this._selection);
        copyOld.removeAll(newSelection_);
        differences.addAll(copyOld);
        this._selection = newSelection_;
        if (!differences.isEmpty()) {
            Integer first = (Integer)differences.first();
            Integer last = (Integer)differences.last();
            this.fireValueChanged(first, last);
        }
    }
}

