/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charvax.swing.ButtonGroup;
import charvax.swing.JButton;
import java.util.Enumeration;
import java.util.Vector;

public class JTabbedPane
extends Container {
    private Vector _tabComponents = new Vector();
    private Vector _tabs = new Vector();
    private int _selectedIndex = -1;
    private ButtonGroup _buttongroup = new ButtonGroup();

    public JTabbedPane() {
        this._insets = new Insets(2, 1, 1, 1);
        this._layoutMgr = new BorderLayout();
    }

    public void add(Component component_, Object constraints_) {
        String label = constraints_ instanceof String ? (String)constraints_ : component_.getName();
        int labelno = this._tabComponents.size() + 1;
        String keylabel = "F" + labelno;
        this.addTab(label, null, component_, keylabel);
    }

    public void addTab(String title_, Object icon_, Component component_, String keylabel_) {
        TabButton tb = new TabButton(title_, component_, keylabel_);
        this._tabComponents.add(component_);
        this._components.add(this._tabs.size(), tb);
        tb.setParent(this);
        this._tabs.add(tb);
        this._buttongroup.add(tb);
        if (this._selectedIndex == -1) {
            this.setSelectedIndex(0);
            tb.setSelected(true);
        } else if (this.isDisplayed()) {
            this.repaint();
        }
    }

    public void setSelectedIndex(int index_) {
        if (index_ >= this._tabComponents.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index_ == this._selectedIndex) {
            return;
        }
        if (this._selectedIndex != -1) {
            super.remove((Component)this._tabComponents.elementAt(this._selectedIndex));
        }
        TabButton tb = (TabButton)this._tabs.elementAt(index_);
        tb.setSelected(true);
        Component selected = (Component)this._tabComponents.elementAt(index_);
        super.add(selected);
        super.validate();
        this._selectedIndex = index_;
        this.repaint();
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedComponent(Component component_) {
        int index = this._tabComponents.indexOf(component_);
        this.setSelectedIndex(index);
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (super.isValid()) {
            return this._minimumSize;
        }
        int width = 0;
        int height = 0;
        Enumeration e = this._tabComponents.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            Dimension size = c.minimumSize();
            if (size.width > width) {
                width = size.width;
            }
            if (size.height <= height) continue;
            height = size.height;
        }
        int tabwidth = 0;
        e = this._tabs.elements();
        while (e.hasMoreElements()) {
            tabwidth += ((TabButton)e.nextElement()).getWidth();
        }
        if ((tabwidth += 2) > width) {
            width = tabwidth;
        }
        this._minimumSize = new Dimension(width + this._insets.left + this._insets.right, height + this._insets.top + this._insets.bottom);
        this._isValid = true;
        return this._minimumSize;
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        Point relative = new Point(0, 0);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        Dimension size = this.getSize();
        term.blankBox(origin, size, colorpair);
        term.drawBox(origin.addOffset(0, 1), new Dimension(size.width, size.height - 1), colorpair);
        int hoffset = 1;
        Enumeration e = this._tabs.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            TabButton tb = (TabButton)e.nextElement();
            tb.setLocation(relative.addOffset(hoffset, 0));
            tb.draw();
            hoffset += tb.getWidth();
            ++i;
        }
        if (this._selectedIndex != -1) {
            Component component = (Component)this._tabComponents.elementAt(this._selectedIndex);
            component.draw();
        }
    }

    public void remove(int index) {
        Component selected = (Component)this._tabComponents.elementAt(0);
        this._tabComponents.remove(index);
        super.remove((Component)this._tabs.elementAt(index));
        this._tabs.remove(index);
        if (this.getSelectedIndex() == index) {
            if (index - 1 < 0) {
                if (this.getTabCount() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this._selectedIndex = -1;
                    super.remove(selected);
                    super.validate();
                }
            } else {
                this.setSelectedIndex(index - 1);
            }
        }
        if (this.isDisplayed()) {
            this.repaint();
        }
    }

    public int indexOfTab(String title) {
        for (int i = 0; i < this._tabs.size(); ++i) {
            if (!title.equals(((TabButton)this._tabs.elementAt(i)).getText())) continue;
            return i;
        }
        return -1;
    }

    public String getTitleAt(int index) {
        return ((TabButton)this._tabs.elementAt(index)).getText();
    }

    public void setTitleAt(int index, String title) {
        ((TabButton)this._tabs.elementAt(index)).setText(title);
    }

    public void setEnabledAt(int index, boolean enabled) {
        ((TabButton)this._tabs.elementAt(index)).setEnabled(enabled);
    }

    public boolean isEnabledAt(int index) {
        return ((TabButton)this._tabs.elementAt(index)).isEnabled();
    }

    public int getTabCount() {
        return this._tabs.size();
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.print("JTabbedPane origin=" + this._origin + " size=" + this._size + " _selectedIndex=" + this._selectedIndex + " tabtitles =");
        Enumeration e = this._tabs.elements();
        while (e.hasMoreElements()) {
            String title = ((TabButton)e.nextElement()).getText();
            System.err.print(" " + title + " ");
        }
        System.err.println("");
        super.debug(level_ + 1);
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private String _keylabel;
        private Component _c;

        public TabButton(String label_, Component c_, String keylabel_) {
            super(label_);
            this._keylabel = keylabel_;
            this._c = c_;
            this.addActionListener(this);
        }

        public String toString() {
            return "JTabbedPane.TabButton locaton=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\"";
        }

        public void actionPerformed(ActionEvent ev_) {
            JTabbedPane.this.setSelectedComponent(this._c);
        }

        public String getKeyLabel() {
            return this._keylabel;
        }

        public void setKeyLabel(String keylabel_) {
            this._keylabel = keylabel_;
        }

        public void requestFocus() {
            super.requestFocus();
            Point origin = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            Toolkit.getDefaultToolkit().setCursor(origin.addOffset(2 + insets.left, 0 + insets.top));
        }

        public void draw() {
            int mnemonicPos;
            Point origin = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            origin.translate(insets.left, insets.top);
            Toolkit term = Toolkit.getDefaultToolkit();
            term.setCursor(origin);
            int colorpair = this.getCursesColor();
            term.addChar(Toolkit.ACS_ULCORNER, 0, colorpair);
            term.addChar(32, 0, colorpair);
            term.addString(this.getLabelString(), this.isEnabled() ? Toolkit.A_BOLD : 0, colorpair);
            term.addChar(32, 0, colorpair);
            term.addChar(Toolkit.ACS_URCORNER, 0, colorpair);
            if (this.isEnabled() && this.getMnemonic() > 0 && (mnemonicPos = this.getText().indexOf((char)this.getMnemonic())) != -1) {
                term.setCursor(origin.addOffset(2 + mnemonicPos, 0));
                term.addChar(this.getMnemonic(), Toolkit.A_UNDERLINE | Toolkit.A_REVERSE, colorpair);
            }
            term.setCursor(origin.addOffset(0, 1));
            if (this.isSelected()) {
                term.addChar(Toolkit.ACS_LRCORNER, 0, colorpair);
                for (int j = 0; j < this.getText().length() + 2; ++j) {
                    term.addChar(32, 0, colorpair);
                }
                term.addChar(Toolkit.ACS_LLCORNER, 0, colorpair);
            } else {
                term.addChar(Toolkit.ACS_BTEE, 0, colorpair);
                term.setCursor(origin.addOffset(this.getText().length() + 3, 1));
                term.addChar(Toolkit.ACS_BTEE, 0, colorpair);
                if (this.isEnabled()) {
                    term.setCursor(origin.addOffset(1, 1));
                    term.addString(this._keylabel, Toolkit.A_BOLD, colorpair);
                }
            }
        }

        public int getWidth() {
            Insets insets = super.getInsets();
            return super.getText().length() + insets.left + insets.right + 4;
        }
    }
}

