/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.border;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Insets;
import charva.awt.Toolkit;
import charvax.swing.border.Border;

public class LineBorder
implements Border {
    private Color _lineColor = null;
    private static Border _blackLineBorder = new LineBorder(Color.black);

    public LineBorder(Color color_) {
        this._lineColor = color_;
    }

    public Insets getBorderInsets(Component component_) {
        return new Insets(1, 1, 1, 1);
    }

    public static Border createBlackLineBorder() {
        return _blackLineBorder;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public void paintBorder(Component component_, int graphics_, int x_, int y_, int width_, int height_) {
        Color background = component_.getBackground();
        if (this._lineColor == null) {
            this._lineColor = component_.getForeground();
        }
        int curses_colorpair = Color.getCursesColor(this._lineColor, background);
        Toolkit term = Toolkit.getDefaultToolkit();
        term.drawBoxNative(x_, y_, x_ + width_ - 1, y_ + height_ - 1, curses_colorpair);
    }
}

