<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Categories module
*/

/*
 * The CHeMS module get function
*/
function categories_main()
{
   global $module;

   // No multiple instances are allowed for this module
   if( $module->instid )
      return CHEMS_MODULE_FAILURE;

   // Set the current page/post ID
   $id = ($module->modname === "posts_mgr" ?
            (isset($_GET['post']) && $_GET['post'] ? $_GET['post'] : 1) :
	    (isset($_GET['page']) && $_GET['page'] ? $_GET['page'] : 1));

   /*
    * Pre-operations depending on the module name
   */

   // Get the file (posts/pages) constant suffix and include the file
   require(@constant("MOD_".($module->modname === "posts_mgr" ? "POST" : "PAGE")."SMGR_DB"));

   // Get the objects list
   $objs = ($module->modname === "posts_mgr" ? $POST : $PAGE);
   $cats = getCats($objs, $id); // Get the categories list

   // Open the divs
   $text = "
      <div id='mod_categories_main' class='chems_module'>
         <div class='chems_module_title'>".MOD_CATEGORIES_BLOCKTITLE."</div>
         <div class='chems_module_body'>
   ";

   // Format operators
   $FO = array("%[name]", "%[elements]");

   // Get the object type
   $objtype = ($module->modname === "posts_mgr" ? "post" : "page");

   // Show all categories
   if( $cats ) {

      // Traverse categories.
      // Note. $occur represents the number of occurences for the current category
      foreach($cats as $cat => $occur) {

	 // Format operators expansions
	 $FOEXP = array(
	    "<a href='?modname=categories&amp;name=$cat&amp;objtype=$objtype'>$cat</a>",
	    $occur
	 );

	 // Get the expanded link
	 $link = str_replace($FO, $FOEXP, MOD_CATEGORIES_LINK);

         // Get the zoom value
	 $mod_cat_zoom = MOD_CATEGORIES_ZOOM;
	 $zoom = ($occur >= $mod_cat_zoom ? $mod_cat_zoom : $occur);

	 // If enabled, zoom the categories
	 if( $mod_cat_zoom )
	    $text .= "<span style='font-size: ".(8 + $zoom)."pt'>$link</span>";
         else
	    $text .= $link; // Just show the link

	 $text .= " "; // Space separator
      }
   }
   else {
      // Don't show the module
      if( MOD_CATEGORIES_UNSHOW )
         return;

      // Show a user message
      $text .= MOD_CATEGORIES_NOCATS;
   }

   // Close the divs
   $text .= "
	 </div>
      </div>
   ";

   // Static format operators
   $FO = array("%[type]", "%[categories]");
   $FOEXP = array($objtype, sizeof($cats));

   return str_replace($FO, $FOEXP, $text);
} /* eof categories_main() */

/*
 * The categories page
*/
function categories_page()
{
   //require(FILE_MODCONF);

   $cat = $_GET['name'];	// Category name
   $type = $_GET['objtype'];	// Object type

   // Get the file (posts/pages) constant suffix and include the file
   require(@constant("MOD_".strtoupper($type)."SMGR_DB") );

   // Get the objects list
   $objs = ($type === "post" ? $POST : $PAGE);

   // Generate the "expanded" intro
   $cat_text = "
      <div id='mod_categories_page' class='chems_module'>
         <div class='chems_module_title'>".MOD_CATEGORIES_PAGETITLE."</div>
         <div class='chems_module_body'>
	    ".MOD_CATEGORIES_INTRO."
	    <ul>
   ";

   // The format operators for the MOD_CATEGORIES_OBJECT option
   $FO = array("%[object]", "%[cats]");

   // Show the objects
   for($o = 1, $occurs = 0, $cat_list = ''; isset($objs[$o]); $o++, $cat_list='') {
      
      // Get the categories list
      $cats = getCats($objs, $o);

      // Check all the categories
      foreach($cats as $key => $val) {

         // If the current object is in the current category ($key), include it
         if( $cat === $key ) {
	    
	    $cat_text .= "<li>";

	    // Links the related categories
	    foreach($cats as $key => $val)
	       $cat_list .= "<a href='".WEBROOT."?modname=categories&amp;name=$key&amp;objtype=$type'>$key</a> "; 
	    ++$occurs;

            // The format operators expansions for the MOD_CATEGORIES_OBJECT option
	    $FOEXP = array($objs[$o]['title'], $cat_list);

            // Add the current object
	    $cat_text .= str_replace($FO, $FOEXP, MOD_CATEGORIES_OBJECT) . "</li>";

	    break;
         }

      }
   }

   // Format operators definitions
   $FO = array(
      "%[name]",
      "%[elements]",
      "%[type]"
   );

   // Format operators expansions
   $FOEXP = array($cat, $occurs, $type);

   $cat_text .= "
            </ul>
         </div>
      </div>
   ";

   return str_replace($FO, $FOEXP, $cat_text);
} /* categories_page() */

/*
 * Get a list of all categories
*/
function getCats(&$objs, $id)
{
   global $module;
   $cats = array();

   // An ID has been specified, show only a post categories
   if( $id )
      $inf = $sup = $id;

   // No ID specified, merge all categories of the current posts
   else
      xtrset(sizeof($objs), MOD_POSTSMGR_POSTSPERPAGE, $inf, $sup);

   /*
    * Store all categories (only for posts listing).
   */
   for($i = $inf; $i <= $sup; $i++) {
      if( isset($objs[$i]) && isset($objs[$i]['categories']) ) {

         // Separate all the elements
         $list = split(FSL, str_replace(" ", "", $objs[$i]['categories']));

         // Store all the categories
         for($cat = 0; isset($list[$cat]); $cat++) {
            if( ! isset($cats[$list[$cat]]) )
	       $cats[$list[$cat]] = totCats($objs, $list[$cat]);
         }
      }
   }

   return $cats;
} /* getCats() */

/*
 * Get the totals number of objects which
 * contains the specified category
*/
function totCats(&$objs, $cat)
{
   // Cycle all objects
   for($i = 1, $tot = 0; isset($objs[$i]) && isset($objs[$i]['categories']); $i++) {
      
      // Get the categories
      $cats = split(FSL, str_replace(" ", "", $objs[$i]['categories']));

      // Count the occurrences
      foreach($cats as $curcat) {
         if( $cat === $curcat )
	    ++$tot;
      }
   }

   return $tot;
} /* eof totCats() */

?>
