<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Posts manager module routines
*/

/*
 * Return the post with the given ID
*/
function getPost($id, $len, $post_susp)
{
   require(MOD_POSTSMGR_DB);

   // Get the index of the 1st non printable character of the post
   //$length = ($len ? getNonPrintIdx($POST[$id]['body'], $len) : 0);

   if( ! isset($POST[$id]) )
      return;

   $length = getNonPrintIdx($POST[$id]['body'], $len);

   // Get the (truncated) body
   $pbody = ($length?strip_tags(substr($POST[$id]['body'],0,$length)):$POST[$id]['body']);

   /* If the string has been truncated then show two trailing dots */
   if( strlen($POST[$id]['body']) != strlen($pbody) )
   	$pbody .= $post_susp;

   $p = "
      <div class='post_title'>
         ".$POST[$id]['title']."
         <div class='post_date'>".$POST[$id]['date']."</div>
      </div>
      <div class='post_body'>$pbody</div>
   ";

   return $p;
} /* eof getPost() */

/*
 * Traverse the given string looking for the 1st non printable
 * character starting from the start index $sidx. The function
 * return the index of the character found, if any, else zero.
*/
function getNonPrintIdx($string, $sidx)
{
   $slen = strlen($string);
   $ret = $slen;

   if( ! $sidx )
   	return 0;

   if( $sidx < 0 ) { 
   	for($i = $slen + $sidx; $i >= 0 && ctype_graph($string[$i]); $i--);
	$ret = -($slen - $i);
   }
   else {
   	for($i = $sidx; $i < $slen && ctype_graph($string[$i]); $i++);
	$ret = $i == $slen ? 0 : $i;
   }

   return $ret;
} /* eof getNonPrintIdx() */

?>
