<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Blogroll module
*/

/*
 * The CHeMS module get function
*/
function blogroll_main() {
   global $module;


   // Generate the instance postfix
   $instpfx = (isset($module->istance) && $module->instance ? $instpfx = "_".strtoupper($module->instance) : '');

   global ${"MOD_BLOGROLL_ROLL".$instpfx};

   // Get the blogs
   $roll = ${"MOD_BLOGROLL_ROLL".$instpfx};
   $blogs = sizeof($roll);

   // Empty rolls (no blogs) generates an error
   if( ! $blogs )
      return CHEMS_MODULE_FAILURE;
   
   // Open the module divs
   $brtext = "
      <div id='mod_blogroll".$instpfx."_main' class='chems_module'>
         <div class='chems_module_title'>".@constant("MOD_BLOGROLL_TITLE$instpfx")."</div>
         <div class='chems_module_body'>
   ";

   /* Show all blogs */
   for($b = 0; isset($roll[$b]) && ($blog = $roll[$b]); $b++) {

      /*
       * 0 blog name
       * 1 blog URL
      */

      // Ignore "wrong" blog in the roll
      if($blog[0] && $blog[1]) {
         $brtext .= "<a href='".$blog[1]."'>".$blog[0]."</a><br />";
      }

   }

   // Close the divs
   $brtext .= "
	 </div>
      </div>
   ";

   return str_replace("%[blogs]", $b, $brtext);
} /* eof blogroll_main() */ 

?>
