<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Change theme module
*/

/*
 * The CHeMS module get function
*/
function chtheme_main()
{
	// No multiple instances allowed
	if( $GLOBALS["module"]->instance )
		return CHEMS_MODULE_FAILURE;
	
	// Load the theme, if selected
	if( isset($_POST['theme']) )
		themeLoad($_POST['theme']);
	
	// Get the full URI
	for($i = 0, $act = '', $a = array_keys($_GET); isset($a[$i]); $i++) {
		$act .= $a[$i] . '='. $_GET[$a[$i]];
		if( isset($a[$i+1]) )
			$act .= "&amp;";
	}

	// Open the divs
	$text = "
		<div id='mod_chtheme_main' class='chems_module'>
			<div class='chems_module_title'>".MOD_CHTHEME_TITLE."</div>
			<div class='chems_module_body'>
				<form id='themeform' action='".($act ? "?$act" : '')."' method='post'>
					<div id='mod_chtheme_form'> 
						<select name='theme' onchange='submit();'>
	";

	for($i = 0, $tot = GetThemesList($gtl); $i < $tot; $i++)
		$text .= "<option".($gtl[$i] === $GLOBALS["THEME"]["name"] ? " selected='selected'" : '').">".$gtl[$i]."</option>";

        if( ! $tot )
		$text .= MOD_CHTHEME_NOTHEMES;

	// Close the divs
	$text .= "
						</select>
					</div>
				</form>
			</div>
		</div>
	";

   return $text;
} /* eof chtheme_main() */

/*
 * Get the complete list of availables themes.
 * Essentialy the output of ``ls -A themes/''.
*/
function GetThemesList(&$list)
{
	$i = 0;
	$list = NULL;

	foreach(scandir(PATH_THEMES) as $f) {
		if( is_dir(PATH_THEMES.'/'.$f) && $f !== '.' && $f !== ".." && is_file(PATH_THEMES."/$f/$f.css") )
			$list[$i++] = $f;
	}

	return $i;
} /* eof GetThemesList() */

?>
