<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Common routines
*/

/*
 * Organize the given values informations into the given object
 * skipping all not needed fields. Since the function is called
 * directly from an user file (not the core) it have to use the
 * global objects in order to get the needed informations.
*/
function insert(&$object, $values)
{
   // Get the object ID
   $id = $values['id'];

   // Generate the object informations
   foreach($values as $key => $val) {
      if( $key !== "id" )
         $object[$id][$key] = $val;
   }

} /* eof insert() */

/*
 * Set the inf and sup extremes for the elements list
 * computed with the number of totals elements and the
 * number of elements for each listing page.
*/
function xtrset($elements, $elements_per_page, &$inf, &$sup, $sort="desc")
{

   // No pages to show: don't load any page (show an error)
   if( ! $elements_per_page ) {
      $inf = $sup = 0;
      return;
   }

   // If negative then show all pages
   if( $elements_per_page < 0 )
      $elements_per_page = $elements;

   // Calculate the number of navigation pages
   $pages_total = (int)($elements / $elements_per_page +
                       ($elements % $elements_per_page ? 1 : 0));

   // Get the current page
   $page_current = (isset($_GET['list']) ? $_GET['list'] : 1);

   /*
    * If the page is not betwen the extremes of the valid range
    * then the extremes (sup/inf) are set to zero.
   */

   // Check the extremes
   if( $page_current < 1 || $page_current > $elements )
      $sup = $inf = 0;
   else {

      /*
       * Inf/Sup extremes
      */
      if( $sort === "asc" ) {
         $sup = $elements_per_page * $page_current;
	 $inf = $sup - $elements_per_page + 1;
	 while( $sup > $elements ) --$sup;
      }
      else { // descending (default)
         $sup = $elements - $elements_per_page * ($page_current - 1);
         $inf = ($sup > $elements_per_page ? $sup - $elements_per_page + 1 : 1);
      }
  }

} /* eof xtrset() */

?>
