<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Pages links module
 *
 * There is only a format operator provided which returns the
 * number of pages in "pages.inc": %[pages_total] .
*/

/*
 * The CHeMS module get function
*/
function pages_mgr_main()
{

   // Check the pages DB file
   if( ! file_exists(MOD_PAGESMGR_DB) )
      return CHEMS_MODULE_FAILURE;

   // Include the files (insert the posts)
   require(MOD_PAGESMGR_DB);

   $text = "\n
      <div id='mod_pages_mgr' class='chems_module'>
         <div class='chems_module_title'>".MOD_PAGESMGR_PAGE_TITLE."</div>
	 <div class='chems_module_body'>
   ";

   /*
    * Generate the links
   */

   // Ascending order
   if( MOD_PAGESMGR_PAGE_SORT === "asc" ) {

      $epage = ( ! MOD_PAGESMGR_PAGE_MAX ? $pages : (($pages > MOD_PAGESMGR_PAGE_MAX) ?
		   MOD_PAGESMGR_PAGE_MAX : $pages ));

      for($p = 1; $p <= $epage; $p++)
         if( isset($PAGE[$p]) )
            //$text .= MOD_PAGESMGR_PRELINK."<a href='?modname=pages_mgr&amp;page=$p&amp;BBB'>".$PAGE[$p]['title']."</a>".MOD_PAGESMGR_POSTLINK."\n";
            $text .= MOD_PAGESMGR_PRELINK.$PAGE[$p]['title'].MOD_PAGESMGR_POSTLINK."\n";
   }


   // Descending order
   else {

      $epage = ( ! MOD_PAGESMGR_PAGE_MAX ? 0 :
                   ($pages && $pages > MOD_PAGESMGR_PAGE_MAX) ?
		      ($pages - MOD_PAGESMGR_PAGE_MAX) : 0);

      for($p = $pages; $p > $epage; $p--)
         if( isset($PAGE[$p]) )
            //$text .= MOD_PAGESMGR_PRELINK."<a href='?modname=pages_mgr&amp;page=$p'>".$PAGE[$p]['title']."</a>".MOD_PAGESMGR_POSTLINK."\n";
            $text .= MOD_PAGESMGR_PRELINK.$PAGE[$p]['title'].MOD_PAGESMGR_POSTLINK."\n";
   }

   $text .= "</div></div>\n";

   return str_replace("%[pages_total]", $pages, $text);
}

/*
 * Show the specified page. If no page has been specified then
 * the first (ID 1) is used (this allow to use the module as
 * value for the BASEMOD option.
*/
function pages_mgr_page()
{
   $id = isset($_GET['page']) ? $_GET['page'] : 1;

   if( ! ($page = getPage($id)) )
      return MOD_PAGESMGR_MSGNOPAGE;

   return "
      <div id='mod_pages_mgr_page' class='chems_module'>
         <div id='page_$id' class='page'>$page</div>
      </div>
   ";
} /* eof pages_mgr_page() */

/*
 * Return the page with the given ID
*/
function getPage($id)
{
   require(MOD_PAGESMGR_DB);

   if( ! (isset($PAGE[$id]) && $PAGE[$id]) )
      return;

   $p = "
      <div class='page_title'>
         ".$PAGE[$id]['title']."
      </div>
      <div class='page_body'>".$PAGE[$id]['body']."</div>
   ";

   return $p;
} /* eof getPage() */

?>
