<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

// Routines and configuration
require_once("functions.php");
require_once(FILE_CONFIG);

// Debug informations (couldn't pass the W3C validation)
//error_reporting (E_ALL);

themeLoad(CHEMS_THEME); // Load the theme

// Store the module name
if( ! ($module->modname = isset($_GET['modname']) ? $_GET['modname'] : "") )
   $module->modname = BASEMOD;

/*
 * Generate the menubar(s), if any.
*/
if( $MODULES[0] ) {
   $brs = "";

   // Create the $brs variable
   for($sp = 0; $sp < MODULES_SPACES; $sp++, $brs .= "<br />")
      ;

   // Generate the modules
   for($m = 0; ($mod = isset($MODULES[$m]) ? $MODULES[$m] : ''); $m++) {

      // Provide an instance ID for the modules blocks
      $instidx = "mod_".$mod["name"]."_instance";
      $module->instid = (!isset($modinst[$instidx]) ? 0 : ++$modinst[$instidx]);

      // Store the module informations
      foreach($mod as $key => $val)
         $module->{$key} = $val;

      /*
       * Only the modules currently loaded which are members
       * of the current module page and has not been toggled
       * have to be included. All the others are just ignored.
      */
      if( (( (isset($mod["mods"]) && istoggled($mod["mods"], $module->modname))
            || (isset($mod["mods"]) && $mod["mods"] === "all"))
	    ^ (isset($mod["toggle"]) ?
	    	istoggled($mod["toggle"], $module->modname) : false) )
	    && (istoggled(MENUBAR, $mod["side"]) || MENUBAR === "all" )
      ) {
         
         /*
          * Include the current module into the list. The $brs list is appended
          * only if it's not the last module into the current menu. If the side
          * is "top" then a <br /> is put before the module else if the side is
          * "bottom" the <br /> is put after it. Also, the $brs variable always
	  * goes at the bottom of both left and right side menu blocks. Modules
	  * which are considered "null" (which returns empty string or just the
	  * NULL pointer) are totally ignored.
         */

	 if( ($gmf = getModFunc($mod["name"], "_main")) ) {

	    // Avoid a PHP5 notice about the ".=" operator when the variable is not set.
	    if ( ! isset(${"menu_".$mod["side"]}))
	       ${"menu_".$mod["side"]} = '';

            ${"menu_".$mod["side"]} .=
	       ( (($mod["side"] === "left" || $mod["side"] === "right") &&
	       ${"menu_".$mod["side"]}) ? $brs : ($mod["side"] === "bottom" ? "<br />" : "")) .
	          $gmf . ($mod["side"] === "top" ? "<br />" : "");
	 }
      }

      // Clear the module informations
      foreach($mod as $key => $val)
         $module->{$key} = "";

   }
}

/*
 * Ok, now i can print the "real" page by output all the XHTML code
 * and the dinamically generated content. I'll describe shortly the
 * following code. Open the main tags <html>, <head>, <body>, etc.,
 * so i can put the menus, layout divs and their relative contents.
 * Then i check if the MODULES_SECURE option is enabled and if true
 * check if the current module is effectively loaded. At this point
 * it's possible to finally add the top and bottom menu, the module
 * page and the closing tags for the divs, all encoded in UTF-8 (if
 * the USE_UTF8 option is enabled). I know, the code is a bit weird
 * (to look at) but it's as compact as i like! Please, feel free to
 * change it in order to fit your needs.
*/

// The page
$_page = "<div class='incol'>" .
	( ((istoggled(MODULES_SECURE, $module->modname) || MODULES_SECURE === "all") && ! modisload($MODULES, $module->modname)) ?
	MODULES_MSG_UNSECMOD : (isset($menu_top) ? $menu_top : '') . getModFunc($module->modname, "_page") . (isset($menu_bottom) ?
	$menu_bottom : '') ) . "</div>
";

/*
 * Define globals format operators
*/

// Operators
$GFO_OPS= array(
	"%[chems_version]",

	// Theme
	"%[theme_name]",
	"%[theme_version]",
	"%[theme_lang]",
	"%[theme_favicon]",
	"%[theme_css]",
);

// Expansions
$GFO_EXP = array(
	"0x04",

	// Theme
	$THEME["name"],
	$THEME["version"],
	$THEME["lang"],
	$THEME["favicon"],
	$THEME["css"],
);

/*
 * This allow CHeMS to bee XHTML-1.0 Strict compliant (viewable with IE < 8.0)
 *
 * Uncomment this line if you want to allow IE users too see your CHeMS.
*/
//$doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';

// XHTML-1.1 DTD
if( ! isset($doctype) )
	$doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">';

print str_replace($GFO_OPS, $GFO_EXP, "<?xml version=\"1.0\"?>\n$doctype

<html xmlns=\"http://www.w3.org/1999/xhtml\" dir=\"ltr\" xml:lang=\"%[theme_lang]\">

   <head>
      <title>".CHEMS_APP_TITLE."</title>

      <!-- StyleSheet and Favicon -->
      <link rel=\"stylesheet\" type=\"text/css\" href=\"%[theme_css]\" />
      <link rel=\"icon\" href=\"%[theme_favicon]\" type=\"image/x-icon\" />
      <link rel=\"shortcut icon\" href=\"%[theme_favicon]\"
            type=\"image/x-icon\" />
      <style type='text/css'>@import url('%[theme_css]');</style>

      ".CHEMS_SECTION_HEAD."

      <meta http-equiv='Content-type' content='application/xhtml+xml; charset=UTF-8' />
   </head>

   <body".(TAG_BODY_CODE !== '' ? " ".TAG_BODY_CODE : '').">
      <div id='header'>
         <div class='incol'>".CHEMS_HEADER."</div>
      </div> <!-- header -->

      <div id='layout'>
         <div id='main'>
	    " . ( ! isset($menu_left) ? '' :
	            "<div id='menu_left'><div class='incol'>$menu_left</div></div> <!-- menu_left -->" ) . "
	    " . ( ! isset($menu_right) ? '' :
	            "<div id='menu_right'><div class='incol'>$menu_right</div></div> <!-- menu_right -->" ) . "
            <div id='main_page_body'>" . ( ! USE_UTF8 ? $_page : utf8_encode($_page) ) . "</div> <!-- main_page_body -->
            <div class='cleaner'>&nbsp;</div>
         </div> <!-- main -->
      </div> <!-- layout -->

      <div id='footer'><div class='incol'><p>".CHEMS_FOOTER."</p></div></div>
   </body>

</html>
");

?>
