/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import java.io.Serializable;
import java.util.Iterator;

public class PersistentStructMap
extends APersistentMap {
    final Def def;
    final Object[] vals;
    final IPersistentMap ext;

    public static Def createSlotMap(ISeq keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Must supply keys");
        }
        PersistentHashMap ret = PersistentHashMap.EMPTY;
        int i = 0;
        ISeq s = keys;
        while (s != null) {
            ret = (PersistentHashMap)ret.assoc(s.first(), i);
            s = s.next();
            ++i;
        }
        return new Def(keys, ret);
    }

    public static PersistentStructMap create(Def def, ISeq keyvals) {
        Object[] vals = new Object[def.keyslots.count()];
        IPersistentMap ext = PersistentHashMap.EMPTY;
        while (keyvals != null) {
            if (keyvals.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", keyvals.first()));
            }
            Object k = keyvals.first();
            Object v = RT.second(keyvals);
            IMapEntry e = def.keyslots.entryAt(k);
            if (e != null) {
                vals[((Integer)e.getValue()).intValue()] = v;
            } else {
                ext = ext.assoc(k, v);
            }
            keyvals = keyvals.next().next();
        }
        return new PersistentStructMap(null, def, vals, ext);
    }

    public static PersistentStructMap construct(Def def, ISeq valseq) {
        Object[] vals = new Object[def.keyslots.count()];
        PersistentHashMap ext = PersistentHashMap.EMPTY;
        for (int i = 0; i < vals.length && valseq != null; valseq = valseq.next(), ++i) {
            vals[i] = valseq.first();
        }
        if (valseq != null) {
            throw new IllegalArgumentException("Too many arguments to struct constructor");
        }
        return new PersistentStructMap(null, def, vals, ext);
    }

    public static IFn getAccessor(final Def def, Object key) {
        IMapEntry e = def.keyslots.entryAt(key);
        if (e != null) {
            final int i = (Integer)e.getValue();
            return new AFn(){

                public Object invoke(Object arg1) throws Exception {
                    PersistentStructMap m = (PersistentStructMap)arg1;
                    if (m.def != def) {
                        throw new Exception("Accessor/struct mismatch");
                    }
                    return m.vals[i];
                }
            };
        }
        throw new IllegalArgumentException("Not a key of struct");
    }

    protected PersistentStructMap(IPersistentMap meta, Def def, Object[] vals, IPersistentMap ext) {
        super(meta);
        this.ext = ext;
        this.def = def;
        this.vals = vals;
    }

    protected PersistentStructMap makeNew(IPersistentMap meta, Def def, Object[] vals, IPersistentMap ext) {
        return new PersistentStructMap(meta, def, vals, ext);
    }

    public Obj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return this.makeNew(meta, this.def, this.vals, this.ext);
    }

    public boolean containsKey(Object key) {
        return this.def.keyslots.containsKey(key) || this.ext.containsKey(key);
    }

    public IMapEntry entryAt(Object key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            return new MapEntry(e.getKey(), this.vals[(Integer)e.getValue()]);
        }
        return this.ext.entryAt(key);
    }

    public IPersistentMap assoc(Object key, Object val) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            int i = (Integer)e.getValue();
            Object[] newVals = (Object[])this.vals.clone();
            newVals[i] = val;
            return this.makeNew(this._meta, this.def, newVals, this.ext);
        }
        return this.makeNew(this._meta, this.def, this.vals, this.ext.assoc(key, val));
    }

    public Object valAt(Object key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            return this.vals[(Integer)e.getValue()];
        }
        return this.ext.valAt(key);
    }

    public Object valAt(Object key, Object notFound) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            return this.vals[(Integer)e.getValue()];
        }
        return this.ext.valAt(key, notFound);
    }

    public IPersistentMap assocEx(Object key, Object val) throws Exception {
        if (this.containsKey(key)) {
            throw new Exception("Key already present");
        }
        return this.assoc(key, val);
    }

    public IPersistentMap without(Object key) throws Exception {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            throw new Exception("Can't remove struct key");
        }
        IPersistentMap newExt = this.ext.without(key);
        if (newExt == this.ext) {
            return this;
        }
        return this.makeNew(this._meta, this.def, this.vals, newExt);
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    public int count() {
        return this.vals.length + RT.count(this.ext);
    }

    public ISeq seq() {
        return new Seq(null, this.def.keys, this.vals, 0, this.ext);
    }

    public IPersistentCollection empty() {
        return PersistentStructMap.construct(this.def, null);
    }

    static class Seq
    extends ASeq {
        final int i;
        final ISeq keys;
        final Object[] vals;
        final IPersistentMap ext;

        public Seq(IPersistentMap meta, ISeq keys, Object[] vals, int i, IPersistentMap ext) {
            super(meta);
            this.i = i;
            this.keys = keys;
            this.vals = vals;
            this.ext = ext;
        }

        public Obj withMeta(IPersistentMap meta) {
            if (meta != this._meta) {
                return new Seq(meta, this.keys, this.vals, this.i, this.ext);
            }
            return this;
        }

        public Object first() {
            return new MapEntry(this.keys.first(), this.vals[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.vals.length) {
                return new Seq(this._meta, this.keys.next(), this.vals, this.i + 1, this.ext);
            }
            return this.ext.seq();
        }
    }

    public static class Def
    implements Serializable {
        final ISeq keys;
        final IPersistentMap keyslots;

        Def(ISeq keys, IPersistentMap keyslots) {
            this.keys = keys;
            this.keyslots = keyslots;
        }
    }
}

