/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class APersistentMap
extends AFn
implements IPersistentMap,
Map,
Iterable,
Serializable,
MapEquivalence,
IHashEq {
    int _hash = -1;

    public String toString() {
        return RT.printString(this);
    }

    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.assoc(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        return APersistentMap.mapEquals(this, obj);
    }

    public static boolean mapEquals(IPersistentMap m1, Object obj) {
        if (m1 == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != m1.count()) {
            return false;
        }
        for (ISeq s = m1.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equals(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean equiv(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        if (obj instanceof IPersistentMap && !(obj instanceof MapEquivalence)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equiv(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hash == -1) {
            this._hash = APersistentMap.mapHash(this);
        }
        return this._hash;
    }

    public static int mapHash(IPersistentMap m) {
        int hash = 0;
        for (ISeq s = m.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            hash += (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
        }
        return hash;
    }

    public int hasheq() {
        int hash = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            hash += Util.hasheq(e.getKey()) ^ Util.hasheq(e.getValue());
        }
        return hash;
    }

    public Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    public Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return APersistentMap.this.iterator();
            }

            public int size() {
                return APersistentMap.this.count();
            }

            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            public boolean contains(Object o) {
                Map.Entry e;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e.getValue());
            }
        };
    }

    public Object get(Object key) {
        return this.valAt(key);
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getKey();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return APersistentMap.this.count();
            }

            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.count();
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getValue();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq);
        }

        private ValSeq(ISeq seq) {
            this.seq = seq;
        }

        private ValSeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        public ValSeq withMeta(IPersistentMap meta) {
            return new ValSeq(meta, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq);
        }

        private KeySeq(ISeq seq) {
            this.seq = seq;
        }

        private KeySeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        public KeySeq withMeta(IPersistentMap meta) {
            return new KeySeq(meta, this.seq);
        }
    }
}

