/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.Stream;
import clojure.lang.Streamable;

public class Range
extends ASeq
implements IReduce,
Streamable,
Counted {
    final int end;
    final int n;

    public Range(int start, int end) {
        this.end = end;
        this.n = start;
    }

    public Range(IPersistentMap meta, int start, int end) {
        super(meta);
        this.end = end;
        this.n = start;
    }

    public Obj withMeta(IPersistentMap meta) {
        if (meta == this.meta()) {
            return this;
        }
        return new Range(this.meta(), this.end, this.n);
    }

    public Object first() {
        return this.n;
    }

    public ISeq next() {
        if (this.n < this.end - 1) {
            return new Range(this._meta, this.n + 1, this.end);
        }
        return null;
    }

    public Object reduce(IFn f) throws Exception {
        Object ret = this.n;
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) throws Exception {
        Object ret = f.invoke(start, this.n);
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public int count() {
        return this.end - this.n;
    }

    public Stream stream() throws Exception {
        return new Stream(new Src(this.n, this.end));
    }

    static class Src
    extends AFn {
        int n;
        final int end;

        public Src(int n, int end) {
            this.n = n;
            this.end = end;
        }

        public Object invoke() throws Exception {
            if (this.n < this.end) {
                return this.n++;
            }
            return RT.EOS;
        }
    }
}

