/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Map;

public abstract class APersistentMap
extends AFn
implements IPersistentMap,
Collection {
    int _hash = -1;

    protected APersistentMap(IPersistentMap meta) {
        super(meta);
    }

    protected APersistentMap() {
    }

    public String toString() {
        return "<map: - " + this.count() + " items>";
    }

    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.assoc(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.rest()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPersistentMap)) {
            return false;
        }
        IPersistentMap m = (IPersistentMap)obj;
        if (m.count() != this.count() || m.hashCode() != this.hashCode()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.rest()) {
            Map.Entry e = (Map.Entry)s.first();
            IMapEntry me = m.entryAt(e.getKey());
            if (me != null && Util.equal(e.getValue(), me.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = this.count();
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                Map.Entry e = (Map.Entry)s.first();
                hash ^= Util.hashCombine(Util.hash(e.getKey()), Util.hash(e.getValue()));
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public Object invoke(Object arg1) throws Exception {
        return this.valAt(arg1);
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length >= this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean contains(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            IMapEntry v = this.entryAt(e.getKey());
            return v != null && Util.equal(v.getValue(), e.getValue());
        }
        return false;
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new ValSeq(seq);
        }

        private ValSeq(ISeq seq) {
            this.seq = seq;
        }

        private ValSeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        public ISeq rest() {
            return ValSeq.create(this.seq.rest());
        }

        public ValSeq withMeta(IPersistentMap meta) {
            return new ValSeq(meta, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq) {
            if (seq == null) {
                return null;
            }
            return new KeySeq(seq);
        }

        private KeySeq(ISeq seq) {
            this.seq = seq;
        }

        private KeySeq(IPersistentMap meta, ISeq seq) {
            super(meta);
            this.seq = seq;
        }

        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        public ISeq rest() {
            return KeySeq.create(this.seq.rest());
        }

        public KeySeq withMeta(IPersistentMap meta) {
            return new KeySeq(meta, this.seq);
        }
    }
}

