/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;

public abstract class APersistentSet
extends AFn
implements IPersistentSet,
Collection {
    int _hash = -1;
    final IPersistentMap impl;

    protected APersistentSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta);
        this.impl = impl;
    }

    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    public int count() {
        return this.impl.count();
    }

    public ISeq seq() {
        return RT.keys(this.impl);
    }

    public Object invoke(Object arg1) throws Exception {
        return this.contains(arg1) ? arg1 : null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IPersistentSet)) {
            return false;
        }
        IPersistentSet m = (IPersistentSet)obj;
        if (m.count() != this.count() || m.hashCode() != this.hashCode()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.rest()) {
            if (m.contains(s.first())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = this.count();
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                Object e = s.first();
                hash = Util.hashCombine(hash, Util.hash(e));
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length >= this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }
}

