/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;

public class LazySeq
extends ASeq {
    IFn _firstFn;
    Object _first;
    IFn _restFn;
    ISeq _rest;

    public LazySeq(IFn firstFn, IFn restFn) {
        this._firstFn = firstFn;
        this._restFn = restFn;
        this._first = null;
        this._rest = null;
    }

    LazySeq(IPersistentMap meta, Object first, ISeq rest) {
        super(meta);
        this._first = first;
        this._rest = rest;
    }

    public synchronized Object first() {
        if (this._firstFn != null) {
            try {
                this._first = this._firstFn.invoke();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this._firstFn = null;
        }
        return this._first;
    }

    public synchronized ISeq rest() {
        this.first();
        if (this._restFn != null) {
            try {
                this._rest = (ISeq)this._restFn.invoke();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this._restFn = null;
        }
        return this._rest;
    }

    public synchronized LazySeq withMeta(IPersistentMap meta) {
        if (meta == this.meta()) {
            return this;
        }
        this.rest();
        return new LazySeq(meta, this._first, this._rest);
    }
}

